/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.AbstractNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.actions.ReplacePrefixAction;
import org.eclipse.wst.xml.ui.internal.dialogs.EditSchemaInfoDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditSchemaInfoAction
extends NodeAction {
    protected AbstractNodeActionManager manager;
    protected DOMNamespaceInfoManager namespaceInfoManager = new DOMNamespaceInfoManager();
    protected Node node;
    protected String resourceLocation;
    protected String title;

    public EditSchemaInfoAction(AbstractNodeActionManager manager, Node node, String resourceLocation, String title) {
        this.manager = manager;
        this.node = node;
        this.setText(title);
        this.resourceLocation = resourceLocation;
        this.title = title;
    }

    protected Map createPrefixMapping(List oldList, List newList) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Hashtable<String, NamespaceInfo> oldURIToPrefixTable = new Hashtable<String, NamespaceInfo>();
        Iterator i = oldList.iterator();
        while (i.hasNext()) {
            NamespaceInfo oldInfo = (NamespaceInfo)i.next();
            oldURIToPrefixTable.put(oldInfo.uri, oldInfo);
        }
        i = newList.iterator();
        while (i.hasNext()) {
            String oldPrefix;
            NamespaceInfo newInfo = (NamespaceInfo)i.next();
            NamespaceInfo oldInfo = (NamespaceInfo)oldURIToPrefixTable.get(newInfo.uri != null ? newInfo.uri : "");
            if (oldInfo == null) {
                oldInfo = (NamespaceInfo)newInfo.getProperty("oldCopy");
            }
            if (oldInfo == null) continue;
            String newPrefix = newInfo.prefix != null ? newInfo.prefix : "";
            String string = oldPrefix = oldInfo.prefix != null ? oldInfo.prefix : "";
            if (oldPrefix.equals(newPrefix)) continue;
            map.put(oldPrefix, newPrefix);
        }
        return map;
    }

    public Element getElement(Node node) {
        Element result = null;
        if (node.getNodeType() == 1) {
            result = (Element)node;
        } else if (node.getNodeType() == 9) {
            result = this.getRootElement((Document)node);
        }
        return result;
    }

    public Element getRootElement(Document document) {
        Element rootElement = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                rootElement = (Element)childNode;
                break;
            }
            ++i;
        }
        return rootElement;
    }

    public String getUndoDescription() {
        return this.title;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.validateEdit(this.manager.getModel(), shell)) {
            this.manager.beginNodeAction(this);
            Element element = this.getElement(this.node);
            if (element != null) {
                EditSchemaInfoDialog dialog = new EditSchemaInfoDialog(shell, (IPath)new Path(this.resourceLocation));
                List namespaceInfoList = this.namespaceInfoManager.getNamespaceInfoList(element);
                List oldNamespaceInfoList = NamespaceInfo.cloneNamespaceInfoList((List)namespaceInfoList);
                Iterator i = namespaceInfoList.iterator();
                while (i.hasNext()) {
                    NamespaceInfo info = (NamespaceInfo)i.next();
                    NamespaceInfo oldCopy = new NamespaceInfo(info);
                    info.setProperty("oldCopy", (Object)oldCopy);
                }
                dialog.setNamespaceInfoList(namespaceInfoList);
                dialog.create();
                dialog.getShell().setText(XMLUIMessages._UI_MENU_EDIT_SCHEMA_INFORMATION_TITLE);
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    List newInfoList = dialog.getNamespaceInfoList();
                    this.namespaceInfoManager.removeNamespaceInfo(element);
                    this.namespaceInfoManager.addNamespaceInfo(element, newInfoList, true);
                    Map prefixMapping = this.createPrefixMapping(oldNamespaceInfoList, namespaceInfoList);
                    if (prefixMapping.size() > 0) {
                        try {
                            this.manager.getModel().aboutToChangeModel();
                            ReplacePrefixAction replacePrefixAction = new ReplacePrefixAction(this.manager, element, prefixMapping);
                            replacePrefixAction.run();
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            this.manager.getModel().changedModel();
                            throw throwable;
                        }
                        this.manager.getModel().changedModel();
                    }
                }
            }
            this.manager.endNodeAction(this);
        }
    }
}

