/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.swt.BooleanButtonModelAdapter;
import org.eclipse.jpt.ui.internal.swt.CComboModelAdapter;
import org.eclipse.jpt.ui.internal.swt.ComboModelAdapter;
import org.eclipse.jpt.ui.internal.swt.SpinnerModelAdapter;
import org.eclipse.jpt.ui.internal.swt.TextFieldModelAdapter;
import org.eclipse.jpt.ui.internal.swt.TriStateCheckBoxModelAdapter;
import org.eclipse.jpt.ui.internal.util.ControlAligner;
import org.eclipse.jpt.ui.internal.util.LabeledButton;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPane<T extends Model> {
    private PropertyChangeListener aspectChangeListener;
    private Composite container;
    private ArrayList<AbstractPane<?>> internalPanesForEnablementControl;
    private ControlAligner leftControlAligner;
    private boolean populating;
    private ControlAligner rightControlAligner;
    private PropertyChangeListener subjectChangeListener;
    private PropertyValueModel<T> subjectHolder;
    private Collection<AbstractPane<?>> subPanes;
    private WidgetFactory widgetFactory;
    private ArrayList<Control> widgets;

    private AbstractPane() {
    }

    protected AbstractPane(AbstractPane<? extends T> parentPane, Composite parent) {
        this(parentPane, parent, true);
    }

    protected AbstractPane(AbstractPane<? extends T> parentPane, Composite parent, boolean automaticallyAlignWidgets) {
        this(parentPane, parentPane.getSubjectHolder(), parent, automaticallyAlignWidgets);
    }

    protected AbstractPane(AbstractPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        this(parentPane, subjectHolder, parent, true);
    }

    protected AbstractPane(AbstractPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        this(subjectHolder, parent, parentPane.getWidgetFactory());
        super.initialize(parentPane, automaticallyAlignWidgets);
    }

    protected AbstractPane(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        this.initialize(subjectHolder, widgetFactory);
        try {
            this.populating = true;
            this.container = this.buildContainer(parent);
            this.initializeLayout(this.container);
        }
        finally {
            this.populating = false;
        }
    }

    protected final void addAlignLeft(AbstractPane<?> container) {
        this.leftControlAligner.add(container.leftControlAligner);
    }

    protected final void addAlignLeft(Control control) {
        this.leftControlAligner.add(control);
    }

    protected final void addAlignRight(AbstractPane<?> container) {
        this.rightControlAligner.add(container.rightControlAligner);
    }

    protected final void addAlignRight(Control control) {
        this.rightControlAligner.add(control);
    }

    protected final void addPaneForAlignment(AbstractPane<?> container) {
        this.addAlignLeft(container);
        this.addAlignRight(container);
    }

    protected void addPropertyNames(Collection<String> propertyNames) {
    }

    public final void addToEnablementControl(Control control) {
        control.setData("enablement", null);
    }

    private PropertyChangeListener buildAspectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildAspectChangeListener_());
    }

    private PropertyChangeListener buildAspectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (e.getSource() == AbstractPane.this.subject()) {
                    AbstractPane.this.updatePane(e.getPropertyName());
                }
            }
        };
    }

    protected final Button buildButton(Composite container, String text, Runnable buttonAction) {
        return this.buildButton(container, text, null, buttonAction);
    }

    protected final Button buildButton(Composite container, String text, String helpId, final Runnable buttonAction) {
        Button button = this.widgetFactory.createButton(container, text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec(buttonAction);
            }
        });
        if (helpId != null) {
            this.helpSystem().setHelp((Control)button, helpId);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected final CCombo buildCCombo(Composite container) {
        CCombo combo = this.widgetFactory.createCCombo(container);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    protected final <V> CCombo buildCCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder) {
        return this.buildCCombo(container, listHolder, selectedItemHolder, StringConverter.Default.instance());
    }

    protected final <V> CCombo buildCCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        CCombo combo = this.buildCCombo(container);
        CComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer buildCComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        CCombo combo = this.buildCCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected final Button buildCheckBox(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder) {
        return this.buildCheckBox(parent, buttonText, booleanHolder, null);
    }

    protected final Button buildCheckBox(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.buildToggleButton(parent, buttonText, booleanHolder, helpId, 32);
    }

    protected final Composite buildCollapsableSection(Composite container, String sectionText) {
        return this.buildCollapsableSection(container, sectionText, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
    }

    private Composite buildCollapsableSection(Composite container, String sectionText, int type, PropertyValueModel<Boolean> expandedStateHolder) {
        Composite subPane = this.buildSection(container, sectionText, 2 | type);
        Section section = (Section)subPane.getParent();
        expandedStateHolder.addPropertyChangeListener("value", this.buildExpandedStateChangeListener(section));
        section.setExpanded(expandedStateHolder.getValue() != null ? (Boolean)expandedStateHolder.getValue() : true);
        return subPane;
    }

    protected final Composite buildCollapsableSection(Composite container, String sectionText, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.buildCollapsableSection(container, sectionText, 258, expandedStateHolder);
    }

    protected final Composite buildCollapsableSubSection(Composite container, String sectionText, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.buildCollapsableSection(container, sectionText, 0, expandedStateHolder);
    }

    protected final Combo buildCombo(Composite container) {
        Combo combo = this.widgetFactory.createCombo(container);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    protected final <V> Combo buildCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder) {
        return this.buildCombo(container, listHolder, selectedItemHolder, StringConverter.Default.instance());
    }

    protected final <V> Combo buildCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.buildCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer buildComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.buildCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected Composite buildContainer(Composite parent) {
        return this.buildSubPane(parent);
    }

    protected final CCombo buildEditableCCombo(Composite container) {
        CCombo combo = this.widgetFactory.createEditableCCombo(container);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    protected final <V> CCombo buildEditableCCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder) {
        return this.buildEditableCCombo(container, listHolder, selectedItemHolder, StringConverter.Default.instance());
    }

    protected final <V> CCombo buildEditableCCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        CCombo combo = this.buildEditableCCombo(container);
        CComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer buildEditableCComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        CCombo combo = this.buildEditableCCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected final Combo buildEditableCombo(Composite container) {
        Combo combo = this.widgetFactory.createEditableCombo(container);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    protected final <V> Combo buildEditableCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder) {
        return this.buildEditableCombo(container, listHolder, selectedItemHolder, StringConverter.Default.instance());
    }

    protected final <V> Combo buildEditableCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.buildEditableCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer buildEditableComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.buildEditableCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    private PropertyChangeListener buildExpandedStateChangeListener(Section section) {
        return new SWTPropertyChangeListenerWrapper(this.buildExpandedStateChangeListener_(section));
    }

    private PropertyChangeListener buildExpandedStateChangeListener_(final Section section) {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                Boolean value = (Boolean)e.getNewValue();
                if (value == null) {
                    value = Boolean.TRUE;
                }
                section.setExpanded(value.booleanValue());
            }
        };
    }

    protected final Hyperlink buildHyperLink(Composite parent, String text, final Runnable hyperLinkAction) {
        Hyperlink link = this.widgetFactory.createHyperlink(parent, text);
        this.widgets.add((Control)link);
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Hyperlink hyperLink = (Hyperlink)e.widget;
                if (hyperLink.isEnabled()) {
                    SWTUtil.asyncExec(hyperLinkAction);
                }
            }
        });
        return link;
    }

    protected final Label buildLabel(Composite container, String labelText) {
        return this.widgetFactory.createLabel(container, labelText);
    }

    protected final <V> CCombo buildLabeledCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, String helpId) {
        return this.buildLabeledCCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), helpId);
    }

    protected final <V> CCombo buildLabeledCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        CCombo combo = this.buildCCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> CCombo buildLabeledCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.buildLabeledCCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final CCombo buildLabeledCCombo(Composite container, String labelText, ModifyListener comboListener, Control rightControl, String helpId) {
        CCombo combo = this.buildCCombo(container);
        combo.addModifyListener(comboListener);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final CCombo buildLabeledCCombo(Composite container, String labelText, ModifyListener comboListener, String helpId) {
        return this.buildLabeledCCombo(container, labelText, comboListener, null, helpId);
    }

    protected final <V> Combo buildLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, Control rightControl, String helpId) {
        return this.buildLabeledCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), rightControl, helpId);
    }

    protected final <V> Combo buildLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, String helpId) {
        return this.buildLabeledCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), helpId);
    }

    protected final <V> Combo buildLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        Combo combo = this.buildCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> Combo buildLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.buildLabeledCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final Combo buildLabeledCombo(Composite container, String labelText, ModifyListener comboListener, Control rightControl, String helpId) {
        Combo combo = this.buildCombo(container);
        combo.addModifyListener(comboListener);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final Combo buildLabeledCombo(Composite container, String labelText, ModifyListener comboListener, String helpId) {
        return this.buildLabeledCombo(container, labelText, comboListener, null, helpId);
    }

    protected final Composite buildLabeledComposite(Composite container, Control leftControl, Control centerControl, Control rightControl, String helpId) {
        container = this.buildSubPane(container, 3, 5, 0, 0, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        leftControl.setLayoutData((Object)gridData);
        leftControl.setParent(container);
        this.leftControlAligner.add(leftControl);
        this.widgets.add(leftControl);
        centerControl.setLayoutData((Object)new GridData(768));
        this.widgets.add(centerControl);
        centerControl.setParent(container);
        if (helpId != null) {
            this.helpSystem().setHelp(centerControl, helpId);
        }
        if (rightControl == null) {
            Composite spacer = this.buildPane(container);
            spacer.setLayout(this.buildSpacerLayout());
            rightControl = spacer;
        } else {
            rightControl.setParent(container);
            if (helpId != null) {
                this.helpSystem().setHelp(rightControl, helpId);
            }
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = false;
        rightControl.setLayoutData((Object)gridData);
        this.rightControlAligner.add(rightControl);
        this.widgets.add(rightControl);
        return container;
    }

    protected final Composite buildLabeledComposite(Composite container, Control label, Control centerControl, String helpId) {
        return this.buildLabeledComposite(container, label, centerControl, null, helpId);
    }

    protected final Composite buildLabeledComposite(Composite container, Label label, Control centerControl) {
        return this.buildLabeledComposite(container, (Control)label, centerControl, null);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, AbstractPane<?> centerPane, Control rightCentrol, String helpId) {
        return this.buildLabeledComposite(container, labelText, (Control)centerPane.getControl(), rightCentrol, helpId);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, AbstractPane<?> centerPane, String helpId) {
        return this.buildLabeledComposite(container, labelText, (Control)centerPane.getControl(), helpId);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, Control centerControl) {
        return this.buildLabeledComposite(container, labelText, centerControl, null, null);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, Control centerControl, Control rightControl) {
        return this.buildLabeledComposite(container, labelText, centerControl, rightControl, null);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, Control centerControl, Control rightCentrol, String helpId) {
        return this.buildLabeledComposite(container, (Control)this.buildLabel(container, labelText), centerControl, rightCentrol, helpId);
    }

    protected final Composite buildLabeledComposite(Composite container, String labelText, Control centerControl, String helpId) {
        Label label = this.buildLabel(container, labelText);
        return this.buildLabeledComposite(container, (Control)label, centerControl, helpId);
    }

    protected final <V> CCombo buildLabeledEditableCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, Control rightControl, String helpId) {
        return this.buildLabeledEditableCCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), rightControl, helpId);
    }

    protected final <V> CCombo buildLabeledEditableCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, String helpId) {
        return this.buildLabeledEditableCCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), null, helpId);
    }

    protected final <V> CCombo buildLabeledEditableCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        CCombo combo = this.buildEditableCCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> CCombo buildLabeledEditableCCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.buildLabeledEditableCCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final CCombo buildLabeledEditableCCombo(Composite container, String labelText, ModifyListener comboListener, Control rightControl, String helpId) {
        CCombo combo = this.buildEditableCCombo(container);
        combo.addModifyListener(comboListener);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final CCombo buildLabeledEditableCCombo(Composite container, String labelText, ModifyListener comboListener, String helpId) {
        return this.buildLabeledEditableCCombo(container, labelText, comboListener, null, helpId);
    }

    protected final CCombo buildLabeledEditableCComboViewer(Composite container, String labelText, ModifyListener comboListener, ILabelProvider labelProvider, Control rightControl, String helpId) {
        ComboViewer comboViewer = this.buildEditableCComboViewer(container, (IBaseLabelProvider)labelProvider);
        CCombo combo = comboViewer.getCCombo();
        combo.addModifyListener(comboListener);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final CCombo buildLabeledEditableCComboViewer(Composite container, String labelText, ModifyListener comboListener, ILabelProvider labelProvider, String helpId) {
        return this.buildLabeledEditableCComboViewer(container, labelText, comboListener, null, helpId);
    }

    protected final <V> Combo buildLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, Control rightControl, String helpId) {
        return this.buildLabeledEditableCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), rightControl, helpId);
    }

    protected final <V> Combo buildLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, String helpId) {
        return this.buildLabeledEditableCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), null, helpId);
    }

    protected final <V> Combo buildLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        Combo combo = this.buildEditableCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> Combo buildLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.buildLabeledEditableCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final Combo buildLabeledEditableCombo(Composite container, String labelText, ModifyListener comboListener, Control rightControl, String helpId) {
        Combo combo = this.buildEditableCombo(container);
        combo.addModifyListener(comboListener);
        this.buildLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final Combo buildLabeledEditableCombo(Composite container, String labelText, ModifyListener comboListener, String helpId) {
        return this.buildLabeledEditableCombo(container, labelText, comboListener, null, helpId);
    }

    protected final Text buildLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder) {
        return this.buildLabeledMultiLineText(container, labelText, textHolder, null);
    }

    protected final Text buildLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, Control rightControl, String helpId) {
        Text text = this.buildMultiLineText(container, textHolder);
        this.buildLabeledComposite(container, labelText, (Control)text, rightControl, helpId);
        return text;
    }

    protected final Text buildLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, int lineCount) {
        return this.buildLabeledMultiLineText(container, labelText, textHolder, lineCount, null);
    }

    protected final Text buildLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, int lineCount, String helpId) {
        Text text = this.buildMultiLineText(container, textHolder, lineCount);
        container = this.buildLabeledComposite(container, labelText, (Control)text, helpId);
        int textHeight = text.computeSize((int)-1, (int)-1).y;
        GridData gridData = (GridData)text.getLayoutData();
        gridData.heightHint = text.getLineHeight() * lineCount;
        Control label = container.getChildren()[0];
        int labelHeight = label.computeSize((int)-1, (int)-1).y;
        gridData = (GridData)label.getLayoutData();
        gridData.verticalAlignment = 128;
        gridData.verticalIndent += Math.abs(textHeight - labelHeight) / 2;
        return text;
    }

    protected final Text buildLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.buildLabeledMultiLineText(container, labelText, textHolder, 3, helpId);
    }

    protected final Text buildLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder) {
        return this.buildLabeledPasswordText(container, labelText, textHolder, null);
    }

    protected final Text buildLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, Control rightComponent, String helpId) {
        Text text = this.buildPasswordText(container, textHolder);
        this.buildLabeledComposite(container, labelText, (Control)text, rightComponent, helpId);
        return text;
    }

    protected final Text buildLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.buildLabeledPasswordText(container, labelText, textHolder, null, helpId);
    }

    protected final Text buildLabeledPawordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.buildLabeledPasswordText(container, labelText, textHolder, null, helpId);
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue) {
        return this.buildLabeledSpinner(this.container, labelText, numberHolder, defaultValue, 0, Integer.MAX_VALUE, null, null);
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, Control rightControl) {
        return this.buildLabeledSpinner(this.container, labelText, numberHolder, defaultValue, 0, Integer.MAX_VALUE, rightControl, null);
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, Control rightControl) {
        return this.buildLabeledSpinner(parent, labelText, numberHolder, defaultValue, minimumValue, maximumValue, rightControl, null);
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, Control rightControl, String helpId) {
        Spinner spinner = this.buildSpinner(parent, numberHolder, defaultValue, minimumValue, maximumValue);
        this.buildLabeledComposite(parent, labelText, (Control)(spinner.getParent() != parent ? spinner.getParent() : spinner), rightControl, helpId);
        GridData gridData = (GridData)spinner.getLayoutData();
        gridData.horizontalAlignment = 1;
        return spinner;
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        return this.buildLabeledSpinner(parent, labelText, numberHolder, defaultValue, 0, Integer.MAX_VALUE, null, helpId);
    }

    protected final Spinner buildLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, String helpId) {
        return this.buildLabeledSpinner(parent, labelText, numberHolder, defaultValue, 0, Integer.MAX_VALUE, null, null);
    }

    protected final Text buildLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder) {
        return this.buildLabeledText(container, labelText, textHolder, null);
    }

    protected final Text buildLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, Control rightComponent, String helpId) {
        Text text = this.buildText(container);
        TextFieldModelAdapter.adapt(textHolder, text);
        this.buildLabeledComposite(container, labelText, (Control)text, rightComponent, helpId);
        return text;
    }

    protected final Text buildLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.buildLabeledText(container, labelText, textHolder, null, helpId);
    }

    protected final List buildList(Composite container) {
        return this.buildList(container, (String)null);
    }

    protected final List buildList(Composite container, String helpId) {
        return this.buildList(container, (WritablePropertyValueModel<String>)new SimplePropertyValueModel(), helpId);
    }

    protected final List buildList(Composite container, WritablePropertyValueModel<String> selectionHolder) {
        return this.buildList(container, selectionHolder, null);
    }

    protected final List buildList(Composite container, WritablePropertyValueModel<String> selectionHolder, String helpId) {
        List list = this.widgetFactory.createList(container, 2818);
        list.addSelectionListener(this.buildSelectionListener(selectionHolder));
        list.setLayoutData((Object)new GridData(1808));
        this.widgets.add((Control)list);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)list, helpId);
        }
        return list;
    }

    protected final void buildMultiLineLabel(Composite container, String labelText) {
        this.widgetFactory.createMultiLineLabel(container, labelText);
    }

    protected final Text buildMultiLineText(Composite container) {
        return this.buildMultiLineText(container, 3, null);
    }

    protected final Text buildMultiLineText(Composite container, int lineCount, String helpId) {
        Text text = this.widgetFactory.createMultiLineText(container);
        GridData gridData = new GridData(768);
        gridData.heightHint = text.getLineHeight() * lineCount;
        text.setLayoutData((Object)gridData);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text buildMultiLineText(Composite container, String helpId) {
        return this.buildMultiLineText(container, 3, helpId);
    }

    protected final Text buildMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder) {
        return this.buildMultiLineText(container, textHolder, null);
    }

    protected final Text buildMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder, int lineCount) {
        return this.buildMultiLineText(container, textHolder, lineCount, null);
    }

    protected final Text buildMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder, int lineCount, String helpId) {
        Text text = this.buildMultiLineText(container, lineCount, helpId);
        TextFieldModelAdapter.adapt(textHolder, text);
        return text;
    }

    protected final Text buildMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.buildMultiLineText(container, textHolder, 3, helpId);
    }

    protected final PageBook buildPageBook(Composite container) {
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        return pageBook;
    }

    protected final Composite buildPane(Composite parent) {
        return this.widgetFactory.createComposite(parent);
    }

    protected final Composite buildPane(Composite container, Layout layout) {
        container = this.widgetFactory.createComposite(container);
        container.setLayout(layout);
        container.setLayoutData((Object)new GridData(768));
        return container;
    }

    protected final Text buildPasswordText(Composite container, WritablePropertyValueModel<String> textHolder) {
        Text text = this.widgetFactory.createPasswordText(container);
        text.setLayoutData((Object)new GridData(768));
        TextFieldModelAdapter.adapt(textHolder, text);
        return text;
    }

    protected final Button buildPushButton(Composite parent, String buttonText, Runnable buttonAction) {
        return this.buildPushButton(parent, buttonText, null, buttonAction);
    }

    protected final Button buildPushButton(Composite parent, String buttonText, String helpId, final Runnable buttonAction) {
        Button button = this.widgetFactory.createPushButton(parent, buttonText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec(buttonAction);
            }
        });
        button.setLayoutData((Object)new GridData());
        if (helpId != null) {
            this.helpSystem().setHelp((Control)button, helpId);
        }
        return button;
    }

    protected final Button buildRadioButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder) {
        return this.buildRadioButton(parent, buttonText, booleanHolder, null);
    }

    protected final Button buildRadioButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.buildToggleButton(parent, buttonText, booleanHolder, helpId, 16);
    }

    protected final Composite buildSection(Composite container, String sectionText) {
        return this.buildSection(container, sectionText, 256);
    }

    private Composite buildSection(Composite container, String sectionText, int type) {
        return this.buildSection(container, sectionText, null, type);
    }

    protected final Composite buildSection(Composite container, String sectionText, String description) {
        return this.buildSection(container, sectionText, description, 256);
    }

    private Composite buildSection(Composite container, String sectionText, String description, int type) {
        Section section = this.widgetFactory.createSection(container, type | (description != null ? 128 : 0));
        section.setLayoutData((Object)new GridData(768));
        section.setText(sectionText);
        section.marginWidth = 0;
        section.marginHeight = 0;
        if (description != null) {
            section.setDescription(description);
        }
        Composite subPane = this.buildSubPane((Composite)section);
        section.setClient((Control)subPane);
        return subPane;
    }

    private SelectionListener buildSelectionListener(final WritablePropertyValueModel<String> selectionHolder) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)e.widget;
                String[] selectedItems = list.getSelection();
                if (selectedItems == null || selectedItems.length != 1) {
                    selectionHolder.setValue(null);
                } else {
                    selectionHolder.setValue((Object)selectedItems[0]);
                }
            }
        };
    }

    private Layout buildSpacerLayout() {
        return new Layout(){

            protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
                return new Point(widthHint, heightHint);
            }

            protected void layout(Composite composite, boolean flushCache) {
                GridData data = (GridData)composite.getLayoutData();
                composite.setBounds(0, 0, data.widthHint, data.heightHint);
            }
        };
    }

    protected final Spinner buildSpinner(Composite parent, WritablePropertyValueModel<Integer> numberHolder, int defaultValue) {
        return this.buildSpinner(parent, numberHolder, defaultValue, 0, Integer.MAX_VALUE);
    }

    protected final Spinner buildSpinner(Composite parent, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue) {
        return this.buildSpinner(parent, numberHolder, defaultValue, minimumValue, maximumValue, null);
    }

    protected final Spinner buildSpinner(Composite parent, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        Spinner spinner = this.widgetFactory.createSpinner(parent);
        spinner.setMinimum(minimumValue);
        spinner.setMaximum(maximumValue);
        spinner.setLayoutData((Object)new GridData(1));
        SpinnerModelAdapter.adapt(numberHolder, spinner, defaultValue);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)spinner, helpId);
        }
        return spinner;
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                AbstractPane.this.subjectChanged((Model)e.getOldValue(), (Model)e.getNewValue());
            }
        };
    }

    protected final Composite buildSubPane(Composite container) {
        return this.buildSubPane(container, 0);
    }

    protected final Composite buildSubPane(Composite container, int topMargin) {
        return this.buildSubPane(container, topMargin, 0);
    }

    protected final Composite buildSubPane(Composite container, int topMargin, int leftMargin) {
        return this.buildSubPane(container, topMargin, leftMargin, 0, 0);
    }

    protected final Composite buildSubPane(Composite container, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        return this.buildSubPane(container, 1, topMargin, leftMargin, bottomMargin, rightMargin);
    }

    protected final Composite buildSubPane(Composite container, int columnCount, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = topMargin;
        layout.marginLeft = leftMargin;
        layout.marginBottom = bottomMargin;
        layout.marginRight = rightMargin;
        container = this.buildPane(container, (Layout)layout);
        return container;
    }

    protected final Composite buildSubSection(Composite container, String sectionText) {
        return this.buildCollapsableSubSection(container, sectionText, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.TRUE));
    }

    protected final Table buildTable(Composite container) {
        return this.buildTable(container, null);
    }

    protected final Table buildTable(Composite container, int style) {
        return this.buildTable(container, style, null);
    }

    protected final Table buildTable(Composite container, int style, String helpId) {
        Table table = this.widgetFactory.createTable(container, style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = table.getItemHeight() * 4;
        table.setLayoutData((Object)gridData);
        this.widgets.add((Control)table);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)table, helpId);
        }
        return table;
    }

    protected final Table buildTable(Composite container, String helpId) {
        return this.buildTable(container, 66306, helpId);
    }

    protected final Text buildText(Composite container) {
        return this.widgetFactory.createText(container);
    }

    protected final Text buildText(Composite container, String helpId) {
        Text text = this.widgetFactory.createText(container);
        text.setLayoutData((Object)new GridData(768));
        if (helpId != null) {
            this.helpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text buildText(Composite container, WritablePropertyValueModel<String> textHolder) {
        return this.buildText(container, textHolder, null);
    }

    protected final Text buildText(Composite container, WritablePropertyValueModel<String> textHolder, String helpId) {
        Text text = this.widgetFactory.createText(container);
        text.setLayoutData((Object)new GridData(768));
        TextFieldModelAdapter.adapt(textHolder, text);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Group buildTitledPane(Composite container, String title) {
        return this.buildTitledPane(container, title, null);
    }

    protected final Group buildTitledPane(Composite container, String title, String helpId) {
        Group group = this.widgetFactory.createGroup(container, title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginBottom = 5;
        layout.marginRight = 5;
        group.setLayout((Layout)layout);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)group, helpId);
        }
        return group;
    }

    private Button buildToggleButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId, int toggleButtonType) {
        Button button = toggleButtonType == 8 ? this.widgetFactory.createPushButton(parent, buttonText) : (toggleButtonType == 16 ? this.widgetFactory.createRadioButton(parent, buttonText) : (toggleButtonType == 32 ? this.widgetFactory.createCheckBox(parent, buttonText) : this.widgetFactory.createButton(parent, buttonText)));
        button.setLayoutData((Object)new GridData());
        BooleanButtonModelAdapter.adapt(booleanHolder, button);
        this.widgets.add((Control)button);
        if (helpId != null) {
            this.helpSystem().setHelp((Control)button, helpId);
        }
        return button;
    }

    protected final TriStateCheckBox buildTriStateCheckBox(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder) {
        return this.buildTriStateCheckBox(parent, text, booleanHolder, null);
    }

    protected final TriStateCheckBox buildTriStateCheckBox(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        TriStateCheckBox checkBox = new TriStateCheckBox(parent, text, this.getWidgetFactory());
        TriStateCheckBoxModelAdapter.adapt(booleanHolder, checkBox);
        this.widgets.add((Control)checkBox.getCheckBox());
        if (helpId != null) {
            this.helpSystem().setHelp((Control)checkBox.getCheckBox(), helpId);
        }
        return checkBox;
    }

    protected final TriStateCheckBox buildTriStateCheckBoxWithDefault(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder, PropertyValueModel<String> stringHolder) {
        return this.buildTriStateCheckBoxWithDefault(parent, text, booleanHolder, stringHolder, null);
    }

    protected final TriStateCheckBox buildTriStateCheckBoxWithDefault(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder, PropertyValueModel<String> stringHolder, String helpId) {
        TriStateCheckBox checkBox = this.buildTriStateCheckBox(parent, text, booleanHolder, helpId);
        new LabeledControlUpdater(new LabeledButton(checkBox.getCheckBox()), stringHolder);
        return checkBox;
    }

    protected void disengageListeners() {
        this.log("/debug/ui/layout", "   ->disengageListeners()");
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.disengageListeners(this.subject());
        for (AbstractPane<?> subPane : this.subPanes) {
            subPane.disengageListeners();
        }
    }

    protected void disengageListeners(T subject) {
        if (subject != null) {
            for (String propertyName : this.propertyNames()) {
                subject.removePropertyChangeListener(propertyName, this.aspectChangeListener);
            }
        }
    }

    public final void dispose() {
        if (!this.container.isDisposed()) {
            this.log("/debug/ui/layout", "dispose()");
            this.performDispose();
            this.disengageListeners();
        }
    }

    protected void doDispose() {
        this.log("/debug/ui/layout", "   ->doDispose()");
        this.leftControlAligner.dispose();
        this.rightControlAligner.dispose();
    }

    protected void doPopulate() {
        this.log("/debug/ui/layout", "   ->doPopulate()");
    }

    private void enableChildren(boolean enabled) {
        if (this.isEnablementManaged((Control)this.container)) {
            for (Control control : this.widgets) {
                if (!this.isEnablementManaged(control)) continue;
                control.setEnabled(enabled);
            }
        }
    }

    public void enableWidgets(boolean enabled) {
        if (!this.container.isDisposed()) {
            this.enableChildren(enabled);
            for (AbstractPane<?> subPane : this.subPanes) {
                if (!this.isPaneEnablementManaged(subPane)) continue;
                subPane.enableWidgets(enabled);
            }
        }
    }

    protected void engageListeners() {
        this.log("/debug/ui/layout", "   ->engageListeners()");
        this.engageSubjectHolder();
        this.engageListeners(this.subject());
        for (AbstractPane<?> subPane : this.subPanes) {
            subPane.engageListeners();
        }
    }

    protected void engageListeners(T subject) {
        if (subject != null) {
            for (String propertyName : this.propertyNames()) {
                subject.addPropertyChangeListener(propertyName, this.aspectChangeListener);
            }
        }
    }

    private void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
    }

    public Composite getControl() {
        return this.container;
    }

    protected final PropertyValueModel<T> getSubjectHolder() {
        return this.subjectHolder;
    }

    protected final WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected final int groupBoxMargin() {
        Group group = this.widgetFactory.createGroup((Composite)SWTUtil.getShell(), "");
        Rectangle clientArea = group.getClientArea();
        group.dispose();
        return clientArea.x + 5;
    }

    protected final IWorkbenchHelpSystem helpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    protected void initialize() {
    }

    private void initialize(AbstractPane<?> parentPane, boolean automaticallyAlignWidgets) {
        parentPane.registerSubPane(this);
        if (automaticallyAlignWidgets) {
            parentPane.leftControlAligner.add(this.leftControlAligner);
            parentPane.rightControlAligner.add(this.rightControlAligner);
        }
    }

    private void initialize(PropertyValueModel<? extends T> subjectHolder, WidgetFactory widgetFactory) {
        Assert.isNotNull(subjectHolder, (String)"The subject holder cannot be null");
        this.subjectHolder = subjectHolder;
        this.widgetFactory = widgetFactory;
        this.subPanes = new ArrayList();
        this.widgets = new ArrayList();
        this.leftControlAligner = new ControlAligner();
        this.rightControlAligner = new ControlAligner();
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.aspectChangeListener = this.buildAspectChangeListener();
        this.internalPanesForEnablementControl = new ArrayList();
        this.initialize();
    }

    protected abstract void initializeLayout(Composite var1);

    public final boolean isEnablementManaged(Control control) {
        return control.getData("enablement") != Boolean.FALSE;
    }

    private boolean isPaneEnablementManaged(AbstractPane<?> subPane) {
        return this.isEnablementManaged((Control)this.container) && this.internalPanesForEnablementControl.contains(subPane) || this.isEnablementManaged((Control)subPane.getControl());
    }

    protected final boolean isPopulating() {
        return this.populating;
    }

    protected void log(String flag, String message) {
        if ("/debug/ui/layout".equals(flag) && Tracing.booleanDebugOption("/debug/ui/layout")) {
            Class<?> thisClass = this.getClass();
            String className = ClassTools.shortNameFor(thisClass);
            if (thisClass.isAnonymousClass()) {
                className = className.substring(0, className.indexOf(36));
                className = String.valueOf(className) + "->" + ClassTools.shortNameFor(thisClass.getSuperclass());
            }
            Tracing.log(String.valueOf(className) + ": " + message);
        }
    }

    protected void performDispose() {
        this.log("/debug/ui/layout", "   ->performDispose()");
        this.doDispose();
        for (AbstractPane<?> subPane : this.subPanes) {
            subPane.performDispose();
        }
    }

    public final void populate() {
        if (!this.container.isDisposed()) {
            this.log("/debug/ui/layout", "populate()");
            this.engageListeners();
            this.repopulate();
        }
    }

    protected void propertyChanged(String propertyName) {
    }

    protected Collection<String> propertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        this.addPropertyNames(propertyNames);
        return propertyNames;
    }

    protected final void registerSubPane(AbstractPane<?> subPane) {
        this.subPanes.add(subPane);
    }

    protected final void removeAlignLeft(AbstractPane<?> pane) {
        this.leftControlAligner.remove(pane.leftControlAligner);
    }

    protected final void removeAlignLeft(Control control) {
        this.leftControlAligner.remove(control);
    }

    protected final void removeAlignRight(AbstractPane<?> pane) {
        this.rightControlAligner.remove(pane.rightControlAligner);
    }

    protected final void removeAlignRight(Control control) {
        this.rightControlAligner.remove(control);
    }

    public void removeFromEnablementControl(AbstractPane<?> pane) {
        this.removeFromEnablementControl((Control)pane.getControl());
        this.internalPanesForEnablementControl.add(pane);
    }

    public void removeFromEnablementControl(Control control) {
        control.setData("enablement", (Object)Boolean.FALSE);
    }

    protected final void removePaneForAlignment(AbstractPane<?> pane) {
        this.removeAlignLeft(pane);
        this.removeAlignRight(pane);
    }

    protected final void repopulate() {
        this.log("/debug/ui/layout", "   ->repopulate()");
        try {
            this.setPopulating(true);
            this.doPopulate();
        }
        finally {
            this.setPopulating(false);
        }
        for (AbstractPane<?> subPane : this.subPanes) {
            subPane.repopulate();
        }
    }

    protected boolean repopulateWithNullSubject() {
        return true;
    }

    protected final void setPopulating(boolean populating) {
        this.populating = populating;
    }

    public void setVisible(boolean visible) {
        if (!this.container.isDisposed()) {
            this.container.setVisible(visible);
        }
    }

    protected final Shell shell() {
        return this.container.getShell();
    }

    protected T subject() {
        return (T)((Model)this.subjectHolder.getValue());
    }

    protected final void subjectChanged(T oldSubject, T newSubject) {
        if (!this.container.isDisposed()) {
            this.log("/debug/ui/layout", "subjectChanged()");
            this.disengageListeners(oldSubject);
            if (newSubject != null || newSubject == null && this.repopulateWithNullSubject()) {
                this.repopulate();
            }
            this.engageListeners(newSubject);
        }
    }

    protected final void unregisterSubPane(AbstractPane<?> subPane) {
        this.subPanes.remove(subPane);
    }

    private void updatePane(String propertyName) {
        if (!this.isPopulating() && !this.container.isDisposed()) {
            this.populating = true;
            try {
                this.propertyChanged(propertyName);
            }
            finally {
                this.populating = false;
            }
        }
    }
}

