/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.service.prefs.BackingStoreException;

public final class J2EEFacetRuntimeChangedDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IRuntimeChangedEvent event = (IRuntimeChangedEvent)cfg;
            this.removeClasspathEntries(project, fv, event.getOldRuntime());
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void removeClasspathEntries(IProject project, IProjectFacetVersion fv, IRuntime oldRuntime) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        List cp = this.getClasspath(jproj);
        boolean hasPrefs = this.hasClasspathPreferencesNode(project);
        if (!hasPrefs) {
            this.removeOnlyCPEntries(project, fv, jproj, cp, oldRuntime);
        } else {
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
        }
    }

    private boolean hasClasspathPreferencesNode(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
        boolean classpathNodeExists = false;
        try {
            classpathNodeExists = pluginRoot.nodeExists("classpath.helper");
        }
        catch (BackingStoreException e) {
            J2EEPlugin.logError(e);
        }
        return classpathNodeExists;
    }

    private void removeOnlyCPEntries(IProject project, IProjectFacetVersion fv, IJavaProject jproj, List cp, IRuntime oldRuntime) throws CoreException {
        IRuntime runtime;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        IRuntime iRuntime = runtime = oldRuntime != null ? oldRuntime : fproj.getPrimaryRuntime();
        if (runtime != null) {
            IClasspathProvider cpprov = (IClasspathProvider)runtime.getAdapter(IClasspathProvider.class);
            List cpentries = cpprov.getClasspathEntries(fv);
            boolean realCPChanged = false;
            if (cpentries != null) {
                block0: for (IClasspathEntry cpentry : cpentries) {
                    IPath path = cpentry.getPath();
                    boolean contains = cp.contains(cpentry);
                    if (!contains) continue;
                    Iterator itr2 = cp.iterator();
                    while (itr2.hasNext()) {
                        IClasspathEntry realEntry = (IClasspathEntry)itr2.next();
                        if (!realEntry.getPath().equals((Object)path)) continue;
                        itr2.remove();
                        realCPChanged = true;
                        continue block0;
                    }
                }
            }
            if (realCPChanged) {
                IClasspathEntry[] newcp = cp.toArray(new IClasspathEntry[cp.size()]);
                jproj.setRawClasspath(newcp, null);
            }
        }
    }

    private List getClasspath(IJavaProject jproj) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            list.add(cp[i]);
            ++i;
        }
        return list;
    }
}

