/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableLabelProvider;
import org.eclipse.wst.server.ui.internal.view.servers.ServerViewerComparator;
import org.eclipse.wst.server.ui.internal.view.servers.ServersView;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerTableViewer
extends TreeViewer {
    protected static final String ROOT = "root";
    protected static Color color;
    protected static Font font;
    protected Clipboard clipboard;
    protected IServerLifecycleListener serverResourceListener;
    protected IPublishListener publishListener;
    protected IServerListener serverListener;
    protected static Object deletedElement;
    protected static Set<String> publishing;
    protected static Set<String> starting;
    protected ServerTableLabelProvider labelProvider;
    protected ILabelProviderListener labelProviderListener;
    protected ServersView view;
    protected boolean animationActive = false;
    protected boolean stopAnimation = false;

    static {
        deletedElement = null;
        publishing = new HashSet<String>(4);
        starting = new HashSet<String>(4);
    }

    protected void startThread() {
        Runnable[] animator;
        if (this.animationActive) {
            return;
        }
        this.stopAnimation = false;
        final Display display = this.getTree().getDisplay();
        animator = new Runnable[]{new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!ServerTableViewer.this.stopAnimation) {
                    try {
                        String[] servers;
                        ServerTableViewer.this.labelProvider.animate();
                        int size = 0;
                        Set<String> set = starting;
                        synchronized (set) {
                            size = starting.size();
                            servers = new String[size];
                            starting.toArray(servers);
                        }
                        int i = 0;
                        while (i < size) {
                            IServer server = ServerCore.findServer((String)servers[i]);
                            if (server != null && ServerTableViewer.this.getTree() != null && !ServerTableViewer.this.getTree().isDisposed()) {
                                ServerTableViewer.this.updateAnimation(server);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Trace.trace((byte)4, "Error in Servers view animation", e);
                    }
                    display.timerExec(200, animator[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                display.timerExec(200, animator[0]);
            }
        });
    }

    protected void stopThread() {
        this.stopAnimation = true;
    }

    public ServerTableViewer(ServersView view, Tree tree) {
        super(tree);
        this.view = view;
        this.clipboard = new Clipboard(tree.getDisplay());
    }

    protected void initialize() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.setContentProvider((IContentProvider)new ServerContentProvider());
        this.labelProvider = new ServerTableLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setComparator(new ServerViewerComparator(this.labelProvider));
        this.setInput(ROOT);
        this.addListeners();
        if (color == null) {
            Display display = this.getControl().getDisplay();
            color = display.getSystemColor(16);
            FontData[] fd = this.getControl().getFont().getFontData();
            int size = fd.length;
            int i = 0;
            while (i < size) {
                fd[i].setStyle(2);
                ++i;
            }
            font = new Font((Device)display, fd);
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] obj = event.getElements();
        if (obj == null) {
            this.refresh(true);
        } else {
            obj = this.adaptLabelChangeObjects(obj);
            int size = obj.length;
            int i = 0;
            while (i < size) {
                this.update(obj[i], null);
                ++i;
            }
        }
    }

    protected void resortTable(final TreeColumn column, int col) {
        ServerViewerComparator sorter = (ServerViewerComparator)this.getComparator();
        if (col == sorter.getTopPriority()) {
            sorter.reverseTopPriority();
        } else {
            sorter.setTopPriority(col);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ServerTableViewer.this.refresh();
                ServerTableViewer.this.updateDirectionIndicator(column);
            }
        });
    }

    protected void updateDirectionIndicator(TreeColumn column) {
        this.getTree().setSortColumn(column);
        if (((ServerViewerComparator)this.getComparator()).getTopPriorityDirection() == 1) {
            this.getTree().setSortDirection(128);
        } else {
            this.getTree().setSortDirection(1024);
        }
    }

    protected Object[] adaptLabelChangeObjects(Object[] obj) {
        if (obj == null) {
            return obj;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int size = obj.length;
        int i = 0;
        while (i < size) {
            if (obj[i] instanceof IModule) {
                list.add(obj[i]);
            } else if (obj[i] instanceof IServer) {
                list.add(obj[i]);
            } else if (obj[i] instanceof ModuleServer) {
                list.add(obj[i]);
            } else if (obj[i] instanceof IProject) {
                IProject proj = (IProject)obj[i];
                ArrayList<Object> list2 = new ArrayList<Object>();
                this.getTreeChildren(list2, (Widget)this.view.treeTable);
                for (Object e : list2) {
                    if (!(e instanceof ModuleServer)) continue;
                    ModuleServer ms = (ModuleServer)e;
                    if (!proj.equals((Object)ms.module[ms.module.length - 1].getProject())) continue;
                    list.add(ms);
                }
            }
            ++i;
        }
        Object[] o = new Object[list.size()];
        list.toArray(o);
        return o;
    }

    private void getTreeChildren(List<Object> list, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            if (data != null) {
                list.add(data);
            }
            if (this.getExpanded(item)) {
                this.getTreeChildren(list, (Widget)item);
            }
            ++i;
        }
    }

    protected void addListeners() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                ServerTableViewer.this.addServer(server);
                server.addServerListener(ServerTableViewer.this.serverListener);
                ((Server)server).addPublishListener(ServerTableViewer.this.publishListener);
            }

            public void serverChanged(IServer server) {
                ServerTableViewer.this.refreshServer(server);
            }

            public void serverRemoved(IServer server) {
                ServerTableViewer.this.removeServer(server);
                server.removeServerListener(ServerTableViewer.this.serverListener);
                ((Server)server).removePublishListener(ServerTableViewer.this.publishListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        this.publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServerTableViewer.this.handlePublishChange(server, true);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServerTableViewer.this.handlePublishChange(server, false);
            }
        };
        this.serverListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if ((eventKind & 0x10) != 0) {
                    if ((eventKind & 1) != 0) {
                        ServerTableViewer.this.refreshServer(server);
                        int state = event.getState();
                        String id = server.getId();
                        if (state == 1 || state == 3) {
                            boolean startThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (!starting.contains(id)) {
                                    if (starting.isEmpty()) {
                                        startThread = true;
                                    }
                                    starting.add(id);
                                }
                            }
                            if (startThread) {
                                ServerTableViewer.this.startThread();
                            }
                        } else {
                            boolean stopThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (starting.contains(id)) {
                                    starting.remove(id);
                                    if (starting.isEmpty()) {
                                        stopThread = true;
                                    }
                                }
                            }
                            if (stopThread) {
                                ServerTableViewer.this.stopThread();
                            }
                        }
                    } else {
                        ServerTableViewer.this.refreshServer(server);
                    }
                } else if ((eventKind & 0x20) != 0 && ((eventKind & 1) != 0 || (eventKind & 2) != 0)) {
                    ServerTableViewer.this.refreshServer(server);
                }
            }
        };
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(this.serverListener);
                ((Server)servers[i]).addPublishListener(this.publishListener);
                ++i;
            }
        }
        this.labelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                ServerTableViewer.this.handleLabelProviderChanged(event);
            }
        };
        this.labelProvider.addListener(this.labelProviderListener);
    }

    protected void refreshServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ServerTableViewer.this.refresh(server);
                    ISelection sel = ServerTableViewer.this.getSelection();
                    ServerTableViewer.this.setSelection(sel);
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        this.stopThread();
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (this.serverListener != null) {
                    servers[i].removeServerListener(this.serverListener);
                }
                if (this.publishListener != null) {
                    ((Server)servers[i]).removePublishListener(this.publishListener);
                }
                ++i;
            }
        }
        if (this.labelProvider != null && this.labelProviderListener != null) {
            this.labelProvider.removeListener(this.labelProviderListener);
        }
        this.clipboard.dispose();
        super.handleDispose(event);
    }

    protected void handlePublishChange(IServer server, boolean isPublishing) {
        String serverId = server.getId();
        if (isPublishing) {
            publishing.add(serverId);
        } else {
            publishing.remove(serverId);
        }
        this.refreshServer(server);
    }

    protected void handleServerModulesChanged(IServer server2) {
        if (server2 == null) {
            return;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (server2.equals(servers[i])) {
                    this.refresh(servers[i]);
                }
                ++i;
            }
        }
    }

    protected void handleServerResourceAdded(IServer server) {
        this.add(null, server);
    }

    protected void handleServerResourceChanged(IServer server) {
        this.refresh(server);
    }

    protected void handleServerResourceRemoved(IServer server) {
        this.remove(server);
        String serverId = server.getId();
        publishing.remove(serverId);
        this.view.getViewSite().getActionBars().getStatusLineManager().setMessage(null, null);
    }

    protected void addServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerTableViewer.this.add(ServerTableViewer.ROOT, server);
            }
        });
    }

    protected void removeServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerTableViewer.this.remove(server);
            }
        });
    }

    public void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TreeItem && color != null) {
            TreeItem item = (TreeItem)widget;
            if (element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)element;
                IModule m = ms.module[ms.module.length - 1];
                if (m.isExternal()) {
                    item.setForeground(color);
                } else {
                    item.setForeground(null);
                }
                if (ms.server.getModulePublishState(ms.module) != 1) {
                    item.setFont(0, font);
                } else {
                    item.setFont(0, null);
                }
            }
        }
        super.doUpdateItem(widget, element, fullMap);
    }

    protected void updateAnimation(IServer server) {
        try {
            Widget widget = this.doFindItem(server);
            TreeItem item = (TreeItem)widget;
            item.setText(1, this.labelProvider.getColumnText(server, 1));
            item.setImage(1, this.labelProvider.getColumnImage(server, 1));
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error in optimized animation", e);
        }
    }

    public class ServerContentProvider
    extends BaseContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object element) {
            ArrayList<IServer> list = new ArrayList<IServer>();
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    if (!((Server)servers[i]).isPrivate()) {
                        list.add(servers[i]);
                    }
                    ++i;
                }
            }
            return list.toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)element;
                try {
                    IModule[] children = ms.server.getChildModules(ms.module, null);
                    int size = children.length;
                    Object[] ms2 = new ModuleServer[size];
                    int i = 0;
                    while (i < size) {
                        int size2 = ms.module.length;
                        IModule[] module = new IModule[size2 + 1];
                        System.arraycopy(ms.module, 0, module, 0, size2);
                        module[size2] = children[i];
                        ms2[i] = new ModuleServer(ms.server, module);
                        ++i;
                    }
                    return ms2;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            IServer server = (IServer)element;
            IModule[] modules = server.getModules();
            int size = modules.length;
            Object[] ms = new ModuleServer[size];
            int i = 0;
            while (i < size) {
                ms[i] = new ModuleServer(server, new IModule[]{modules[i]});
                ++i;
            }
            return ms;
        }

        public Object getParent(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)element;
                return ms.server;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ModuleServer) {
                ModuleServer curModuleServer = (ModuleServer)element;
                IServer curServer = curModuleServer.server;
                IModule[] curModule = curModuleServer.module;
                if (curServer != null && curModule != null) {
                    IModule[] curChildModule = curServer.getChildModules(curModule, null);
                    return curChildModule != null && curChildModule.length > 0;
                }
                return false;
            }
            IServer server = (IServer)element;
            return server.getModules().length > 0;
        }
    }
}

