/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.internal.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;

public class PortGenerator
extends BaseGenerator {
    private Service service;
    private String addressLocation = "http://www.example.org/";

    public PortGenerator(Service service) {
        this.service = service;
        this.definition = service.getEnclosingDefinition();
    }

    public void setAddressLocation(String location) {
        this.addressLocation = location;
    }

    public Port generatePort() {
        String portName = this.getName();
        String bindingName = this.getRefName();
        Binding binding = this.getBinding(bindingName);
        Port port = WSDLFactory.eINSTANCE.createPort();
        port.setName(portName);
        port.setEnclosingDefinition(this.definition);
        port.setBinding(binding);
        this.service.addPort(port);
        ContentGenerator contentGenerator = this.getContentGenerator();
        if (contentGenerator != null) {
            this.addRequiredNamespaces(this.service.getEnclosingDefinition());
            contentGenerator.setAddressLocation(this.addressLocation);
            contentGenerator.generatePortContent(port);
        }
        return port;
    }

    protected void addRequiredNamespaces(Definition definition) {
        if (this.contentGenerator != null) {
            String[] namespaceNames = this.contentGenerator.getRequiredNamespaces();
            String[] preferredPrefixes = new String[namespaceNames.length];
            int index = 0;
            while (index < namespaceNames.length) {
                preferredPrefixes[index] = this.contentGenerator.getPreferredNamespacePrefix(namespaceNames[index]);
                ++index;
            }
            Map map = definition.getNamespaces();
            int i = 0;
            while (i < namespaceNames.length) {
                String namespace = namespaceNames[i];
                if (!map.containsValue(namespace)) {
                    String prefix;
                    String string = prefix = i < preferredPrefixes.length ? preferredPrefixes[i] : "p0";
                    if (map.containsKey(prefix)) {
                        prefix = this.computeUniquePrefix("p", map);
                    }
                    definition.addNamespace(prefix, namespace);
                }
                ++i;
            }
        }
    }

    private String computeUniquePrefix(String base, Map table) {
        int i = 0;
        String prefix = base;
        while (table.containsKey(prefix)) {
            prefix = String.valueOf(base) + i;
            ++i;
        }
        return prefix;
    }

    private Binding getBinding(String bindingName) {
        List allBindings = this.getAllBindings();
        Iterator bindingIterator = allBindings.iterator();
        while (bindingIterator.hasNext()) {
            Binding binding = (Binding)bindingIterator.next();
            List prefixedNames = this.getPrefixedNames(binding);
            if (!prefixedNames.contains(bindingName)) continue;
            return binding;
        }
        return null;
    }

    public List getAllBindings() {
        ArrayList allBindings = new ArrayList();
        List allDefinitions = this.getAllDefinitions();
        Iterator defsIterator = allDefinitions.iterator();
        while (defsIterator.hasNext()) {
            Definition definition = (Definition)defsIterator.next();
            Map bindings = definition.getBindings();
            allBindings.addAll(bindings.values());
        }
        return allBindings;
    }

    private void addDefinition(Definition definition, List list) {
        list.add(definition);
        EList imports = definition.getEImports();
        Iterator importsIterator = imports.iterator();
        while (importsIterator.hasNext()) {
            Definition importedDefinition;
            Import theImport = (Import)importsIterator.next();
            String importLocationURI = theImport.getLocationURI();
            if (importLocationURI == null || !importLocationURI.endsWith("wsdl") || (importedDefinition = theImport.getEDefinition()) == null || list.contains(importedDefinition)) continue;
            this.addDefinition(importedDefinition, list);
        }
    }

    private List getAllDefinitions() {
        ArrayList list = new ArrayList();
        this.addDefinition(this.definition, list);
        return list;
    }

    private List getPrefixedNames(Binding binding) {
        ArrayList<String> prefixedNames = new ArrayList<String>();
        String currentBindingName = binding.getQName().getLocalPart();
        String currentNamespace = binding.getQName().getNamespaceURI();
        Map namespaceMap = this.definition.getNamespaces();
        Iterator keys = namespaceMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = namespaceMap.get(key);
            if (!currentNamespace.equals(value)) continue;
            prefixedNames.add(key + ":" + currentBindingName);
        }
        return prefixedNames;
    }

    public Service getService() {
        return this.service;
    }
}

