/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.SequenceGenerator;
import org.eclipse.dali.core.adapters.ISequenceGeneratorModelAdapter;
import org.eclipse.dali.core.impl.GeneratorImpl;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Sequence;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class SequenceGeneratorImpl
extends GeneratorImpl
implements SequenceGenerator {
    protected static final String DEFAULT_SEQUENCE_NAME_EDEFAULT = null;
    protected String defaultSequenceName = DEFAULT_SEQUENCE_NAME_EDEFAULT;
    protected static final String SPECIFIED_SEQUENCE_NAME_EDEFAULT = null;
    protected String specifiedSequenceName = SPECIFIED_SEQUENCE_NAME_EDEFAULT;
    protected static final String SEQUENCE_NAME_EDEFAULT = null;

    protected SequenceGeneratorImpl() {
    }

    protected SequenceGeneratorImpl(ISequenceGeneratorModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getSequenceGenerator();
    }

    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    public void setDefaultSequenceName(String newDefaultSequenceName) {
        String oldDefaultSequenceName = this.defaultSequenceName;
        this.defaultSequenceName = newDefaultSequenceName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldDefaultSequenceName, (Object)this.defaultSequenceName));
        }
    }

    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    public void setSpecifiedSequenceNameGen(String newSpecifiedSequenceName) {
        String oldSpecifiedSequenceName = this.specifiedSequenceName;
        this.specifiedSequenceName = newSpecifiedSequenceName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSpecifiedSequenceName, (Object)this.specifiedSequenceName));
        }
    }

    public void setSpecifiedSequenceName(String newSpecifiedSequenceName) {
        this.setSpecifiedSequenceNameGen(newSpecifiedSequenceName);
        ((ISequenceGeneratorModelAdapter)this.getModelAdapter()).specifiedSequenceNameChanged();
    }

    public String getSequenceName() {
        return this.getSpecifiedSequenceName() == null ? this.getDefaultSequenceName() : this.getSpecifiedSequenceName();
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getSpecifiedName();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return new Integer(this.getInitialValue());
            }
            case 3: {
                return new Integer(this.getDefaultInitialValue());
            }
            case 4: {
                return new Integer(this.getSpecifiedInitialValue());
            }
            case 5: {
                return new Integer(this.getAllocationSize());
            }
            case 6: {
                return new Integer(this.getDefaultAllocationSize());
            }
            case 7: {
                return new Integer(this.getSpecifiedAllocationSize());
            }
            case 8: {
                return this.getDefaultSequenceName();
            }
            case 9: {
                return this.getSpecifiedSequenceName();
            }
            case 10: {
                return this.getSequenceName();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 3: {
                this.setDefaultInitialValue((Integer)newValue);
                return;
            }
            case 4: {
                this.setSpecifiedInitialValue((Integer)newValue);
                return;
            }
            case 6: {
                this.setDefaultAllocationSize((Integer)newValue);
                return;
            }
            case 7: {
                this.setSpecifiedAllocationSize((Integer)newValue);
                return;
            }
            case 8: {
                this.setDefaultSequenceName((String)newValue);
                return;
            }
            case 9: {
                this.setSpecifiedSequenceName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setDefaultInitialValue(0);
                return;
            }
            case 4: {
                this.setSpecifiedInitialValue(0);
                return;
            }
            case 6: {
                this.setDefaultAllocationSize(0);
                return;
            }
            case 7: {
                this.setSpecifiedAllocationSize(0);
                return;
            }
            case 8: {
                this.setDefaultSequenceName(DEFAULT_SEQUENCE_NAME_EDEFAULT);
                return;
            }
            case 9: {
                this.setSpecifiedSequenceName(SPECIFIED_SEQUENCE_NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 2: {
                return this.getInitialValue() != 0;
            }
            case 3: {
                return this.defaultInitialValue != 0;
            }
            case 4: {
                return this.specifiedInitialValue != 0;
            }
            case 5: {
                return this.getAllocationSize() != 0;
            }
            case 6: {
                return this.defaultAllocationSize != 0;
            }
            case 7: {
                return this.specifiedAllocationSize != 0;
            }
            case 8: {
                return DEFAULT_SEQUENCE_NAME_EDEFAULT == null ? this.defaultSequenceName != null : !DEFAULT_SEQUENCE_NAME_EDEFAULT.equals(this.defaultSequenceName);
            }
            case 9: {
                return SPECIFIED_SEQUENCE_NAME_EDEFAULT == null ? this.specifiedSequenceName != null : !SPECIFIED_SEQUENCE_NAME_EDEFAULT.equals(this.specifiedSequenceName);
            }
            case 10: {
                return SEQUENCE_NAME_EDEFAULT == null ? this.getSequenceName() != null : !SEQUENCE_NAME_EDEFAULT.equals(this.getSequenceName());
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultSequenceName: ");
        result.append(this.defaultSequenceName);
        result.append(", specifiedSequenceName: ");
        result.append(this.specifiedSequenceName);
        result.append(')');
        return result.toString();
    }

    public Sequence getSequence() {
        Schema schema = this.getPersistenceProject().getSchema();
        return schema == null ? null : schema.sequenceNamed(this.getSequenceName());
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addUnresolvedSequenceGeneratorProblemTo(problems);
    }

    private void addUnresolvedSequenceGeneratorProblemTo(List problems) {
        Sequence sequence;
        if (this.getPersistenceProject().getConnectionInfo().isConnected() && (sequence = this.getSequence()) == null) {
            problems.add(this.buildProblem("Sequence generator \"" + this.getSequenceName() + "\" cannot be resolved", this.getTextRange()));
        }
    }
}

