/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.core.impl.PersistenceSourceRefElementImpl;
import org.eclipse.dali.core.impl.RelationshipMappingImpl;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class JoinColumnImpl
extends PersistenceSourceRefElementImpl
implements JoinColumn {
    protected static final String DEFAULT_TABLE_NAME_EDEFAULT = null;
    protected String defaultTableName = DEFAULT_TABLE_NAME_EDEFAULT;
    protected static final String SPECIFIED_TABLE_NAME_EDEFAULT = null;
    protected String specifiedTableName = SPECIFIED_TABLE_NAME_EDEFAULT;
    protected static final String TABLE_NAME_EDEFAULT = null;
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected static final String DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String defaultReferencedColumnName = DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT;
    protected static final String SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String specifiedReferencedColumnName = SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT;
    protected static final String REFERENCED_COLUMN_NAME_EDEFAULT = null;

    protected JoinColumnImpl() {
    }

    protected JoinColumnImpl(IJoinColumnModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getJoinColumn();
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String newDefaultTableName) {
        String oldDefaultTableName = this.defaultTableName;
        this.defaultTableName = newDefaultTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDefaultTableName, (Object)this.defaultTableName));
        }
    }

    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    public void setSpecifiedTableNameGen(String newSpecifiedTableName) {
        String oldSpecifiedTableName = this.specifiedTableName;
        this.specifiedTableName = newSpecifiedTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedTableName, (Object)this.specifiedTableName));
        }
    }

    public void setSpecifiedTableName(String newSpecifiedTableName) {
        this.setSpecifiedTableNameGen(newSpecifiedTableName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedTableNameChanged();
    }

    public String getTableName() {
        return this.getSpecifiedTableName() == null ? this.getDefaultTableName() : this.getSpecifiedTableName();
    }

    public Table getTable() {
        Schema schema = this.getPersistenceProject().getSchema();
        boolean ignoreCase = true;
        if (ignoreCase) {
            return schema == null ? null : schema.tableNamedIgnoreCase(this.getTableName());
        }
        return schema == null ? null : schema.tableNamed(this.getTableName());
    }

    public Table getReferencedTable() {
        Entity entity = ((RelationshipMappingImpl)this.eContainer()).getResolvedTargetEntity();
        if (entity != null) {
            Schema schema = this.getPersistenceProject().getSchema();
            String tableName = entity.getTable().getName();
            boolean ignoreCase = true;
            if (ignoreCase) {
                return schema == null ? null : schema.tableNamedIgnoreCase(tableName);
            }
            return schema == null ? null : schema.tableNamed(tableName);
        }
        return null;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setSpecifiedNameGen(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    public void setSpecifiedName(String newSpecifiedName) {
        this.setSpecifiedNameGen(newSpecifiedName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedNameChanged();
    }

    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    public void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldDefaultReferencedColumnName, (Object)this.defaultReferencedColumnName));
        }
    }

    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    public void setSpecifiedReferencedColumnNameGen(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSpecifiedReferencedColumnName, (Object)this.specifiedReferencedColumnName));
        }
    }

    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        this.setSpecifiedReferencedColumnNameGen(newSpecifiedReferencedColumnName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedReferencedColumnNameChanged();
    }

    public String getReferencedColumnName() {
        return this.getSpecifiedReferencedColumnName() == null ? this.getDefaultReferencedColumnName() : this.getSpecifiedReferencedColumnName();
    }

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getDefaultTableName();
            }
            case 1: {
                return this.getSpecifiedTableName();
            }
            case 2: {
                return this.getTableName();
            }
            case 3: {
                return this.getDefaultName();
            }
            case 4: {
                return this.getSpecifiedName();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getDefaultReferencedColumnName();
            }
            case 7: {
                return this.getSpecifiedReferencedColumnName();
            }
            case 8: {
                return this.getReferencedColumnName();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setDefaultTableName((String)newValue);
                return;
            }
            case 1: {
                this.setSpecifiedTableName((String)newValue);
                return;
            }
            case 3: {
                this.setDefaultName((String)newValue);
                return;
            }
            case 4: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 6: {
                this.setDefaultReferencedColumnName((String)newValue);
                return;
            }
            case 7: {
                this.setSpecifiedReferencedColumnName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setDefaultTableName(DEFAULT_TABLE_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setSpecifiedTableName(SPECIFIED_TABLE_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setDefaultName(DEFAULT_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setDefaultReferencedColumnName(DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setSpecifiedReferencedColumnName(SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return DEFAULT_TABLE_NAME_EDEFAULT == null ? this.defaultTableName != null : !DEFAULT_TABLE_NAME_EDEFAULT.equals(this.defaultTableName);
            }
            case 1: {
                return SPECIFIED_TABLE_NAME_EDEFAULT == null ? this.specifiedTableName != null : !SPECIFIED_TABLE_NAME_EDEFAULT.equals(this.specifiedTableName);
            }
            case 2: {
                return TABLE_NAME_EDEFAULT == null ? this.getTableName() != null : !TABLE_NAME_EDEFAULT.equals(this.getTableName());
            }
            case 3: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 4: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 6: {
                return DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.defaultReferencedColumnName != null : !DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.defaultReferencedColumnName);
            }
            case 7: {
                return SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.specifiedReferencedColumnName != null : !SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.specifiedReferencedColumnName);
            }
            case 8: {
                return REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.getReferencedColumnName() != null : !REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.getReferencedColumnName());
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultTableName: ");
        result.append(this.defaultTableName);
        result.append(", specifiedTableName: ");
        result.append(this.specifiedTableName);
        result.append(", defaultName: ");
        result.append(this.defaultName);
        result.append(", specifiedName: ");
        result.append(this.specifiedName);
        result.append(", defaultReferencedColumnName: ");
        result.append(this.defaultReferencedColumnName);
        result.append(", specifiedReferencedColumnName: ");
        result.append(this.specifiedReferencedColumnName);
        result.append(')');
        return result.toString();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        if (((IJoinColumnModelAdapter)this.getModelAdapter()).getOwner().relationshipMapping().getTypeMapping().getKey() == Entity.Key.INSTANCE) {
            this.addUnresolvedJoinColumnProblemTo(problems);
            this.addUnresolvedReferencedColumnProblemTo(problems);
        }
    }

    private void addUnresolvedJoinColumnProblemTo(List problems) {
        if (this.getPersistenceProject().getConnectionInfo().isConnected()) {
            Table table = this.getTable();
            boolean ignoreCase = true;
            if (ignoreCase) {
                if (table == null || table.columnNamedIgnoreCase(this.getName()) == null) {
                    problems.add(this.buildProblem("Join column \"" + this.getName() + "\" cannot be resolved", this.joinColumnTextRange()));
                }
            } else if (table == null || table.columnNamed(this.getName()) == null) {
                problems.add(this.buildProblem("Join column \"" + this.getName() + "\" cannot be resolved", this.joinColumnTextRange()));
            }
        }
    }

    private ITextRange joinColumnTextRange() {
        ITextRange textRange = ((IJoinColumnModelAdapter)this.getModelAdapter()).joinColumnTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    private void addUnresolvedReferencedColumnProblemTo(List problems) {
        if (this.getPersistenceProject().getConnectionInfo().isConnected()) {
            Table table = this.getReferencedTable();
            boolean ignoreCase = true;
            if (ignoreCase) {
                if (table == null || table.columnNamedIgnoreCase(this.getReferencedColumnName()) == null) {
                    problems.add(this.buildProblem("Referenced column \"" + this.getReferencedColumnName() + "\" cannot be resolved", this.referencedColumnTextRange()));
                }
            } else if (table == null || table.columnNamed(this.getReferencedColumnName()) == null) {
                problems.add(this.buildProblem("Referenced column \"" + this.getReferencedColumnName() + "\" cannot be resolved", this.referencedColumnTextRange()));
            }
        }
    }

    private ITextRange referencedColumnTextRange() {
        ITextRange textRange = ((IJoinColumnModelAdapter)this.getModelAdapter()).referencedColumnTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }
}

