/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.VersionMapping;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.VersionMappingItemProvider;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VersionMappingComposite
extends Composite
implements IPersistenceComposite {
    private static final String COLUMN_HELP_CONTEXT_ID = ".mapping_column";
    private ColumnComposite columnComposite;
    private VersionMapping version;
    EditingDomain editingDomain;
    private DaliItemProviderAdapterFactory adapterFactory;
    private VersionMappingItemProvider versionTypeItemProvider;
    private INotifyChangedListener mappingListener;

    protected VersionMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.versionTypeItemProvider = (VersionMappingItemProvider)this.adapterFactory.createVersionMappingAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, COLUMN_HELP_CONTEXT_ID);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
    }

    public void populate(EObject model) {
        if (this.version != null) {
            this.versionTypeItemProvider.removeListener(this.getMappingListener());
            this.version.eAdapters().remove((Object)this.versionTypeItemProvider);
        }
        if (model == null) {
            this.version = null;
            this.columnComposite.populate(null);
            return;
        }
        this.version = (VersionMapping)((PersistentAttribute)model).getAttributeMapping();
        this.versionTypeItemProvider.addListener(this.getMappingListener());
        this.version.eAdapters().add((Object)this.versionTypeItemProvider);
        this.columnComposite.populate((EObject)this.version.getColumn());
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                }
            };
        }
        return this.mappingListener;
    }

    public void dispose() {
        this.versionTypeItemProvider.removeListener(this.mappingListener);
        super.dispose();
    }

    VersionMapping getVerionsMapping() {
        return this.version;
    }

    public static class VersionMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new VersionMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

