/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.core.AccessType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.EntityItemProvider;
import org.eclipse.dali.edit.PersistentTypeItemProvider;
import org.eclipse.dali.ui.views.AttributeOverridesComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.InheritanceComposite;
import org.eclipse.dali.ui.views.TableComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class EntityComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private DaliItemProviderAdapterFactory adapterFactory;
    private EditingDomain editingDomain;
    private Entity entity;
    private PersistentType persistentType;
    private ComboViewer accessTypeComboViewer;
    private Combo entityNameCombo;
    private InheritanceComposite inheritanceComposite;
    private TableComposite tableComposite;
    private AttributeOverridesComposite attributeOverridesComposite;
    private EntityItemProvider entityItemProvider;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener entityListener;
    private INotifyChangedListener persistentTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EntityComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.adapterFactory = adapterFactory;
        this.editingDomain = editingDomain;
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.core.Entity");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 1: {
                            String name = notification.getNewStringValue();
                            Display.getDefault().syncExec(new Runnable(this, name){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ String val$name;
                                {
                                    this.this$1 = var1_1;
                                    this.val$name = string;
                                }

                                public void run() {
                                    if (this.val$name == null) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).select(0);
                                    } else if (!EntityComposite.access$0(1.access$0(this.this$1)).getText().equals(this.val$name)) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).setText(this.val$name);
                                    }
                                }
                            });
                            break;
                        }
                        case 0: {
                            String defaultName = notification.getNewStringValue();
                            Display.getDefault().syncExec(new Runnable(this, defaultName){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ String val$defaultName;
                                {
                                    this.this$1 = var1_1;
                                    this.val$defaultName = string;
                                }

                                public void run() {
                                    boolean defaultSelected = false;
                                    if (EntityComposite.access$0(1.access$0(this.this$1)).getSelectionIndex() == 0) {
                                        defaultSelected = true;
                                    }
                                    EntityComposite.access$0(1.access$0(this.this$1)).setItem(0, "Default (" + this.val$defaultName + ")");
                                    if (defaultSelected) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).select(0);
                                    }
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ EntityComposite access$0(1 var0) {
                    return var0.EntityComposite.this;
                }
            };
        }
        return this.entityListener;
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.core.PersistentType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 2) {
                        AccessType accessType = (AccessType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, accessType){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ AccessType val$accessType;
                            {
                                this.this$1 = var1_1;
                                this.val$accessType = accessType;
                            }

                            public void run() {
                                if (((StructuredSelection)EntityComposite.access$1(4.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$accessType) {
                                    EntityComposite.access$1(4.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$accessType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ EntityComposite access$0(4 var0) {
                    return var0.EntityComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
            }

            public void disconnected(Connection connection) {
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    EntityComposite.this.populate((EObject)EntityComposite.this.entity);
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                connectionInfo.equals(connection);
            }

            public void onSQLException(Connection connection, SQLException exception) {
                connectionInfo.equals(connection);
            }
        };
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText("General");
        generalTab.setControl(generalControl);
        Control inheritanceControl = this.buildInheritanceTab(folder);
        TabItem inheritanceTab = new TabItem(folder, 0);
        inheritanceTab.setText("Inheritance");
        inheritanceTab.setControl(inheritanceControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        Label accessTypeLabel = new Label(composite, 16384);
        accessTypeLabel.setText("Access Type:");
        this.accessTypeComboViewer = this.buildAccessTypeCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.accessTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        this.accessTypeComboViewer.getCombo().setEnabled(false);
        helpSystem.setHelp((Control)this.accessTypeComboViewer.getCombo(), "org.eclipse.dali.ui.entity_accessType");
        Label entityNameLabel = new Label(composite, 16384);
        entityNameLabel.setText("Name:");
        this.entityNameCombo = this.buildEntityNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.entityNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.entityNameCombo, "org.eclipse.dali.ui.entity_name");
        this.tableComposite = new TableComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        this.attributeOverridesComposite = new AttributeOverridesComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.attributeOverridesComposite.setLayoutData(gridData);
        return composite;
    }

    private Control buildInheritanceTab(TabFolder folder) {
        this.inheritanceComposite = new InheritanceComposite((Composite)folder, this.editingDomain, this.adapterFactory);
        return this.inheritanceComposite;
    }

    private ComboViewer buildAccessTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(AccessType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (EntityComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    EntityComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EntityComposite.this.editingDomain, (Object)EntityComposite.this.persistentType, (Object)DaliPackage.eINSTANCE.getPersistentType_AccessType(), (Object)selection.getFirstElement()));
                }
            }
        });
        return viewer;
    }

    private Combo buildEntityNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.add("Default ()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EntityComposite.this.populating) {
                    return;
                }
                EntityComposite.this.entityNameCombo.getSelectionIndex();
                String text = ((Combo)e.getSource()).getText();
                if (text.equals(EntityComposite.this.entityNameCombo.getItem(0))) {
                    text = null;
                }
                EntityComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EntityComposite.this.editingDomain, (Object)EntityComposite.this.entity, (Object)DaliPackage.eINSTANCE.getEntity_SpecifiedName(), (Object)text));
            }
        });
        return combo;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.entity != null) {
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.entity.eAdapters().remove((Object)this.entityItemProvider);
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.entity = (Entity)model;
        if (this.entity == null) {
            this.attributeOverridesComposite.populate(null);
            this.inheritanceComposite.populate(null);
            return;
        }
        this.persistentType = this.entity.getPersistentType();
        this.entityItemProvider.addListener(this.getEntityListener());
        this.entity.eAdapters().add((Object)this.entityItemProvider);
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.populateGeneralPanel();
        this.populateTablePanel();
        this.attributeOverridesComposite.populate((EObject)this.entity);
        this.inheritanceComposite.populate((EObject)this.entity.getInheritance());
        this.populating = false;
    }

    private void populateGeneralPanel() {
        this.accessTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.persistentType.getAccessType()));
        this.entityNameCombo.getSelectionIndex();
        this.entityNameCombo.setItem(0, "Default (" + this.entity.getDefaultName() + ")");
        String entityName = this.entity.getSpecifiedName();
        if (entityName != null) {
            if (!this.entityNameCombo.getText().equals(entityName)) {
                this.entityNameCombo.setText(entityName);
            }
        } else {
            this.entityNameCombo.select(0);
        }
    }

    private void populateTablePanel() {
        Connection connectionInfo = this.entity.getPersistenceProject().getConnectionInfo();
        connectionInfo.addConnectionListener(this.buildConnectionListener(connectionInfo));
        this.tableComposite.populate((EObject)this.entity.getTable());
    }

    public boolean setFocus() {
        super.setFocus();
        return this.entityNameCombo.setFocus();
    }

    public void dispose() {
        this.entityItemProvider.removeListener(this.entityListener);
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$1(EntityComposite entityComposite) {
        return entityComposite.accessTypeComboViewer;
    }
}

