/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.text.Collator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Sequence;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.util.EList;

public final class Schema
implements Comparable {
    private final Database database;
    private final org.eclipse.wst.rdb.internal.models.sql.schema.Schema rdbSchema;
    private Set tables;
    private Set sequences;

    Schema(Database database, org.eclipse.wst.rdb.internal.models.sql.schema.Schema rdbSchema) {
        this.database = database;
        this.rdbSchema = rdbSchema;
    }

    public String getName() {
        return this.rdbSchema.getName();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    Column column(org.eclipse.wst.rdb.internal.models.sql.tables.Column rdbColumn) {
        return this.database.column(rdbColumn);
    }

    boolean wraps(org.eclipse.wst.rdb.internal.models.sql.schema.Schema schema) {
        return this.rdbSchema == schema;
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((Schema)o).getName());
    }

    private synchronized Collection getTables() {
        if (this.tables == null) {
            this.tables = this.buildTables();
        }
        return this.tables;
    }

    private Set buildTables() {
        EList rdbTables = this.rdbSchema.getTables();
        HashSet<Table> result = new HashSet<Table>(rdbTables.size());
        Iterator stream = rdbTables.iterator();
        while (stream.hasNext()) {
            result.add(new Table(this, (org.eclipse.wst.rdb.internal.models.sql.tables.Table)stream.next()));
        }
        return result;
    }

    public Iterator tables() {
        return this.getTables().iterator();
    }

    public int tablesSize() {
        return this.getTables().size();
    }

    public boolean tablesContains(Column column) {
        return this.getTables().contains(column);
    }

    public Iterator tableNames() {
        return new TransformationIterator(this.tables()){

            protected Object transform(Object next) {
                return ((Table)next).getName();
            }
        };
    }

    public Table tableNamed(String name) {
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            Table table = (Table)stream.next();
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public Table tableNamedIgnoreCase(String name) {
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            Table table = (Table)stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)table.getName(), (String)name)) continue;
            return table;
        }
        return null;
    }

    Table table(org.eclipse.wst.rdb.internal.models.sql.tables.Table rdbTable) {
        if (rdbTable.getSchema() != this.rdbSchema) {
            return this.database.table(rdbTable);
        }
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            Table table = (Table)stream.next();
            if (!table.wraps(rdbTable)) continue;
            return table;
        }
        throw new IllegalArgumentException("invalid rdb table: " + rdbTable);
    }

    private synchronized Collection getSequences() {
        if (this.sequences == null) {
            this.sequences = this.buildSequences();
        }
        return this.sequences;
    }

    private Set buildSequences() {
        EList rdbSequences = this.rdbSchema.getSequences();
        HashSet<Sequence> result = new HashSet<Sequence>(rdbSequences.size());
        Iterator stream = rdbSequences.iterator();
        while (stream.hasNext()) {
            result.add(new Sequence((org.eclipse.wst.rdb.internal.models.sql.schema.Sequence)stream.next()));
        }
        return result;
    }

    public Iterator sequences() {
        return this.getSequences().iterator();
    }

    public int sequencesSize() {
        return this.getSequences().size();
    }

    public boolean sequencesContains(Column column) {
        return this.getSequences().contains(column);
    }

    public Iterator sequenceNames() {
        return new TransformationIterator(this.sequences()){

            protected Object transform(Object next) {
                return ((Sequence)next).getName();
            }
        };
    }

    public Sequence sequenceNamed(String name) {
        Iterator stream = this.sequences();
        while (stream.hasNext()) {
            Sequence sequence = (Sequence)stream.next();
            if (!sequence.getName().equals(name)) continue;
            return sequence;
        }
        return null;
    }
}

