/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.JavaPropertyNameGenerator;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.emf.common.util.EList;

public class ForeignKey
implements JavaPropertyNameGenerator,
Comparable {
    private final Table baseTable;
    private final org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey rdbForeignKey;
    private Table referencedTable;
    private Set columnPairs;
    private String defaultEntityPropertyName;
    private boolean defaultEntityPropertyNameCalculated = false;

    ForeignKey(Table baseTable, org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey rdbForeignKey) {
        this.baseTable = baseTable;
        this.rdbForeignKey = rdbForeignKey;
    }

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((ForeignKey)o).getName());
    }

    public String getName() {
        return this.rdbForeignKey.getName();
    }

    boolean wraps(org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey foreignKey) {
        return this.rdbForeignKey == foreignKey;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + this.getColumnPairs()));
    }

    public Table getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.baseTable.table((org.eclipse.wst.rdb.internal.models.sql.tables.Table)this.rdbForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    public Iterator baseColumns() {
        return new TransformationIterator(this.columnPairs()){

            protected Object transform(Object next) {
                return ((ColumnPair)next).getBaseColumn();
            }
        };
    }

    public Iterator referencedColumns() {
        return new TransformationIterator(this.columnPairs()){

            protected Object transform(Object next) {
                return ((ColumnPair)next).getReferencedColumn();
            }
        };
    }

    public String shortJavaClassName(boolean caseSensitive) {
        return this.getReferencedTable().shortJavaClassName(caseSensitive);
    }

    public String javaPropertyName(boolean caseSensitive) {
        String fieldName = this.getDefaultEntityPropertyName();
        if (fieldName == null) {
            fieldName = this.nonDefaultEntityPropertyName();
        }
        return caseSensitive ? fieldName : fieldName.toLowerCase();
    }

    private synchronized Set getColumnPairs() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairs();
        }
        return this.columnPairs;
    }

    private Set buildColumnPairs() {
        EList baseColumns = this.rdbForeignKey.getMembers();
        int size = baseColumns.size();
        EList refColumns = this.rdbForeignKey.getUniqueConstraint().getMembers();
        if (refColumns.size() != size) {
            throw new IllegalStateException("mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        HashSet<ColumnPair> result = new HashSet<ColumnPair>(baseColumns.size());
        int i = baseColumns.size();
        while (i-- > 0) {
            Column baseColumn = this.baseTable.column((org.eclipse.wst.rdb.internal.models.sql.tables.Column)baseColumns.get(i));
            Column refColumn = this.baseTable.column((org.eclipse.wst.rdb.internal.models.sql.tables.Column)refColumns.get(i));
            result.add(new ColumnPair(baseColumn, refColumn));
        }
        return result;
    }

    public Iterator columnPairs() {
        return this.getColumnPairs().iterator();
    }

    public int columnPairsSize() {
        return this.getColumnPairs().size();
    }

    private String getDefaultEntityPropertyName() {
        if (!this.defaultEntityPropertyNameCalculated) {
            this.defaultEntityPropertyNameCalculated = true;
            this.defaultEntityPropertyName = this.buildDefaultEntityPropertyName();
        }
        return this.defaultEntityPropertyName;
    }

    private String buildDefaultEntityPropertyName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        ColumnPair columnPair = (ColumnPair)this.columnPairs().next();
        String baseName = columnPair.getBaseColumn().getName();
        String refName = columnPair.getReferencedColumn().getName();
        if (baseName.length() <= refName.length() + 1) {
            return null;
        }
        if (!baseName.endsWith("_" + refName)) {
            return null;
        }
        return baseName.substring(0, baseName.length() - (refName.length() + 1));
    }

    public boolean referencesSingleColumnPrimaryKey() {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        ColumnPair columnPair = (ColumnPair)this.columnPairs().next();
        Column refColumn = columnPair.getReferencedColumn();
        return this.getReferencedTable().primaryKeyColumnsContains(refColumn);
    }

    private String nonDefaultEntityPropertyName() {
        if (this.columnPairsSize() == 1) {
            return ((ColumnPair)this.columnPairs().next()).getBaseColumn().getName();
        }
        return this.getReferencedTable().getName();
    }

    public boolean baseColumnNameIsEntityDefault() {
        return this.getDefaultEntityPropertyName() != null;
    }

    public class ColumnPair
    implements Comparable {
        private final Column baseColumn;
        private final Column referencedColumn;

        ColumnPair(Column baseColumn, Column referencedColumn) {
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public Column getBaseColumn() {
            return this.baseColumn;
        }

        public Column getReferencedColumn() {
            return this.referencedColumn;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }

        public int compareTo(Object o) {
            return Collator.getInstance().compare(this.getBaseColumn().getName(), ((ColumnPair)o).getBaseColumn().getName());
        }
    }
}

