/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler;

import com.oracle.wls.shaded.org.apache.bcel.generic.ConstantPoolGen;
import com.oracle.wls.shaded.org.apache.bcel.generic.INVOKESPECIAL;
import com.oracle.wls.shaded.org.apache.bcel.generic.INVOKEVIRTUAL;
import com.oracle.wls.shaded.org.apache.bcel.generic.InstructionConstants;
import com.oracle.wls.shaded.org.apache.bcel.generic.InstructionList;
import com.oracle.wls.shaded.org.apache.bcel.generic.NEW;
import com.oracle.wls.shaded.org.apache.bcel.generic.PUSH;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.CastExpr;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.Expression;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.FunctionCall;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.QName;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.SymbolTable;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.util.Type;
import com.oracle.wls.shaded.org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import java.util.Vector;

final class ConcatCall
extends FunctionCall {
    public ConcatCall(QName fname, Vector arguments) {
        super(fname, arguments);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        int i = 0;
        while (i < this.argumentCount()) {
            Expression exp = this.argument(i);
            if (!exp.typeCheck(stable).identicalTo(Type.String)) {
                this.setArgument(i, new CastExpr(exp, Type.String));
            }
            ++i;
        }
        this._type = Type.String;
        return this._type;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int nArgs = this.argumentCount();
        switch (nArgs) {
            case 0: {
                il.append(new PUSH(cpg, ""));
                break;
            }
            case 1: {
                this.argument().translate(classGen, methodGen);
                break;
            }
            default: {
                int initBuffer = cpg.addMethodref("java.lang.StringBuffer", "<init>", "()V");
                INVOKEVIRTUAL append = new INVOKEVIRTUAL(cpg.addMethodref("java.lang.StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;"));
                int toString = cpg.addMethodref("java.lang.StringBuffer", "toString", "()Ljava/lang/String;");
                il.append(new NEW(cpg.addClass("java.lang.StringBuffer")));
                il.append(InstructionConstants.DUP);
                il.append(new INVOKESPECIAL(initBuffer));
                int i = 0;
                while (i < nArgs) {
                    this.argument(i).translate(classGen, methodGen);
                    il.append(append);
                    ++i;
                }
                il.append(new INVOKEVIRTUAL(toString));
            }
        }
    }
}

