/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.shim.scope.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.shim.scope.Scope;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public final class StandardScopeFactory
implements ScopeFactory {
    private static final String PROPERTY_BLUEPRINT_CONTEXT_SERVICE_NAME = "org.eclipse.gemini.blueprint.context.service.name";
    private static final String PROPERTY_BEAN_NAME = "org.eclipse.gemini.blueprint.bean.name";
    private final EventLogger eventLogger;
    private final Map<AppScope, ConcurrentHashMap<String, Object>> properties;

    public StandardScopeFactory(EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.properties = new HashMap<AppScope, ConcurrentHashMap<String, Object>>();
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Scope getBundleScope(Bundle bundle) {
        try {
            return StandardScopeFactory.isBundleScoped(bundle) ? this.createApplicationScope(bundle) : GlobalScope.INSTANCE;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Scope createApplicationScope(Bundle bundle) {
        try {
            return this.getApplicationScope(StandardScopeFactory.getScopeName(bundle));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Scope getGlobalScope() {
        try {
            return GlobalScope.INSTANCE;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Scope getServiceScope(ServiceReference ref) {
        try {
            return "app".equals(this.getScopeIdentifier(ref)) ? this.getBundleScope(ref.getBundle()) : this.getGlobalScope();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scope getApplicationScope(String applicationScopeName) {
        try {
            Map<AppScope, ConcurrentHashMap<String, Object>> map = this.properties;
            synchronized (map) {
                AppScope appScope = new AppScope(applicationScopeName);
                ConcurrentHashMap<String, Object> props = this.properties.get(appScope);
                if (props == null) {
                    props = new ConcurrentHashMap();
                    this.properties.put(appScope, props);
                }
                appScope.setProperties(props);
                return appScope;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getScopeIdentifier(ServiceReference ref) {
        try {
            String serviceScope = (String)ref.getProperty("org.eclipse.virgo.service.scope");
            if (serviceScope == null) {
                serviceScope = (String)ref.getProperty("com.springsource.service.scope");
                if (serviceScope == null) {
                    serviceScope = ref.getProperty(PROPERTY_BLUEPRINT_CONTEXT_SERVICE_NAME) != null ? "global" : (StandardScopeFactory.isBundleScoped(ref.getBundle()) ? "app" : "global");
                } else {
                    this.eventLogger.log((LogEvent)KernelLogEvents.OLD_SCOPING_PROPERTY_USED, new Object[]{ref.getBundle().getSymbolicName(), ref.getBundle().getVersion(), ref.getProperty(PROPERTY_BEAN_NAME)});
                }
            }
            return serviceScope;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isBundleScoped(Bundle bundle) {
        try {
            return StandardScopeFactory.getScopeName(bundle) != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String getScopeName(Bundle bundle) {
        try {
            return (String)bundle.getHeaders().get("Module-Scope");
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyApplicationScope(Scope applicationScope) {
        try {
            AppScope appScope = (AppScope)applicationScope;
            Map<AppScope, ConcurrentHashMap<String, Object>> map = this.properties;
            synchronized (map) {
                this.properties.remove(appScope);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static class AppScope
    extends StandardScope {
        private final String scopeName;

        public AppScope(String scopeName) {
            try {
                this.scopeName = scopeName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public int hashCode() {
            try {
                int result = super.hashCode();
                result = 31 * result + (this.scopeName == null ? 0 : this.scopeName.hashCode());
                return result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public boolean equals(Object obj) {
            try {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AppScope other = (AppScope)obj;
                return !(this.scopeName == null ? other.scopeName != null : !this.scopeName.equals(other.scopeName));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String toString() {
            try {
                return "app:" + this.scopeName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public boolean isGlobal() {
            try {
                return false;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public String getScopeName() {
            try {
                return this.scopeName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }

    private static class GlobalScope
    extends StandardScope {
        static GlobalScope INSTANCE = new GlobalScope();

        private GlobalScope() {
            try {
                this.setProperties(new ConcurrentHashMap<String, Object>());
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public int hashCode() {
            try {
                return 316;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public boolean equals(Object other) {
            try {
                return other == this || other instanceof GlobalScope;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String toString() {
            try {
                return "global";
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public boolean isGlobal() {
            try {
                return true;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public String getScopeName() {
            try {
                return null;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }

    private static abstract class StandardScope
    implements Scope {
        private volatile ConcurrentHashMap<String, Object> properties;

        protected StandardScope() {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        final void setProperties(ConcurrentHashMap<String, Object> properties) {
            try {
                this.properties = properties;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public final Object getProperty(String propertyName) {
            try {
                return this.properties.get(propertyName);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public final void setProperty(String propertyName, Object propertyValue) {
            try {
                this.properties.put(propertyName, propertyValue);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public int hashCode() {
            try {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public boolean equals(Object obj) {
            try {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StandardScope other = (StandardScope)obj;
                if (this.properties == null || other.properties == null) {
                    return true;
                }
                return this.properties == other.properties;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

