/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.naming.java.javaURLContextFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.gemini.web.tomcat.internal.BundleDependenciesJarScanner;
import org.eclipse.gemini.web.tomcat.internal.ChainingJarScanner;
import org.eclipse.gemini.web.tomcat.internal.DelegatingJarScannerCustomizer;
import org.eclipse.gemini.web.tomcat.internal.ExtendedStandardContext;
import org.eclipse.gemini.web.tomcat.internal.TomcatConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.WebappConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.loader.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.eclipse.gemini.web.tomcat.internal.support.PackageAdminBundleDependencyDeterminer;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class OsgiAwareEmbeddedTomcat
extends Tomcat {
    private static final String USER_DIR = "user.dir";
    private static final String ROOT_CONTEXT_PATH = "";
    private static final String ROOT_PATH = "/";
    static final String USE_NAMING = "useNaming";
    static final String TOMCAT_NAMING_ENABLED = "tomcat";
    static final String OSGI_NAMING_ENABLED = "osgi";
    static final String NAMING_DISABLED = "disabled";
    static final String CATALINA_USE_NAMING = "catalina.useNaming";
    private static final String JNDI_URLSCHEME = "osgi.jndi.url.scheme";
    private static final String JAVA_JNDI_URLSCHEME = "java";
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiAwareEmbeddedTomcat.class);
    private final ExtendCatalina catalina = new ExtendCatalina();
    private final BundleContext bundleContext;
    private Path configDir;
    private String defaultContextXml;
    private String defaultWeb;
    private String oldCatalinaBaseDir;
    private String oldCatalinaHomeDir;
    private volatile HashMap<String, Authenticator> authenticators;
    private final Object monitor = new Object();
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private final DelegatingJarScannerCustomizer jarScannerCustomizer;
    private final JarScanner bundleDependenciesJarScanner;
    private final JarScanner defaultJarScanner;
    private String hostConfigDir;

    OsgiAwareEmbeddedTomcat(BundleContext context, ServiceTracker<?, ?> urlConverterTracker) {
        this.bundleContext = context;
        this.bundleDependenciesJarScanner = new BundleDependenciesJarScanner(new PackageAdminBundleDependencyDeterminer(), BundleFileResolverFactory.createBundleFileResolver(), context, urlConverterTracker);
        this.defaultJarScanner = new StandardJarScanner();
        this.jarScannerCustomizer = new DelegatingJarScannerCustomizer(context);
    }

    public void start() throws LifecycleException {
        this.jarScannerCustomizer.open();
        this.getServer();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.jarScannerCustomizer.close();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Service getService() {
        Server server = this.getServer();
        Service[] findServices = server.findServices();
        if (findServices != null && findServices.length > 0) {
            return findServices[0];
        }
        throw new IllegalStateException("Unable to locate Service.");
    }

    public Host getHost() {
        return this.findHost();
    }

    public Engine getEngine() {
        return this.findEngine();
    }

    private Engine findEngine() {
        Service[] findServices;
        Server server = this.getServer();
        Service[] serviceArray = findServices = server.findServices();
        int n = findServices.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            Engine container = service.getContainer();
            if (container != null) {
                return container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Engine.");
    }

    private Host findHost() {
        Container[] children;
        Engine engine = this.findEngine();
        Container[] containerArray = children = engine.findChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Container container = containerArray[n2];
            if (container instanceof Host) {
                return (Host)container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Host.");
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.initNaming();
        this.server.init();
    }

    private void initNaming() {
        String useNaming = this.bundleContext.getProperty(USE_NAMING);
        if (useNaming == null) {
            useNaming = System.getProperty(USE_NAMING);
        }
        if (useNaming == null) {
            useNaming = TOMCAT_NAMING_ENABLED;
        }
        if (NAMING_DISABLED.equals(useNaming)) {
            System.setProperty(CATALINA_USE_NAMING, Boolean.FALSE.toString());
        } else {
            this.enableNaming(useNaming);
        }
    }

    private void enableNaming(String useNaming) {
        super.enableNaming();
        if (OSGI_NAMING_ENABLED.equals(useNaming)) {
            this.registerInitialContextFactory();
            this.registerJavaURLContextFactory();
            this.registerObjectFactoryBuilder();
        }
    }

    public void destroy() throws LifecycleException {
        super.destroy();
        this.tracker.unregisterAll();
        if (this.oldCatalinaBaseDir != null) {
            System.setProperty("catalina.base", this.oldCatalinaBaseDir);
        }
        if (this.oldCatalinaHomeDir != null) {
            System.setProperty("catalina.home", this.oldCatalinaHomeDir);
        }
    }

    public Context addWebapp(String path, String docBase) {
        return this.addWebapp(path, docBase, null);
    }

    Context addWebapp(String path, String docBase, Bundle bundle) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating context [" + path + "] with docBase [" + docBase + "].");
        }
        ExtendedStandardContext context = new ExtendedStandardContext(bundle);
        ExtendedContextConfig config = new ExtendedContextConfig();
        if (this.configDir == null) {
            this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        }
        if (this.defaultWeb == null) {
            this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
        }
        config.setDefaultWebXml(this.defaultWeb);
        if (this.defaultContextXml == null) {
            this.defaultContextXml = WebappConfigLocator.resolveDefaultContextXml(this.configDir);
        }
        context.setDefaultContextXml(this.defaultContextXml);
        Host host = this.getHost();
        if (this.hostConfigDir == null) {
            this.hostConfigDir = TomcatConfigLocator.resolveHostConfigDir(this.configDir, host);
        }
        if (this.hostConfigDir != null) {
            host.setXmlBase(this.hostConfigDir);
            host.getConfigBaseFile();
        }
        Path configLocation = WebappConfigLocator.resolveWebappConfigDir(this.configDir, host);
        try {
            context.setConfigFile(WebappConfigLocator.resolveWebappContextXml(path, docBase, configLocation, bundle));
        }
        catch (MalformedURLException e) {
            throw new ServletContainerException("Cannot resolve web application's context.xml [" + docBase + "].", (Throwable)e);
        }
        context.setDocBase(docBase);
        context.setPath(path.equals(ROOT_PATH) ? ROOT_CONTEXT_PATH : path);
        context.setName(context.getPath());
        context.setJarScanner(this.getJarScanner(bundle));
        context.setParent((Container)host);
        config.setCustomAuthenticators(this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }

    void configure(InputStream configuration) {
        Digester digester = this.catalina.createStartDigester();
        digester.push((Object)this);
        ClassLoader[] loaders = new ClassLoader[]{Catalina.class.getClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()};
        ChainedClassLoader chainedClassLoader = ChainedClassLoader.create(loaders);
        chainedClassLoader.setBundle(this.bundleContext.getBundle());
        digester.setClassLoader((ClassLoader)chainedClassLoader);
        try {
            digester.parse(configuration);
        }
        catch (IOException e) {
            throw new ServletContainerException("Error reading Tomcat configuration file.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletContainerException("Error parsing Tomcat XML configuration.", (Throwable)e);
        }
        this.initBaseDir();
        this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        this.defaultContextXml = WebappConfigLocator.resolveDefaultContextXml(this.configDir);
        this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
        Host host = this.getHost();
        this.hostConfigDir = TomcatConfigLocator.resolveHostConfigDir(this.configDir, host);
        if (this.hostConfigDir != null) {
            host.setXmlBase(this.hostConfigDir);
            host.getConfigBaseFile();
        }
    }

    protected void initBaseDir() {
        String catalinaHome = System.getProperty("catalina.home");
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.base");
        }
        if (this.basedir == null) {
            this.basedir = catalinaHome;
        }
        if (this.basedir == null) {
            this.basedir = String.valueOf(System.getProperty(USER_DIR)) + "/tomcat." + this.port;
        }
        Path baseFile = Paths.get(this.basedir, new String[0]);
        try {
            Files.createDirectories(baseFile, new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new IllegalStateException("Cannot create directories for [" + baseFile + "].", e1);
        }
        try {
            this.basedir = baseFile.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException iOException) {
            this.basedir = baseFile.toAbsolutePath().toString();
        }
        this.server.setCatalinaBase(new File(this.basedir));
        this.oldCatalinaBaseDir = System.setProperty("catalina.base", this.basedir);
        if (catalinaHome == null) {
            this.server.setCatalinaHome(new File(this.basedir));
        } else {
            Path homeFile = Paths.get(catalinaHome, new String[0]);
            try {
                Files.createDirectories(homeFile, new FileAttribute[0]);
            }
            catch (IOException e1) {
                throw new IllegalStateException("Cannot create directories for [" + homeFile + "].", e1);
            }
            try {
                this.server.setCatalinaHome(homeFile.toRealPath(new LinkOption[0]).toFile());
            }
            catch (IOException iOException) {
                this.server.setCatalinaHome(homeFile.toAbsolutePath().toFile());
            }
        }
        this.oldCatalinaHomeDir = System.setProperty("catalina.home", this.basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAuthenticator(Authenticator authenticator, String loginMethod) {
        if (!(authenticator instanceof Valve)) {
            throw new IllegalArgumentException("Specified Authenticator is not a Valve");
        }
        if (this.authenticators == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.authenticators == null) {
                    this.authenticators = new HashMap();
                }
            }
        }
        this.authenticators.put(loginMethod, authenticator);
    }

    private void registerObjectFactoryBuilder() {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ObjectFactoryBuilder.class, (Object)new ObjectFactoryBuilder(){

            @Override
            public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
                block3: {
                    Reference reference;
                    String factory;
                    if (obj instanceof Reference && (factory = (reference = (Reference)obj).getFactoryClassName()) != null) {
                        try {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(factory);
                            return (ObjectFactory)clazz.newInstance();
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            if (!LOGGER.isInfoEnabled()) break block3;
                            LOGGER.info("Error while trying to create object factory [" + factory + "]", (Throwable)e);
                        }
                    }
                }
                return null;
            }
        }, null);
        this.tracker.track(serviceRegistration);
    }

    private void registerJavaURLContextFactory() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put(JNDI_URLSCHEME, JAVA_JNDI_URLSCHEME);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ObjectFactory.class, (Object)new javaURLContextFactory(), serviceProperties);
        this.tracker.track(serviceRegistration);
    }

    private void registerInitialContextFactory() {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(new String[]{InitialContextFactory.class.getName(), javaURLContextFactory.class.getName()}, (Object)new javaURLContextFactory(), null);
        this.tracker.track(serviceRegistration);
    }

    private JarScanner getJarScanner(Bundle bundle) {
        JarScanner[] jarScanners = new JarScanner[]{this.bundleDependenciesJarScanner, this.defaultJarScanner};
        JarScanner[] chainExtensions = this.jarScannerCustomizer.extendJarScannerChain(bundle);
        JarScanner[] finalJarScanners = null;
        if (chainExtensions != null && chainExtensions.length > 0) {
            finalJarScanners = new JarScanner[jarScanners.length + chainExtensions.length];
            System.arraycopy(jarScanners, 0, finalJarScanners, 0, jarScanners.length);
            System.arraycopy(chainExtensions, 0, finalJarScanners, jarScanners.length, chainExtensions.length);
        } else {
            finalJarScanners = jarScanners;
        }
        return new ChainingJarScanner(finalJarScanners);
    }

    private static class ExtendCatalina
    extends Catalina {
        private ExtendCatalina() {
        }

        public Digester createStartDigester() {
            return super.createStartDigester();
        }
    }

    private static class ExtendedContextConfig
    extends ContextConfig {
        private ExtendedContextConfig() {
        }
    }
}

