/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;

public class CreateTableNode
extends DDLStatementNode {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = ((Character)object4).charValue();
        this.implicitCreateSchema = true;
        this.initAndCheck(object);
        this.tableElementList = (TableElementList)object2;
        this.properties = (Properties)object3;
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        this.tableType = 3;
        object = this.tempTableSchemaNameCheck(object);
        this.onCommitDeleteRows = (Boolean)object4;
        this.onRollbackDeleteRows = (Boolean)object5;
        this.initAndCheck(object);
        this.tableElementList = (TableElementList)object2;
        this.properties = (Properties)object3;
    }

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.initAndCheck(object);
        this.resultColumns = (ResultColumnList)object2;
        this.queryExpression = (ResultSetNode)object3;
    }

    private Object tempTableSchemaNameCheck(Object object) throws StandardException {
        TableName tableName = (TableName)object;
        if (tableName != null) {
            if (tableName.getSchemaName() == null) {
                tableName.setSchemaName("SESSION");
            } else if (!this.isSessionSchema(tableName.getSchemaName())) {
                throw StandardException.newException("428EK");
            }
        }
        return tableName;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        Object object;
        FromList fromList;
        DataDictionary dataDictionary = this.getDataDictionary();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.tableType != 3, true);
        if (this.queryExpression != null) {
            fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            object = this.getCompilerContext();
            ProviderList providerList = object.getCurrentAuxiliaryProviderList();
            ProviderList providerList2 = new ProviderList();
            try {
                object.setCurrentAuxiliaryProviderList(providerList2);
                object.pushCurrentPrivType(0);
                this.queryExpression = this.queryExpression.bindNonVTITables(dataDictionary, fromList);
                this.queryExpression = this.queryExpression.bindVTITables(fromList);
                this.queryExpression.bindExpressions(fromList);
                this.queryExpression.bindResultColumns(fromList);
                this.queryExpression.bindUntypedNullsToResultColumns(null);
                Object var13_12 = null;
                object.popCurrentPrivType();
                object.setCurrentAuxiliaryProviderList(providerList);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                object.popCurrentPrivType();
                object.setCurrentAuxiliaryProviderList(providerList);
                throw throwable;
            }
            ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
            if (this.resultColumns != null) {
                if (this.resultColumns.size() != resultColumnList.visibleSize()) {
                    throw StandardException.newException("42X70", this.getFullName());
                }
                resultColumnList.copyResultColumnNames(this.resultColumns);
            }
            int n6 = schemaDescriptor.getCollationType();
            this.tableElementList = new TableElementList();
            for (int i = 0; i < resultColumnList.size(); ++i) {
                ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                if (resultColumn.isGenerated()) continue;
                if (resultColumn.isNameGenerated()) {
                    throw StandardException.newException("42909");
                }
                DataTypeDescriptor dataTypeDescriptor = resultColumn.getExpression().getTypeServices();
                if (dataTypeDescriptor != null && !dataTypeDescriptor.isUserCreatableType()) {
                    throw StandardException.newException("42X71", (Object)dataTypeDescriptor.getFullSQLTypeName(), (Object)resultColumn.getName());
                }
                if (dataTypeDescriptor.getTypeId().isStringTypeId() && dataTypeDescriptor.getCollationType() != n6) {
                    throw StandardException.newException("42ZA3", (Object)dataTypeDescriptor.getCollationName(), (Object)DataTypeDescriptor.getCollationName(n6));
                }
                ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.getNodeFactory().getNode(116, resultColumn.getName(), null, resultColumn.getType(), null, this.getContextManager());
                this.tableElementList.addTableElement(columnDefinitionNode);
            }
        } else {
            this.tableElementList.setCollationTypesOnCharacterStringColumns(this.getSchemaDescriptor(this.tableType != 3, true));
        }
        this.tableElementList.validate(this, dataDictionary, null);
        if (this.tableElementList.countNumberOfColumns() > 1012) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
        }
        n = this.tableElementList.countConstraints(2);
        if (n > 1) {
            throw StandardException.newException("42X90", this.getRelativeName());
        }
        n2 = this.tableElementList.countConstraints(4);
        n3 = this.tableElementList.countConstraints(6);
        n4 = this.tableElementList.countConstraints(3);
        n5 = this.tableElementList.countGenerationClauses();
        if (this.tableType == 3 && (n > 0 || n2 > 0 || n3 > 0 || n4 > 0)) {
            throw StandardException.newException("42995");
        }
        if (n + n3 + n4 > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(n + n3 + n4), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (n2 > 0 || n5 > 0 || n3 > 0) {
            fromList = this.makeFromList(null, this.tableElementList, true);
            object = new FormatableBitSet();
            if (n5 > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(schemaDescriptor, fromList, (FormatableBitSet)object, null);
            }
            if (n2 > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (n3 > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, (FormatableBitSet)object);
            }
        }
        if (n > 0) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.getSchemaDescriptor(this.tableType != 3, true));
    }

    public ConstantAction makeConstantAction() throws StandardException {
        TableElementList tableElementList = this.tableElementList;
        ColumnInfo[] columnInfoArray = new ColumnInfo[tableElementList.countNumberOfColumns()];
        int n = tableElementList.genColumnInfos(columnInfoArray);
        ConstraintConstantAction[] constraintConstantActionArray = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.tableType != 3, true);
        if (n > 0) {
            constraintConstantActionArray = new CreateConstraintConstantAction[n];
            tableElementList.genConstraintActions(true, constraintConstantActionArray, this.getRelativeName(), schemaDescriptor, this.getDataDictionary());
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < columnInfoArray.length; ++i) {
            DataTypeDescriptor dataTypeDescriptor = columnInfoArray[i].dataType;
            if (dataTypeDescriptor.getTypeId().isLongConcatableTypeId()) {
                bl = true;
                break;
            }
            n2 += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (!(!bl && n2 <= 4096 || this.properties != null && this.properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateTableConstantAction(schemaDescriptor.getSchemaName(), this.getRelativeName(), this.tableType, columnInfoArray, (CreateConstraintConstantAction[])constraintConstantActionArray, this.properties, this.lockGranularity, this.onCommitDeleteRows, this.onRollbackDeleteRows);
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableElementList != null) {
            this.tableElementList.accept(visitor);
        }
    }
}

