/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LazyValidator
implements InvocationHandler {
    private final ReentrantLock lock = new ReentrantLock();
    private final ValidatorFactory factory;
    private Validator validator = null;

    public LazyValidator(ValidatorFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.validator == null) {
            ReentrantLock l = this.lock;
            l.lock();
            try {
                if (this.validator == null) {
                    this.validator = this.factory.usingContext().getValidator();
                }
            }
            finally {
                l.unlock();
            }
        }
        return method.invoke((Object)this.validator, args);
    }
}

