/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Locale;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;

public final class WebContainerUtils {
    public static final String WEB_BUNDLE_SCHEME = "webbundle";
    public static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    public static final String HEADER_DEFAULT_WAB_HEADERS = "org-eclipse-gemini-web-DefaultWABHeaders";
    public static final String HEADER_WEB_JSP_EXTRACT_LOCATION = "Web-JSPExtractLocation";
    static final String ENTRY_WEB_XML = "/WEB-INF/web.xml";
    static final String WAR_EXTENSION = ".war";
    static final String OSGI_WEB_VERSION = "osgi.web.version";
    static final String OSGI_WEB_SYMBOLICNAME = "osgi.web.symbolicname";
    static final String BUNDLE_VERSION_HEADER = "bundle-version";

    private WebContainerUtils() {
    }

    public static boolean isWebBundle(Bundle bundle) {
        return WebContainerUtils.hasWarExtension(bundle) || WebContainerUtils.hasWarScheme(bundle) || WebContainerUtils.hasWebContextPath(bundle) || WebContainerUtils.hasWebXml(bundle);
    }

    private static boolean hasWarExtension(Bundle bundle) {
        String lowerCaseLocation = bundle.getLocation().toLowerCase(Locale.ENGLISH);
        while (lowerCaseLocation.endsWith("/")) {
            lowerCaseLocation = lowerCaseLocation.substring(0, lowerCaseLocation.length() - 1);
        }
        return lowerCaseLocation.endsWith(WAR_EXTENSION);
    }

    private static boolean hasWarScheme(Bundle bundle) {
        return bundle.getLocation().startsWith(WEB_BUNDLE_SCHEME);
    }

    private static boolean hasWebContextPath(Bundle bundle) {
        return WebContainerUtils.getWebContextPathHeader(bundle) != null;
    }

    private static String getWebContextPathHeader(Bundle bundle) {
        return (String)bundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH);
    }

    private static boolean hasWebXml(Bundle bundle) {
        return bundle.getEntry(ENTRY_WEB_XML) != null;
    }

    public static String getContextPath(Bundle bundle) {
        String contextPath = WebContainerUtils.getWebContextPathHeader(bundle);
        if (contextPath == null) {
            contextPath = WebContainerUtils.getBaseName(bundle.getLocation());
        }
        return contextPath;
    }

    public static String createDefaultBundleSymbolicName(URL source) {
        return WebContainerUtils.getBaseName(source.getPath());
    }

    static String getBaseName(String path) {
        String base = path;
        if ((base = WebContainerUtils.unifySeparators(base)).endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        base = WebContainerUtils.stripQuery(base);
        base = WebContainerUtils.stripSchemeAndDrive(base);
        base = WebContainerUtils.stripLeadingPathElements(base);
        base = WebContainerUtils.stripExtension(base);
        return base;
    }

    private static String unifySeparators(String base) {
        return base.replaceAll("\\\\", "/");
    }

    private static String stripExtension(String base) {
        int index = base.lastIndexOf(".");
        if (index > -1) {
            base = base.substring(0, index);
        }
        return base;
    }

    private static String stripLeadingPathElements(String base) {
        int index = base.lastIndexOf("/");
        if (index > -1) {
            base = base.substring(index + 1);
        }
        return base;
    }

    private static String stripQuery(String path) {
        String result = path;
        int index = result.lastIndexOf("?");
        if (index > -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    private static String stripSchemeAndDrive(String path) {
        String result = path;
        int index = result.indexOf(":");
        while (index > -1 && index < result.length()) {
            result = result.substring(index + 1);
            index = result.indexOf(":");
        }
        return result;
    }

    public static void setServletContextBundleProperties(Dictionary<String, String> properties, Bundle bundle) {
        WebContainerUtils.setServletContextOsgiWebSymbolicNameProperty(properties, bundle);
        WebContainerUtils.setServletContextOsgiWebVersionProperty(properties, bundle);
    }

    private static void setServletContextOsgiWebVersionProperty(Dictionary<String, String> properties, Bundle bundle) {
        if (bundle.getHeaders().get(BUNDLE_VERSION_HEADER) != null) {
            properties.put(OSGI_WEB_VERSION, bundle.getVersion().toString());
        }
    }

    private static void setServletContextOsgiWebSymbolicNameProperty(Dictionary<String, String> properties, Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            properties.put(OSGI_WEB_SYMBOLICNAME, symbolicName);
        }
    }

    public static boolean isWebApplicationBundle(BundleManifest manifest) {
        return WebContainerUtils.specifiesBundleSymbolicName(manifest) || WebContainerUtils.specifiesBundleVersion(manifest) || WebContainerUtils.specifiesBundleManifestVersion(manifest) || WebContainerUtils.specifiesImportPackage(manifest) || WebContainerUtils.specifiesWebContextPath(manifest);
    }

    private static boolean specifiesBundleSymbolicName(BundleManifest manifest) {
        return manifest.getBundleSymbolicName().getSymbolicName() != null;
    }

    private static boolean specifiesBundleVersion(BundleManifest manifest) {
        return manifest.getHeader("Bundle-Version") != null;
    }

    private static boolean specifiesBundleManifestVersion(BundleManifest manifest) {
        return manifest.getBundleManifestVersion() != 1;
    }

    private static boolean specifiesImportPackage(BundleManifest manifest) {
        return !manifest.getImportPackage().getImportedPackages().isEmpty();
    }

    private static boolean specifiesWebContextPath(BundleManifest manifest) {
        return manifest.getHeader(HEADER_WEB_CONTEXT_PATH) != null;
    }
}

