/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.snaps.core.SnapRegistry;
import org.eclipse.virgo.snaps.core.internal.Snap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiSnapRegistry
implements SnapRegistry {
    private static final String PROPERTY_SNAP_CONTEXT_PATH = "snap.context.path";
    private static final String FILTER_PATTERN = "(& (objectClass=" + Snap.class.getName() + ")(snap.host.id=%d))";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final ServiceTracker<Snap, Object> tracker;
    private final Map<String, Snap> snaps = new ConcurrentHashMap<String, Snap>();

    public OsgiSnapRegistry(BundleContext bundleContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, this.createFilter(bundleContext), (ServiceTrackerCustomizer)new OsgiSnapRegistryCustomizer());
    }

    private Filter createFilter(BundleContext bundleContext) throws InvalidSyntaxException {
        String filterString = String.format(FILTER_PATTERN, bundleContext.getBundle().getBundleId());
        return FrameworkUtil.createFilter((String)filterString);
    }

    @Override
    public void init() {
        this.tracker.open();
        this.logger.info("Snap registry created");
    }

    @Override
    public void destroy() {
        this.logger.info("Snap registry destroyed");
        this.tracker.close();
    }

    @Override
    public Snap findSnapByContextPath(String contextPath) {
        Snap snap = this.snaps.get(contextPath);
        if (snap != null) {
            this.logger.info("Snap '{}' found for context path '{}'", (Object)snap, (Object)contextPath);
        } else {
            this.logger.warn("No snap found for context path '{}'", (Object)contextPath);
        }
        return snap;
    }

    private final class OsgiSnapRegistryCustomizer
    implements ServiceTrackerCustomizer<Snap, Object> {
        private OsgiSnapRegistryCustomizer() {
        }

        public Object addingService(ServiceReference<Snap> reference) {
            String contextPath = this.getSnapContextPath(reference);
            if (contextPath != null) {
                OsgiSnapRegistry.this.logger.info("Adding snap service '{}' to service registry for context path '{}'", (Object)reference.toString(), (Object)contextPath);
                Snap snap = (Snap)OsgiSnapRegistry.this.bundleContext.getService(reference);
                OsgiSnapRegistry.this.snaps.put(contextPath, snap);
                return contextPath;
            }
            OsgiSnapRegistry.this.logger.warn("Not adding snap service '{}' to service registry as context path is null", (Object)reference.toString());
            return null;
        }

        public void modifiedService(ServiceReference<Snap> reference, Object service) {
        }

        public void removedService(ServiceReference<Snap> reference, Object service) {
            String contextPath = this.getSnapContextPath(reference);
            if (contextPath != null) {
                OsgiSnapRegistry.this.logger.info("Removing snap service '{}' from service registry for context path '{}'", (Object)reference.toString(), (Object)contextPath);
                OsgiSnapRegistry.this.snaps.remove(contextPath);
            }
            OsgiSnapRegistry.this.logger.warn("Not removing snap service '{}' from registry as context path is null", (Object)reference.toString());
            OsgiSnapRegistry.this.bundleContext.ungetService(reference);
        }

        private String getSnapContextPath(ServiceReference<Snap> reference) {
            return (String)reference.getProperty(OsgiSnapRegistry.PROPERTY_SNAP_CONTEXT_PATH);
        }
    }
}

