/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.util.math.Sets;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

final class StandardScopeServiceRepository
implements ScopeServiceRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<Service>> scopeServices = new HashMap<String, List<Service>>();
    private final Object monitor = new Object();

    StandardScopeServiceRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordService(String scopeName, String[] types, Dictionary<String, Object> properties) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding service to scope '{}' with service types '{}' and properties '{}'", new Object[]{scopeName, StringUtils.arrayToCommaDelimitedString((Object[])types), StandardScopeServiceRepository.dictionaryToCommaSeparatedString(properties)});
        }
        Object object = this.monitor;
        synchronized (object) {
            if (properties == null) {
                properties = new Hashtable<String, Object>();
            }
            this.setStandardProperties(types, properties);
            List<Service> servicesForScope = this.scopeServices.get(scopeName);
            if (servicesForScope == null) {
                servicesForScope = new ArrayList<Service>();
                this.scopeServices.put(scopeName, servicesForScope);
            }
            servicesForScope.add(new Service(types, properties));
        }
    }

    private static String dictionaryToCommaSeparatedString(Dictionary<String, Object> properties) {
        StringBuffer propsString = new StringBuffer();
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            int i = 0;
            while (keys.hasMoreElements()) {
                if (i > 0) {
                    propsString.append(", ");
                }
                String key = keys.nextElement();
                propsString.append(String.valueOf(key) + "=" + properties.get(key).toString());
                ++i;
            }
        }
        return propsString.toString();
    }

    private void setStandardProperties(String[] types, Dictionary<String, Object> properties) {
        if (properties.get("objectClass") == null) {
            properties.put("objectClass", types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scopeHasMatchingService(String scopeName, String type, String filter) throws InvalidSyntaxException {
        Object object = this.monitor;
        synchronized (object) {
            List<Service> servicesForScope = this.scopeServices.get(scopeName);
            boolean matches = false;
            if (servicesForScope != null) {
                Filter f = filter == null ? null : FrameworkUtil.createFilter((String)filter);
                for (Service service : servicesForScope) {
                    if (!service.matches(type, f)) continue;
                    matches = true;
                    break;
                }
            }
            return matches;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScope(String scopeName) {
        Object object = this.monitor;
        synchronized (object) {
            this.scopeServices.remove(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> knownScopes() {
        HashSet<String> scopes = new HashSet<String>();
        Object object = this.monitor;
        synchronized (object) {
            scopes.addAll(this.scopeServices.keySet());
        }
        return scopes;
    }

    private static final class Service {
        private final Set<String> types;
        private final Dictionary<String, Object> properties;

        public Service(String[] types, Dictionary<String, Object> properties) {
            this.types = Sets.asSet((Object[])types);
            this.properties = properties;
        }

        public boolean matches(String type, Filter filter) {
            if (type == null || this.types.contains(type)) {
                return filter == null || filter.match(this.properties);
            }
            return false;
        }
    }
}

