/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.chain;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

class ChainedQuery
implements Query {
    private final List<Query> queries;

    ChainedQuery(List<Query> queries) {
        this.queries = queries;
    }

    @Override
    public Query addFilter(String name, String value) {
        for (Query query : this.queries) {
            query.addFilter(name, value);
        }
        return this;
    }

    @Override
    public Query addFilter(String name, String value, Map<String, Set<String>> properties) {
        for (Query query : this.queries) {
            query.addFilter(name, value, properties);
        }
        return this;
    }

    @Override
    public Query setVersionRangeFilter(VersionRange versionRange) {
        for (Query query : this.queries) {
            query.setVersionRangeFilter(versionRange);
        }
        return this;
    }

    @Override
    public Query setVersionRangeFilter(VersionRange versionRange, Query.VersionRangeMatchingStrategy strategy) {
        for (Query query : this.queries) {
            query.setVersionRangeFilter(versionRange, strategy);
        }
        return this;
    }

    @Override
    public Set<RepositoryAwareArtifactDescriptor> run() {
        TreeSet<RepositoryAwareArtifactDescriptor> artefacts = new TreeSet<RepositoryAwareArtifactDescriptor>();
        int index = 0;
        for (Query query : this.queries) {
            Set<RepositoryAwareArtifactDescriptor> queryResult = query.run();
            for (RepositoryAwareArtifactDescriptor artefact : queryResult) {
                artefacts.add(new ComparableArtifactDescriptor(index++, artefact));
            }
        }
        return artefacts;
    }

    static final class ComparableArtifactDescriptor
    implements RepositoryAwareArtifactDescriptor,
    Comparable<ComparableArtifactDescriptor> {
        private final int index;
        private final RepositoryAwareArtifactDescriptor artifactDescriptor;

        ComparableArtifactDescriptor(int index, RepositoryAwareArtifactDescriptor artefact) {
            this.index = index;
            this.artifactDescriptor = artefact;
        }

        @Override
        public Set<Attribute> getAttribute(String name) {
            return this.artifactDescriptor.getAttribute(name);
        }

        @Override
        public Set<Attribute> getAttributes() {
            return this.artifactDescriptor.getAttributes();
        }

        @Override
        public String getName() {
            return this.artifactDescriptor.getName();
        }

        @Override
        public String getType() {
            return this.artifactDescriptor.getType();
        }

        @Override
        public URI getUri() {
            return this.artifactDescriptor.getUri();
        }

        @Override
        public Version getVersion() {
            return this.artifactDescriptor.getVersion();
        }

        @Override
        public int compareTo(ComparableArtifactDescriptor o) {
            return this.index - o.index;
        }

        public boolean equals(Object o) {
            return this.artifactDescriptor.equals(o);
        }

        public int hashCode() {
            return this.artifactDescriptor.hashCode();
        }

        @Override
        public String getFilename() {
            return this.artifactDescriptor.getFilename();
        }

        @Override
        public String getRepositoryName() {
            return this.artifactDescriptor.getRepositoryName();
        }
    }
}

