/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.module.core;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.module.core.ServerModuleDelegate;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class ServerModuleFactoryDelegate
extends ProjectModuleFactoryDelegate {
    public static final String MODULE_FACTORY_ID = "org.eclipse.virgo.server.modulefactory";

    public ModuleDelegate getModuleDelegate(IModule module) {
        return new ServerModuleDelegate(module.getProject());
    }

    protected IModule[] createModules(final IProject project) {
        final HashSet<IModule> modules = new HashSet<IModule>();
        if (FacetUtils.isBundleProject((IResource)project)) {
            modules.add(this.createModule(project.getName(), project.getName(), "org.eclipse.virgo.server.bundle", "1.0", project));
            IProject[] iProjectArray = FacetUtils.getParProjects((IProject)project);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject parProject = iProjectArray[n2];
                modules.add(this.createModule(String.valueOf(parProject.getName()) + "$" + project.getName(), project.getName(), "org.eclipse.virgo.server.bundle", "1.0", project));
                ++n2;
            }
        } else if (FacetUtils.isParProject((IResource)project)) {
            modules.add(this.createModule(project.getName(), project.getName(), "org.eclipse.virgo.server.par", "1.0", project));
        }
        if (FacetUtils.isPlanProject((IResource)project)) {
            final HashSet<IPath> outputLocations = new HashSet<IPath>();
            try {
                if (FacetUtils.hasNature((IResource)project, (String)"org.eclipse.jdt.core.javanature")) {
                    IJavaProject je = JavaCore.create((IProject)project);
                    try {
                        outputLocations.add(je.getOutputLocation());
                        IClasspathEntry[] iClasspathEntryArray = je.getRawClasspath();
                        int n = iClasspathEntryArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IClasspathEntry entry = iClasspathEntryArray[n3];
                            if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                                outputLocations.add(entry.getOutputLocation());
                            }
                            ++n3;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile && resource.getName().endsWith(".plan")) {
                            modules.add(ServerModuleFactoryDelegate.this.createModule(resource.getFullPath().toString(), String.valueOf(resource.getProject().getName()) + "/" + resource.getProjectRelativePath().toString(), "org.eclipse.virgo.server.plan", "2.0", project));
                        } else if (resource instanceof IContainer) {
                            IPath path = ((IContainer)resource).getFullPath();
                            for (IPath outputLocation : outputLocations) {
                                if (!outputLocation.isPrefixOf(path)) continue;
                                return false;
                            }
                            return true;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    protected IPath[] getListenerPaths() {
        final ArrayList<Path> paths = new ArrayList<Path>();
        IModule[] iModuleArray = this.getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (FacetUtils.isPlanProject((IResource)module.getProject())) {
                try {
                    module.getProject().accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IFile && resource.getName().endsWith(".plan")) {
                                paths.add(resource.getProjectRelativePath());
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        paths.add(new Path(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        paths.add(new Path(".project"));
        paths.add(new Path(".settings"));
        paths.add(new Path(".classpath"));
        return paths.toArray(new IPath[paths.size()]);
    }
}

