/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors.xml;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.AllClassesValueAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.StandardXmlArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Log4JXmlArtifactAnalyzer
implements ArtifactAnalyzer {
    private static final String EXPRESSION = "//appender/@class | //layout/@class";

    @Override
    public void analyse(InputStream artifact, String artifactName, PartialManifest partialManifest) throws Exception {
        new StandardXmlArtifactAnalyzer(artifact, new Log4JEntityResolver()).analyzeValues(EXPRESSION, new AllClassesValueAnalyzer(partialManifest));
    }

    @Override
    public boolean canAnalyse(String artefactName) {
        return "log4j.xml".equals(artefactName);
    }

    private static class Log4JEntityResolver
    implements EntityResolver {
        private static final String LOG4J_DTD = "org/eclipse/virgo/bundlor/support/contributors/log4j.dtd";

        private Log4JEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("log4j.dtd")) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                return new InputSource(classLoader.getResourceAsStream(LOG4J_DTD));
            }
            return null;
        }
    }
}

