/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.ObjectiveComparatorHelper;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class HillClimbingStrategy
implements IStrategy {
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private ThreadContext context;
    private Logger logger = Logger.getLogger(IStrategy.class);
    private Random random = new Random();
    private double percentOfOpenedStates;
    private ObjectiveComparatorHelper objectiveComparatorHelper;

    public HillClimbingStrategy() {
        this(2.0);
    }

    public HillClimbingStrategy(double percentOfOpenedStates) {
        this.percentOfOpenedStates = percentOfOpenedStates;
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.objectiveComparatorHelper = context.getObjectiveComparatorHelper();
        this.logger.info((Object)"Hill climbing exploration strategy is initied.");
    }

    @Override
    public void explore() {
        boolean isSuccessfulUndo;
        boolean globalConstraintsAreSatisfied = this.context.checkGlobalConstraints();
        if (!globalConstraintsAreSatisfied && !(isSuccessfulUndo = this.context.backtrack())) {
            this.logger.info((Object)"Global contraint is not satisifed and cannot backtrack.");
            return;
        }
        do {
            Fitness previousFitness = this.context.calculateFitness();
            this.logger.debug((Object)("Current depth: " + this.context.getDepth() + " Fitness: " + previousFitness));
            Collection<Object> transitionsFromCurrentState = this.context.getCurrentActivationIds();
            if (transitionsFromCurrentState.isEmpty()) {
                this.logger.debug((Object)"No transitions from current state: considered as a solution.");
                this.saveSolutionAndBacktrack();
                continue;
            }
            ArrayList<Object> transitionsToTry = new ArrayList<Object>(transitionsFromCurrentState.size());
            for (Object transition : transitionsFromCurrentState) {
                transitionsToTry.add(transition);
            }
            double numberOfTransitionsToTry = (double)transitionsToTry.size() * this.percentOfOpenedStates;
            while (numberOfTransitionsToTry > 0.0 && !transitionsToTry.isEmpty()) {
                int index = this.random.nextInt(transitionsToTry.size());
                Object transition = transitionsToTry.remove(index);
                this.context.executeAcitvationId(transition);
                if (!this.context.checkGlobalConstraints()) {
                    this.logger.debug((Object)"Global contraint is not satisifed, backtrack.");
                    this.context.backtrack();
                } else if (this.context.isCurrentStateInTrajectory()) {
                    this.logger.debug((Object)"Current state is in trajectory, backtrack.");
                    this.context.backtrack();
                } else {
                    Fitness fitness = this.context.calculateFitness();
                    this.objectiveComparatorHelper.addTrajectoryFitness(new TrajectoryFitness(this.context.getTrajectoryInfo().getLastActivationId(), fitness));
                    this.context.backtrack();
                }
                numberOfTransitionsToTry -= 1.0;
            }
            if (this.objectiveComparatorHelper.getTrajectoryFitnesses().isEmpty()) {
                this.logger.debug((Object)"No viable transitions from current state: considered as a solution.");
                this.saveSolutionAndBacktrack();
                continue;
            }
            TrajectoryFitness randomBestFitness = this.objectiveComparatorHelper.getRandomBest();
            this.objectiveComparatorHelper.clearTrajectoryFitnesses();
            int compare = this.objectiveComparatorHelper.compare(previousFitness, randomBestFitness.fitness);
            if (compare > 0) {
                this.saveSolutionAndBacktrack();
                continue;
            }
            previousFitness = randomBestFitness.fitness;
            Object transition = randomBestFitness.trajectory[randomBestFitness.trajectory.length - 1];
            this.context.executeAcitvationId(transition);
        } while (!this.isInterrupted.get());
        this.logger.info((Object)"Terminated.");
    }

    private void saveSolutionAndBacktrack() {
        this.context.calculateFitness();
        this.context.newSolution();
        this.logger.debug((Object)("Found solution: " + this.context.getTrajectoryInfo().toString()));
        this.logger.debug((Object)"Backtrack for more solutions, if needed.");
        this.context.backtrackUntilRoot();
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted.set(true);
    }
}

