/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.index.DefaultIndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.delayed.DelayedConnectCommand;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class DualInputNode
extends StandardNode
implements NetworkStructureChangeSensitiveNode {
    protected NetworkStructureChangeSensitiveLogic logic;
    protected IterableIndexer primarySlot;
    protected Indexer secondarySlot;
    protected TupleMask complementerSecondaryMask;
    protected boolean coincidence;
    protected Map<Indexer, Boolean> indexerGroupCache;

    public IterableIndexer getPrimarySlot() {
        return this.primarySlot;
    }

    public Indexer getSecondarySlot() {
        return this.secondarySlot;
    }

    public DualInputNode(ReteContainer reteContainer, TupleMask complementerSecondaryMask) {
        super(reteContainer);
        this.complementerSecondaryMask = complementerSecondaryMask;
        this.indexerGroupCache = CollectionsFactory.createMap();
        this.refreshIndexerGroupCache();
    }

    public void connectToIndexers(IterableIndexer primarySlot, Indexer secondarySlot) {
        this.primarySlot = primarySlot;
        this.secondarySlot = secondarySlot;
        this.reteContainer.getCommunicationTracker().registerDependency(primarySlot, this);
        this.reteContainer.getCommunicationTracker().registerDependency(secondarySlot, this);
        this.coincidence = primarySlot.equals(secondarySlot);
        if (!this.coincidence) {
            primarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
                    DualInputNode.this.logic.notifyUpdate(Side.PRIMARY, direction, updateElement, signature, change, timestamp);
                }

                public String toString() {
                    return "primary@" + String.valueOf(DualInputNode.this);
                }
            });
            secondarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
                    DualInputNode.this.logic.notifyUpdate(Side.SECONDARY, direction, updateElement, signature, change, timestamp);
                }

                public String toString() {
                    return "secondary@" + String.valueOf(DualInputNode.this);
                }
            });
        } else {
            primarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
                    DualInputNode.this.logic.notifyUpdate(Side.BOTH, direction, updateElement, signature, change, timestamp);
                }

                public String toString() {
                    return "both@" + String.valueOf(DualInputNode.this);
                }
            });
        }
        for (Receiver receiver : this.getReceivers()) {
            this.reteContainer.getDelayedCommandQueue().add(new DelayedConnectCommand(this, receiver, this.reteContainer));
        }
        this.refreshIndexerGroupCache();
    }

    protected Collection<Tuple> retrieveOpposites(Side side, Tuple signature) {
        return this.getSlot(side.opposite()).get(signature);
    }

    protected NetworkStructureChangeSensitiveLogic createLogic() {
        if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            return this.createTimelyLogic();
        }
        return this.createTimelessLogic();
    }

    protected Tuple unify(Tuple left, Tuple right) {
        return this.complementerSecondaryMask.combine(left, right, true, true);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        this.logic.pullInto(collector, flush);
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        this.logic.pullIntoWithTimeline(collector, flush);
    }

    protected Tuple unify(Side side, Tuple ps, Tuple opposite) {
        switch (side) {
            case PRIMARY: {
                return this.unify(ps, opposite);
            }
            case SECONDARY: {
                return this.unify(opposite, ps);
            }
            case BOTH: {
                return this.unify(ps, opposite);
            }
        }
        return null;
    }

    public abstract Tuple calibrate(Tuple var1, Tuple var2);

    public void setComplementerSecondaryMask(TupleMask complementerSecondaryMask) {
        this.complementerSecondaryMask = complementerSecondaryMask;
    }

    protected Indexer getSlot(Side side) {
        if (side == Side.SECONDARY) {
            return this.secondarySlot;
        }
        return this.primarySlot;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateToIndexerParent()) {
            if (this.primarySlot != null) {
                this.primarySlot.acceptPropagatedTraceInfo(traceInfo);
            }
            if (this.secondarySlot != null) {
                this.secondarySlot.acceptPropagatedTraceInfo(traceInfo);
            }
        }
    }

    @Override
    public void networkStructureChanged() {
        super.networkStructureChanged();
        this.logic = this.createLogic();
        this.refreshIndexerGroupCache();
    }

    protected abstract NetworkStructureChangeSensitiveLogic createTimelyLogic();

    protected abstract NetworkStructureChangeSensitiveLogic createTimelessLogic();

    protected void refreshIndexerGroupCache() {
        this.indexerGroupCache.clear();
        if (this.primarySlot != null) {
            this.indexerGroupCache.put(this.primarySlot, this.reteContainer.getCommunicationTracker().areInSameGroup(this.primarySlot, this));
        }
        if (this.secondarySlot != null) {
            this.indexerGroupCache.put(this.secondarySlot, this.reteContainer.getCommunicationTracker().areInSameGroup(this.secondarySlot, this));
        }
    }

    protected Map<Tuple, Timeline<Timestamp>> getTimeline(Tuple signature, Indexer indexer) {
        if (this.indexerGroupCache.get(indexer).booleanValue()) {
            return indexer.getTimeline(signature);
        }
        Collection<Tuple> tuples = indexer.get(signature);
        if (tuples == null) {
            return null;
        }
        return new Timestamp.AllZeroMap<Tuple>((Set)tuples);
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract void notifyUpdate(Side var1, Direction var2, Tuple var3, Tuple var4, boolean var5, Timestamp var6);

        public abstract void pullInto(Collection<Tuple> var1, boolean var2);

        public abstract void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> var1, boolean var2);
    }

    public static enum Side {
        PRIMARY,
        SECONDARY,
        BOTH;


        public Side opposite() {
            switch (this) {
                case PRIMARY: {
                    return SECONDARY;
                }
                case SECONDARY: {
                    return PRIMARY;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            return BOTH;
        }
    }
}

