/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NewVQGenmodelPage
extends WizardPage {
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Tree referencedGenmodels;
    private TreeViewer genModelViewer;
    private Button addGenmodel;
    private ResourceSet set;
    private Set<GenModel> selectedGenmodels = Sets.newHashSet();

    public NewVQGenmodelPage() {
        super("wizardPage");
        this.setTitle("VIATRA Query Generator model");
        this.setDescription("Set up a generator model used for code generation.");
        this.set = new ResourceSetImpl();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Section sctnReferencedEmfGenerator = this.formToolkit.createSection(container, 320);
        sctnReferencedEmfGenerator.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.paintBordersFor((Composite)sctnReferencedEmfGenerator);
        sctnReferencedEmfGenerator.setText("Referenced EMF Generator models");
        this.referencedGenmodels = this.formToolkit.createTree((Composite)sctnReferencedEmfGenerator, 0);
        this.referencedGenmodels.setEnabled(false);
        this.formToolkit.paintBordersFor((Composite)this.referencedGenmodels);
        sctnReferencedEmfGenerator.setClient((Control)this.referencedGenmodels);
        this.referencedGenmodels.setHeaderVisible(true);
        this.referencedGenmodels.setLinesVisible(true);
        this.genModelViewer = new TreeViewer(this.referencedGenmodels);
        this.genModelViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
            Collection<GenModel> genmodels;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof Collection) {
                    this.genmodels = (Collection)newInput;
                }
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof GenModel && !((GenModel)element).getGenPackages().isEmpty();
            }

            public Object getParent(Object element) {
                if (element instanceof GenPackage) {
                    return ((GenPackage)element).getGenModel();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.genmodels.toArray(new GenModel[this.genmodels.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof GenModel) {
                    EList packages = ((GenModel)parentElement).getGenPackages();
                    return packages.toArray(new GenPackage[packages.size()]);
                }
                return null;
            }
        });
        this.genModelViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){});
        TreeViewerColumn resourcePathColumn = new TreeViewerColumn(this.genModelViewer, 16384);
        resourcePathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GenModel) {
                    return ((GenModel)element).eResource().getURI().toPlatformString(true);
                }
                if (element instanceof GenPackage) {
                    return ((GenPackage)element).getNSURI();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn packageURIColumn = new TreeViewerColumn(this.genModelViewer, 16384);
        packageURIColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GenModel) {
                    return String.format("Plug-in dependency: %s", ((GenModel)element).getModelPluginID());
                }
                if (element instanceof GenPackage) {
                    return "";
                }
                return super.getText(element);
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.referencedGenmodels.setLayout((Layout)tableLayout);
        this.genModelViewer.setInput(this.selectedGenmodels);
        Composite composite_1 = this.formToolkit.createComposite((Composite)sctnReferencedEmfGenerator, 0);
        this.formToolkit.paintBordersFor(composite_1);
        sctnReferencedEmfGenerator.setTextClient((Control)composite_1);
        composite_1.setLayout((Layout)new RowLayout(256));
        this.addGenmodel = this.formToolkit.createButton(composite_1, "Add", 0);
        this.addGenmodel.setEnabled(false);
        this.addGenmodel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewVQGenmodelPage.this.selectGenmodelFromWorkspace();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.addGenmodel.setEnabled(true);
            this.referencedGenmodels.setEnabled(true);
        }
        super.setVisible(visible);
    }

    public void selectGenmodelFromWorkspace() {
        IFile[] files;
        ViewerFilter genmodelFileFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return "genmodel".equals(((IFile)element).getFileExtension());
                }
                return true;
            }
        };
        IFile[] iFileArray = files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), (String)"Select EMF Generator model", (String)"Select EMF generator model(s) to add to the initialized VIATRA Query generator model", (boolean)true, null, (List)ImmutableList.of((Object)genmodelFileFilter));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource res = this.set.getResource(uri, true);
            for (EObject obj : res.getContents()) {
                if (!(obj instanceof GenModel)) continue;
                this.selectedGenmodels.add((GenModel)obj);
            }
            this.genModelViewer.refresh();
            ++n2;
        }
    }

    public Collection<GenModel> getSelectedGenmodels() {
        return this.selectedGenmodels;
    }
}

