/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryFilterSemantics;

public class ViewerDataFilter {
    private static final String FILTER_DEFINED_FOR_PATTERN_MSG = "Filter already defined for pattern %s";
    public static final ViewerDataFilter UNFILTERED = new ViewerDataFilter();
    private Map<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition> filterDefinitions;

    public ViewerDataFilter() {
        this.filterDefinitions = new HashMap<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition>();
    }

    private ViewerDataFilter(Map<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition> filters) {
        this.filterDefinitions = new HashMap<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition>(filters);
    }

    public static ViewerDataFilter cloneFilter(ViewerDataFilter other) {
        return new ViewerDataFilter(other.filterDefinitions);
    }

    public void addSingleFilter(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> pattern, IPatternMatch match) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (String)FILTER_DEFINED_FOR_PATTERN_MSG, (Object[])new Object[]{pattern.getFullyQualifiedName()});
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, ViatraQueryFilterSemantics.SINGLE, match, null));
    }

    public void addMultiFilter(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> pattern, Collection<IPatternMatch> matches, ViatraQueryFilterSemantics semantics) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (String)FILTER_DEFINED_FOR_PATTERN_MSG, (Object[])new Object[]{pattern.getFullyQualifiedName()});
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, semantics, null, matches));
    }

    public void removeFilter(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> pattern) {
        Preconditions.checkArgument((boolean)this.filterDefinitions.containsKey(pattern), (String)"Filter undefined for pattern %s", (Object[])new Object[]{pattern.getFullyQualifiedName()});
        this.filterDefinitions.remove(pattern);
    }

    public boolean isFiltered(IQuerySpecification<?> pattern) {
        return this.filterDefinitions.containsKey(pattern);
    }

    public ViewerFilterDefinition getFilter(IQuerySpecification<?> pattern) {
        return this.filterDefinitions.get(pattern);
    }
}

