/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.algorithms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.algorithms.UnionFindNodeProperty;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public class UnionFind<V> {
    private final Map<V, UnionFindNodeProperty<V>> nodeMap = CollectionsFactory.createMap();
    final Map<V, Set<V>> setMap = CollectionsFactory.createMap();

    public UnionFind() {
    }

    public UnionFind(Iterable<V> elements) {
        this();
        for (V element : elements) {
            this.makeSet(element);
        }
    }

    public V makeSet(Collection<V> nodes) {
        if (!nodes.isEmpty()) {
            Iterator<V> iterator = nodes.iterator();
            V root = this.makeSet(iterator.next());
            while (iterator.hasNext()) {
                root = this.union(root, iterator.next());
            }
            return root;
        }
        return null;
    }

    public V makeSet(V node) {
        if (!this.nodeMap.containsKey(node)) {
            UnionFindNodeProperty<V> prop = new UnionFindNodeProperty<V>(0, node);
            this.nodeMap.put((UnionFindNodeProperty<V>)node, (UnionFindNodeProperty<UnionFindNodeProperty<V>>)prop);
            HashSet<V> set = new HashSet<V>();
            set.add(node);
            this.setMap.put(node, set);
        }
        return node;
    }

    public V find(V node) {
        UnionFindNodeProperty<V> prop = this.nodeMap.get(node);
        if (prop != null) {
            if (prop.parent.equals(node)) {
                return node;
            }
            prop.parent = this.find(prop.parent);
            return prop.parent;
        }
        return null;
    }

    public V union(V x, V y) {
        V xRoot = this.find(x);
        V yRoot = this.find(y);
        if (xRoot == null || yRoot == null) {
            return this.union(xRoot == null ? this.makeSet(x) : xRoot, yRoot == null ? this.makeSet(y) : yRoot);
        }
        if (!xRoot.equals(yRoot)) {
            UnionFindNodeProperty<V> xRootProp = this.nodeMap.get(xRoot);
            UnionFindNodeProperty<V> yRootProp = this.nodeMap.get(yRoot);
            if (xRootProp.rank < yRootProp.rank) {
                xRootProp.parent = yRoot;
                this.setMap.get(yRoot).addAll((Collection)this.setMap.get(xRoot));
                this.setMap.remove(xRoot);
                return yRoot;
            }
            yRootProp.parent = xRoot;
            yRootProp.rank = xRootProp.rank == yRootProp.rank ? yRootProp.rank + 1 : yRootProp.rank;
            this.setMap.get(xRoot).addAll((Collection)this.setMap.get(yRoot));
            this.setMap.remove(yRoot);
            return xRoot;
        }
        return xRoot;
    }

    public void unite(Set<V> elements) {
        if (elements.size() > 1) {
            V current = null;
            for (V element : elements) {
                if (current != null) {
                    if (this.getPartition(element) == null) continue;
                    this.union(current, element);
                    continue;
                }
                if (this.getPartition(element) == null) continue;
                current = element;
            }
        }
    }

    public void deleteSet(V root) {
        for (V n : this.setMap.get(root)) {
            this.nodeMap.remove(n);
        }
        this.setMap.remove(root);
    }

    public boolean isSameUnion(Set<V> elements) {
        for (Set<V> partition : this.setMap.values()) {
            if (!partition.containsAll(elements)) continue;
            return true;
        }
        return false;
    }

    public Set<V> getPartition(V element) {
        V root = this.find(element);
        return this.setMap.get(root);
    }

    public Collection<Set<V>> getPartitions() {
        return this.setMap.values();
    }

    public Set<V> getPartitionHeads() {
        return this.setMap.keySet();
    }
}

