/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch;

import java.util.Arrays;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class MatchingFrame
extends VolatileTuple
implements IModifiableTuple {
    private Object[] frame;

    public MatchingFrame(int frameSize) {
        this.frame = new Object[frameSize];
    }

    public MatchingFrame(MatchingFrame other) {
        this.frame = Arrays.copyOf(other.frame, other.frame.length);
    }

    public Object getValue(int position) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        return this.frame[position];
    }

    public void setValue(int position, Object value) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        this.frame[position] = value;
    }

    public boolean testAndSetValue(Integer position, Object value) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        if (this.frame[position] == null) {
            this.frame[position.intValue()] = value;
            return true;
        }
        return this.frame[position].equals(value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.frame.length) {
            builder.append("frame[" + i + "]\t" + (this.frame[i] == null ? "null" : this.frame[i]).toString() + "\n");
            ++i;
        }
        return builder.toString();
    }

    public int getSize() {
        return this.frame.length;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object[] getElements() {
        return Arrays.copyOf(this.frame, this.frame.length);
    }

    public void set(int index, Object value) {
        this.frame[index] = value;
    }
}

