/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.gef4.zest.core.widgets.internal.XYScaledGraphics;

public class AspectRatioFreeformLayer
extends FreeformLayer
implements ScalableFigure,
FreeformFigure {
    private double widthScale = 1.0;
    private double heigthScale = 1.0;

    public AspectRatioFreeformLayer(String debugLabel) {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setBorder((Border)new MarginBorder(5));
    }

    protected boolean isValidationRoot() {
        return true;
    }

    public void setScale(double wScale, double hScale) {
        this.widthScale = wScale;
        this.heigthScale = hScale;
    }

    public double getWidthScale() {
        return this.widthScale;
    }

    public double getHeightScale() {
        return this.heigthScale;
    }

    public double getScale() {
        throw new RuntimeException("Operation not supported");
    }

    public void setScale(double scale) {
        this.widthScale = scale;
        this.heigthScale = scale;
        this.revalidate();
        this.repaint();
    }

    public Rectangle getClientArea(Rectangle rect) {
        rect.width = (int)((double)rect.width / this.widthScale);
        rect.height = (int)((double)rect.height / this.heigthScale);
        rect.x = (int)((double)rect.x / this.widthScale);
        rect.y = (int)((double)rect.y / this.heigthScale);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.widthScale, this.heigthScale).expand(w, h);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        if (t instanceof PrecisionRectangle) {
            PrecisionRectangle r = (PrecisionRectangle)t;
            r.setPreciseX(r.preciseX() * (1.0 / this.widthScale));
            r.setPreciseY(r.preciseY() * (1.0 / this.heigthScale));
            r.setPreciseWidth(r.preciseWidth() * (1.0 / this.widthScale));
            r.setPreciseHeight(r.preciseHeight() * (1.0 / this.heigthScale));
        } else if (t instanceof Rectangle) {
            Rectangle r = (Rectangle)t;
            r.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
        } else if (t instanceof CaretInfo) {
            CaretInfo c = (CaretInfo)t;
            c.performScale(1.0 / this.heigthScale);
        } else if (t instanceof PrecisionDimension) {
            PrecisionDimension d = (PrecisionDimension)t;
            d.setPreciseWidth(d.preciseWidth() * (1.0 / this.widthScale));
            d.setPreciseHeight(d.preciseHeight() * (1.0 / this.heigthScale));
        } else if (t instanceof Dimension) {
            Dimension d = (Dimension)t;
            d.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
        } else if (t instanceof PrecisionPoint) {
            PrecisionPoint p = (PrecisionPoint)t;
            p.setPreciseX(p.preciseX() * (1.0 / this.widthScale));
            p.setPreciseY(p.preciseY() * (1.0 / this.heigthScale));
        } else if (t instanceof Point) {
            Point p = (Point)t;
            p.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
        } else {
            if (t instanceof PointList) {
                throw new RuntimeException("PointList not supported in AspectRatioScale");
            }
            throw new RuntimeException(String.valueOf(t.toString()) + " not supported in AspectRatioScale");
        }
    }

    public void translateToParent(Translatable t) {
        if (t instanceof PrecisionRectangle) {
            PrecisionRectangle r = (PrecisionRectangle)t;
            r.setPreciseX(r.preciseX() * this.widthScale);
            r.setPreciseY(r.preciseY() * this.heigthScale);
            r.setPreciseWidth(r.preciseWidth() * this.widthScale);
            r.setPreciseHeight(r.preciseHeight() * this.heigthScale);
        } else if (t instanceof Rectangle) {
            Rectangle r = (Rectangle)t;
            r.scale(this.widthScale, this.heigthScale);
        } else if (t instanceof CaretInfo) {
            CaretInfo c = (CaretInfo)t;
            c.performScale(this.heigthScale);
        } else if (t instanceof PrecisionDimension) {
            PrecisionDimension d = (PrecisionDimension)t;
            d.setPreciseWidth(d.preciseWidth() * this.widthScale);
            d.setPreciseHeight(d.preciseHeight() * this.heigthScale);
        } else if (t instanceof Dimension) {
            Dimension d = (Dimension)t;
            d.scale(this.widthScale, this.heigthScale);
        } else if (t instanceof PrecisionPoint) {
            PrecisionPoint p = (PrecisionPoint)t;
            p.setPreciseX(p.preciseX() * this.widthScale);
            p.setPreciseY(p.preciseY() * this.heigthScale);
        } else if (t instanceof Point) {
            Point p = (Point)t;
            p.scale(this.widthScale, this.heigthScale);
        } else {
            if (t instanceof PointList) {
                throw new RuntimeException("PointList not supported in AspectRatioScale");
            }
            throw new RuntimeException(String.valueOf(t.toString()) + " not supported in AspectRatioScale");
        }
        super.translateToParent(t);
    }

    protected void paintClientArea(Graphics graphics) {
        boolean optimizeClip;
        if (this.getChildren().isEmpty()) {
            return;
        }
        XYScaledGraphics g = null;
        boolean disposeGraphics = false;
        if (graphics instanceof XYScaledGraphics) {
            g = (XYScaledGraphics)graphics;
        } else {
            g = new XYScaledGraphics(graphics);
            disposeGraphics = true;
        }
        boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
        if (!optimizeClip) {
            g.clipRect(this.getBounds().getShrinked(this.getInsets()));
        }
        g.scale(this.widthScale, this.heigthScale);
        g.pushState();
        this.paintChildren((Graphics)g);
        g.popState();
        if (disposeGraphics) {
            g.dispose();
            graphics.restoreState();
        }
    }
}

