/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.utils.PointListUtils;

abstract class AbstractPointListBasedGeometry<T extends AbstractPointListBasedGeometry<?>>
extends AbstractGeometry
implements ITranslatable<T>,
IScalable<T>,
IRotatable<T> {
    private static final long serialVersionUID = 1L;
    Point[] points;

    public AbstractPointListBasedGeometry(double ... coordinates) {
        this.points = new Point[coordinates.length / 2];
        int i = 0;
        while (i < coordinates.length / 2) {
            this.points[i] = new Point(coordinates[i * 2], coordinates[i * 2 + 1]);
            ++i;
        }
    }

    public AbstractPointListBasedGeometry(Point ... points) {
        this.points = Point.getCopy(points);
    }

    @Override
    public final Rectangle getBounds() {
        return Point.getBounds(this.points);
    }

    public Point getCentroid() {
        return Point.getCentroid(this.points);
    }

    public final double[] getCoordinates() {
        return PointListUtils.toCoordinatesArray(this.points);
    }

    public final Point[] getPoints() {
        return Point.getCopy(this.points);
    }

    @Override
    public T getRotatedCCW(Angle alpha) {
        return (T)this.getRotatedCCW(alpha, this.getCentroid());
    }

    @Override
    public T getRotatedCCW(Angle angle, double cx, double cy) {
        return (T)this.getRotatedCCW(angle, new Point(cx, cy));
    }

    @Override
    public T getRotatedCCW(Angle alpha, Point center) {
        return ((AbstractPointListBasedGeometry)this.getCopy()).rotateCCW(alpha, center);
    }

    @Override
    public T getRotatedCW(Angle alpha) {
        return (T)this.getRotatedCW(alpha, this.getCentroid());
    }

    @Override
    public T getRotatedCW(Angle angle, double cx, double cy) {
        return (T)this.getRotatedCW(angle, new Point(cx, cy));
    }

    @Override
    public T getRotatedCW(Angle alpha, Point center) {
        return ((AbstractPointListBasedGeometry)this.getCopy()).rotateCW(alpha, center);
    }

    @Override
    public T getScaled(double factor) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).scale(factor);
    }

    @Override
    public T getScaled(double factorX, double factorY) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).scale(factorX, factorY);
    }

    @Override
    public T getScaled(double factor, double cx, double cy) {
        return (T)this.getScaled(factor, factor, new Point(cx, cy));
    }

    @Override
    public T getScaled(double fx, double fy, double cx, double cy) {
        return (T)this.getScaled(fx, fy, new Point(cx, cy));
    }

    @Override
    public T getScaled(double factorX, double factorY, Point center) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).scale(factorX, factorY, center);
    }

    @Override
    public T getScaled(double factor, Point center) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).scale(factor, center);
    }

    @Override
    public T getTranslated(double dx, double dy) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).translate(dx, dy);
    }

    @Override
    public T getTranslated(Point pt) {
        return (T)((AbstractPointListBasedGeometry)this.getCopy()).translate(pt);
    }

    public T rotateCCW(Angle alpha) {
        return this.rotateCCW(alpha, this.getCentroid());
    }

    public T rotateCCW(Angle alpha, double cx, double cy) {
        return this.rotateCCW(alpha, new Point(cx, cy));
    }

    public T rotateCCW(Angle alpha, Point center) {
        this.translate(center.getNegated());
        Point[] pointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            Point np = new Vector(p).rotateCCW(alpha).toPoint();
            p.x = np.x;
            p.y = np.y;
            ++n2;
        }
        this.translate(center);
        return (T)this;
    }

    public T rotateCW(Angle alpha) {
        return this.rotateCW(alpha, this.getCentroid());
    }

    public T rotateCW(Angle alpha, double cx, double cy) {
        return this.rotateCW(alpha, new Point(cx, cy));
    }

    public T rotateCW(Angle alpha, Point center) {
        this.translate(center.getNegated());
        Point[] pointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            Point np = new Vector(p).rotateCW(alpha).toPoint();
            p.x = np.x;
            p.y = np.y;
            ++n2;
        }
        this.translate(center);
        return (T)this;
    }

    @Override
    public T scale(double factor) {
        return (T)this.scale(factor, factor);
    }

    @Override
    public T scale(double fx, double fy) {
        return (T)this.scale(fx, fy, this.getCentroid());
    }

    @Override
    public T scale(double factor, double cx, double cy) {
        return (T)this.scale(factor, factor, new Point(cx, cy));
    }

    @Override
    public T scale(double fx, double fy, double cx, double cy) {
        return (T)this.scale(fx, fy, new Point(cx, cy));
    }

    @Override
    public T scale(double fx, double fy, Point center) {
        Point[] pointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            Point np = p.getScaled(fx, fy, center);
            p.x = np.x;
            p.y = np.y;
            ++n2;
        }
        return (T)this;
    }

    @Override
    public T scale(double factor, Point center) {
        return (T)this.scale(factor, factor, center);
    }

    @Override
    public T translate(double dx, double dy) {
        Point.translate(this.points, dx, dy);
        return (T)this;
    }

    @Override
    public T translate(Point p) {
        return (T)this.translate(p.x, p.y);
    }
}

