/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.uml2sd.load;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.EllipsisMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.ExecutionOccurrence;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.HotSpot;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.LifelineCategories;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Stop;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IImage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class TestLoaders
implements IUml2SDLoader,
ISDFindProvider,
ISDFilterProvider,
ISDPagingProvider,
ISelectionListener {
    public SDView v;
    public int page = 1;
    private List<GraphNode> findResults = new ArrayList<GraphNode>();
    private Criteria findCriteria;
    private int currentFindIndex = 0;
    private Frame savedFrame = null;

    public TestLoaders() {
        this("");
    }

    public TestLoaders(String name) {
    }

    public void setViewer(SDView j) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.v = j;
        this.v.setSDPagingProvider((ISDPagingProvider)this);
        this.v.setSDFindProvider((ISDFindProvider)this);
        this.v.setSDFilterProvider((ISDFilterProvider)this);
        this.page = 1;
        this.createFrame();
    }

    public boolean hasNextPage() {
        return this.page == 1;
    }

    public boolean hasPrevPage() {
        return this.page == 2;
    }

    public void prevPage() {
        --this.page;
        this.createFrame();
    }

    public void nextPage() {
        ++this.page;
        this.createFrame();
    }

    private void createFrame() {
        Frame testFrame = new Frame();
        if (this.page == 1) {
            testFrame.setName("Sequence Diagram - First Page");
            LifelineCategories[] tt = new LifelineCategories[]{new LifelineCategories(), new LifelineCategories()};
            tt[1].setName("Categorie 1");
            tt[1].setImage((IImage)new LocalImageImpl("obj16/node_obj.gif"));
            tt[0].setImage((IImage)new LocalImageImpl("obj16/class.gif"));
            tt[0].setName("Categorie 0");
            testFrame.setLifelineCategories(tt);
            Lifeline lifeline = new Lifeline();
            lifeline.setName("LifeLine 0");
            testFrame.addLifeLine(lifeline);
            EllipsisMessage mn = new EllipsisMessage();
            lifeline.getNewEventOccurrence();
            mn.setStartLifeline(lifeline);
            mn.setName("******************* EllipsisisMessage TEST ****************");
            testFrame.addMessage((BaseMessage)mn);
            SyncMessage mn3 = new SyncMessage();
            mn3.setStartLifeline(lifeline);
            testFrame.addMessage((BaseMessage)mn3);
            SyncMessage mn2 = new SyncMessage();
            lifeline.getNewEventOccurrence();
            lifeline.setCategory(0);
            mn2.setEndLifeline(lifeline);
            mn2.setName("*******************Sync TEST ****************");
            testFrame.addMessage((BaseMessage)mn2);
            int i = 1;
            while (i < 300) {
                lifeline = new Lifeline();
                lifeline.setName("LifeLine " + i);
                lifeline.setCategory(1);
                testFrame.addLifeLine(lifeline);
                SyncMessage m3 = new SyncMessage();
                testFrame.getLifeline(i - 1).getNewEventOccurrence();
                m3.setStartLifeline(testFrame.getLifeline(i - 1));
                m3.setEndLifeline(testFrame.getLifeline(i));
                m3.setName("Sync Message " + i);
                testFrame.addMessage((BaseMessage)m3);
                m3.setTime(TmfTimestamp.fromSeconds((long)(i + 1)));
                ++i;
            }
            i = testFrame.lifeLinesCount() - 1;
            while (i > 0) {
                SyncMessageReturn m = new SyncMessageReturn();
                testFrame.getLifeline(i).getNewEventOccurrence();
                m.setStartLifeline(testFrame.getLifeline(i));
                m.setEndLifeline(testFrame.getLifeline(i - 1));
                testFrame.addMessage((BaseMessage)m);
                m.setName("Sync Message return " + i);
                if (i + 1 < testFrame.lifeLinesCount()) {
                    SyncMessage h = testFrame.getSyncMessage(i + 1);
                    m.setMessage(h);
                }
                --i;
            }
            i = 0;
            while (i < testFrame.lifeLinesCount()) {
                if (i > 0) {
                    ExecutionOccurrence occ = new ExecutionOccurrence();
                    occ.setStartOccurrence(testFrame.getSyncMessage(i).getEventOccurrence() + 1);
                    occ.setEndOccurrence(testFrame.getSyncMessageReturn(testFrame.syncMessageReturnCount() - i).getEventOccurrence());
                    testFrame.getLifeline(i).addExecution((BasicExecutionOccurrence)occ);
                    occ.setName("******************* Execution Occurance TEST ****************");
                }
                ++i;
            }
            Stop s = new Stop();
            s.setLifeline(testFrame.getLifeline(1));
            s.setEventOccurrence(testFrame.getLifeline(1).getNewEventOccurrence());
            testFrame.getLifeline(1).addNode((GraphNode)s);
            HotSpot gg = new HotSpot();
            gg.setImage((IImage)new LocalImageImpl("obj16/plus_obj.gif"));
            gg.setExecution((BasicExecutionOccurrence)testFrame.getLifeline(1).getExecutions().get(0));
            AsyncMessageReturn m = new AsyncMessageReturn();
            m.setStartLifeline(testFrame.getLifeline(1));
            m.setEndLifeline(testFrame.getLifeline(3));
            m.setStartOccurrence(2);
            m.setEndOccurrence(6);
            m.setStartTime(TmfTimestamp.fromSeconds((long)2L));
            m.setEndTime(TmfTimestamp.fromSeconds((long)6L));
            m.setName("*******************Async TEST ****************");
            testFrame.addMessage((BaseMessage)m);
            this.v.setFrame(testFrame);
            this.v.getSDWidget().setReorderMode(true);
        } else {
            testFrame.setName("Sequence Diagram");
            Lifeline lifeline = new Lifeline();
            lifeline.setName("LifeLine 0");
            testFrame.addLifeLine(lifeline);
            lifeline = new Lifeline();
            lifeline.setName("LifeLine 1");
            testFrame.addLifeLine(lifeline);
            int i = 1;
            while (i < 30) {
                SyncMessage m3 = new SyncMessage();
                m3.autoSetStartLifeline(testFrame.getLifeline(0));
                m3.autoSetEndLifeline(testFrame.getLifeline(0));
                m3.setName("Message " + i);
                testFrame.addMessage((BaseMessage)m3);
                SyncMessageReturn m = new SyncMessageReturn();
                m.autoSetStartLifeline(testFrame.getLifeline(0));
                m.autoSetEndLifeline(testFrame.getLifeline(0));
                testFrame.addMessage((BaseMessage)m);
                m.setName("Message return " + i);
                ExecutionOccurrence occ = new ExecutionOccurrence();
                occ.setStartOccurrence(testFrame.getSyncMessage(i - 1).getEventOccurrence());
                occ.setEndOccurrence(testFrame.getSyncMessageReturn(i - 1).getEventOccurrence());
                testFrame.getLifeline(0).addExecution((BasicExecutionOccurrence)occ);
                ++i;
            }
        }
        this.v.setFrame(testFrame);
    }

    public boolean find(Criteria toSearch) {
        Frame frame = this.v.getFrame();
        if (frame == null) {
            return false;
        }
        if (this.findResults == null || this.findCriteria == null || !this.findCriteria.compareTo(toSearch)) {
            List selection;
            int i;
            this.findResults = new ArrayList<GraphNode>();
            this.findCriteria = toSearch;
            if (this.findCriteria.isLifeLineSelected()) {
                int i2 = 0;
                while (i2 < frame.lifeLinesCount()) {
                    if (this.findCriteria.matches(frame.getLifeline(i2).getName())) {
                        this.findResults.add((GraphNode)frame.getLifeline(i2));
                    }
                    ++i2;
                }
            }
            ArrayList<Object> msgs = new ArrayList<Object>();
            if (this.findCriteria.isSyncMessageSelected()) {
                i = 0;
                while (i < frame.syncMessageCount()) {
                    if (this.findCriteria.matches(frame.getSyncMessage(i).getName())) {
                        msgs.add(frame.getSyncMessage(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < frame.syncMessageReturnCount()) {
                    if (this.findCriteria.matches(frame.getSyncMessageReturn(i).getName())) {
                        msgs.add(frame.getSyncMessageReturn(i));
                    }
                    ++i;
                }
            }
            msgs = new ArrayList();
            if (this.findCriteria.isAsyncMessageSelected()) {
                i = 0;
                while (i < frame.asyncMessageCount()) {
                    if (this.findCriteria.matches(frame.getAsyncMessage(i).getName())) {
                        msgs.add(frame.getAsyncMessage(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < frame.asyncMessageReturnCount()) {
                    if (this.findCriteria.matches(frame.getAsyncMessageReturn(i).getName())) {
                        msgs.add(frame.getAsyncMessageReturn(i));
                    }
                    ++i;
                }
            }
            this.currentFindIndex = (selection = this.v.getSDWidget().getSelection()) != null && selection.size() == 1 ? this.findResults.indexOf(selection.get(0)) + 1 : 0;
        } else {
            ++this.currentFindIndex;
        }
        if (this.findResults.size() > this.currentFindIndex) {
            GraphNode current = this.findResults.get(this.currentFindIndex);
            this.v.getSDWidget().moveTo(current);
            return true;
        }
        return false;
    }

    public void cancel() {
        this.findResults = null;
        this.findCriteria = null;
        this.currentFindIndex = 0;
    }

    public boolean isLifelineSupported() {
        return false;
    }

    public boolean isSyncMessageSupported() {
        return false;
    }

    public boolean isSyncMessageReturnSupported() {
        return false;
    }

    public boolean isAsyncMessageSupported() {
        return false;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public Action getFindAction() {
        return null;
    }

    public boolean filter(List<FilterCriteria> filters) {
        Frame frame;
        if (this.savedFrame != null) {
            this.savedFrame = this.v.getFrame();
        }
        if ((frame = this.v.getFrame()) == null) {
            return false;
        }
        if (filters.size() != 1) {
            return false;
        }
        FilterCriteria filterCriteria = filters.get(0);
        boolean found = false;
        if (filterCriteria.getCriteria().isSyncMessageSelected()) {
            int i = 0;
            while (i < frame.syncMessageCount()) {
                if (filterCriteria.getCriteria().matches(frame.getSyncMessage(i).getName())) {
                    frame.getSyncMessage(i).setVisible(false);
                    found = true;
                }
                ++i;
            }
            i = 0;
            while (i < frame.syncMessageReturnCount()) {
                if (filterCriteria.getCriteria().matches(frame.getSyncMessageReturn(i).getName())) {
                    frame.getSyncMessageReturn(i).setVisible(false);
                    found = true;
                }
                ++i;
            }
        }
        this.v.getSDWidget().redraw();
        return found;
    }

    public ArrayList<?> getCurrentFilters() {
        return null;
    }

    public String getTitleString() {
        return "Test Loader";
    }

    public void dispose() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel != null && sel instanceof StructuredSelection) {
            StructuredSelection stSel = (StructuredSelection)sel;
            boolean cfr_ignored_0 = stSel.getFirstElement() instanceof HotSpot;
        }
    }

    public boolean isNodeSupported(int nodeType) {
        switch (nodeType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public String getNodeName(int nodeType, String loaderClassName) {
        return null;
    }

    public void firstPage() {
        this.page = 0;
        this.createFrame();
    }

    public void lastPage() {
        this.page = 2;
        this.createFrame();
    }

    public static class LocalImageImpl
    implements IImage {
        protected Image img = null;

        public LocalImageImpl(String file) {
            this.img = this.getResourceImage(file);
        }

        public LocalImageImpl(Image img_) {
            this.img = img_;
        }

        public Image getResourceImage(String _name) {
            try {
                URL BASIC_URL = new URL("platform", "localhost", "plugin");
                URL url = new URL(BASIC_URL, "plugin/org.eclipse.tracecompass.tmf.ui/icons/" + _name);
                ImageDescriptor imgage = ImageDescriptor.createFromURL((URL)url);
                return imgage.createImage();
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }

        public Object getImage() {
            return this.img;
        }

        public void dispose() {
            if (this.img != null) {
                this.img.dispose();
            }
        }
    }
}

