/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack.CallStack;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class CallStackTest
extends CallStackTestBase2 {
    private static final @NonNull IProgressMonitor MONITOR = new NullProgressMonitor();
    private static final long START_TIME = 1L;
    private static final long END_TIME = 20L;

    @Test
    public void testCallStackTraversal() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        Collection processes = callstack.getRootElements();
        Assert.assertEquals((long)2L, (long)processes.size());
        for (ICallStackElement element : processes) {
            Assert.assertNull((Object)element.getParentElement());
            switch (element.getName()) {
                case "1": {
                    Assert.assertEquals((long)1L, (long)element.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)1L, (long)element.getSymbolKeyAt(20L));
                    this.verifyProcess1(element);
                    break;
                }
                case "5": {
                    Assert.assertEquals((long)5L, (long)element.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)5L, (long)element.getSymbolKeyAt(20L));
                    this.verifyProcess5(element);
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown process in callstack");
                }
            }
        }
    }

    private void verifyProcess1(ICallStackElement element) {
        Collection children = element.getChildrenElements();
        IHostModel model = ModelManager.getModelFor((String)"");
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        for (ICallStackElement thread : children) {
            Assert.assertEquals((Object)element, (Object)thread.getParentElement());
            Assert.assertTrue((boolean)(thread instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)thread.isLeaf());
            Assert.assertNull((Object)thread.getNextGroup());
            CallStack callStack = ((InstrumentedCallStackElement)thread).getCallStack();
            switch (thread.getName()) {
                case "2": {
                    Assert.assertEquals((long)1L, (long)thread.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)1L, (long)thread.getSymbolKeyAt(20L));
                    Assert.assertEquals((long)1L, (long)callStack.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)1L, (long)callStack.getSymbolKeyAt(20L));
                    List callList = callStack.getCallListAtDepth(1, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)2L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)1L, (long)10L, (String)"op1", (int)1, (int)2, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)12L, (long)20L, (String)"op4", (int)1, (int)2, null, (IHostModel)model), callList.get(1));
                    callList = callStack.getCallListAtDepth(2, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)3L, (long)7L, (String)"op2", (int)1, (int)2, null, (IHostModel)model), callList.get(0));
                    callList = callStack.getCallListAtDepth(3, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)4L, (long)5L, (String)"op3", (int)1, (int)2, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(2)), (Object)callStack.getHostThread(1L));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(2)), (Object)callStack.getHostThread(20L));
                    break;
                }
                case "3": {
                    Assert.assertEquals((long)1L, (long)element.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)1L, (long)element.getSymbolKeyAt(20L));
                    Assert.assertEquals((long)1L, (long)callStack.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)1L, (long)callStack.getSymbolKeyAt(20L));
                    List callList = callStack.getCallListAtDepth(1, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)3L, (long)20L, (String)"op2", (int)1, (int)3, null, (IHostModel)model), callList.get(0));
                    callList = callStack.getCallListAtDepth(2, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)2L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)5L, (long)6L, (String)"op3", (int)1, (int)3, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)7L, (long)13L, (String)"op2", (int)1, (int)3, null, (IHostModel)model), callList.get(1));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(3)), (Object)callStack.getHostThread(1L));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(3)), (Object)callStack.getHostThread(20L));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown thread child of process 5");
                }
            }
        }
    }

    private void verifyProcess5(ICallStackElement element) {
        Collection children = element.getChildrenElements();
        IHostModel model = ModelManager.getModelFor((String)"");
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        for (ICallStackElement thread : children) {
            Assert.assertTrue((boolean)(thread instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)thread.isLeaf());
            Assert.assertNull((Object)thread.getNextGroup());
            CallStack callStack = ((InstrumentedCallStackElement)thread).getCallStack();
            switch (thread.getName()) {
                case "6": {
                    Assert.assertEquals((long)5L, (long)thread.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)5L, (long)thread.getSymbolKeyAt(20L));
                    Assert.assertEquals((long)5L, (long)callStack.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)5L, (long)callStack.getSymbolKeyAt(20L));
                    List callList = callStack.getCallListAtDepth(1, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)1L, (long)20L, (String)"op1", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    callList = callStack.getCallListAtDepth(2, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)3L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)2L, (long)7L, (String)"op3", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)8L, (long)11L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), callList.get(1));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)12L, (long)20L, (String)"op4", (int)1, (int)6, null, (IHostModel)model), callList.get(2));
                    callList = callStack.getCallListAtDepth(3, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)2L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)4L, (long)6L, (String)"op1", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)9L, (long)10L, (String)"op3", (int)1, (int)6, null, (IHostModel)model), callList.get(1));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(6)), (Object)callStack.getHostThread(1L));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(6)), (Object)callStack.getHostThread(20L));
                    break;
                }
                case "7": {
                    Assert.assertEquals((long)5L, (long)thread.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)5L, (long)thread.getSymbolKeyAt(20L));
                    Assert.assertEquals((long)5L, (long)callStack.getSymbolKeyAt(1L));
                    Assert.assertEquals((long)5L, (long)callStack.getSymbolKeyAt(20L));
                    List callList = callStack.getCallListAtDepth(1, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)1L, (long)20L, (String)"op5", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    callList = callStack.getCallListAtDepth(2, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)3L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)2L, (long)6L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)9L, (long)13L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), callList.get(1));
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)15L, (long)19L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), callList.get(2));
                    callList = callStack.getCallListAtDepth(3, 1L, 20L, 1L, MONITOR);
                    Assert.assertEquals((long)1L, (long)callList.size());
                    Assert.assertEquals((Object)CalledFunctionFactory.create((long)10L, (long)11L, (String)"op3", (int)1, (int)6, null, (IHostModel)model), callList.get(0));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(7)), (Object)callStack.getHostThread(1L));
                    Assert.assertEquals((Object)new HostThread(trace.getHostId(), Integer.valueOf(7)), (Object)callStack.getHostThread(20L));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown thread child of process 5");
                }
            }
        }
    }

    private CallStack getElementToTest() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        Collection processes = callstack.getRootElements();
        Assert.assertEquals((long)2L, (long)processes.size());
        Iterator processIt = processes.iterator();
        processIt.next();
        ICallStackElement process = (ICallStackElement)processIt.next();
        Assert.assertEquals((Object)"5", (Object)process.getName());
        Collection threads = process.getChildrenElements();
        Assert.assertEquals((long)2L, (long)threads.size());
        Iterator iterator = threads.iterator();
        iterator.next();
        ICallStackElement thread = (ICallStackElement)iterator.next();
        Assert.assertEquals((Object)"7", (Object)thread.getName());
        Assert.assertTrue((boolean)(thread instanceof InstrumentedCallStackElement));
        Assert.assertTrue((boolean)thread.isLeaf());
        return ((InstrumentedCallStackElement)thread).getCallStack();
    }

    @Test
    public void testCallStackRanges() {
        CallStack element = this.getElementToTest();
        int resolution = 1;
        List callList = element.getCallListAtDepth(2, 1L, 1L, (long)resolution, MONITOR);
        Assert.assertEquals((long)0L, (long)callList.size());
        callList = element.getCallListAtDepth(2, 1L, 2L, (long)resolution, MONITOR);
        Assert.assertEquals((long)1L, (long)callList.size());
        callList = element.getCallListAtDepth(2, 1L, 4L, (long)resolution, MONITOR);
        Assert.assertEquals((long)1L, (long)callList.size());
        callList = element.getCallListAtDepth(2, 4L, 10L, (long)resolution, MONITOR);
        Assert.assertEquals((long)2L, (long)callList.size());
        callList = element.getCallListAtDepth(2, 21L, 23L, (long)resolution, MONITOR);
        Assert.assertEquals((long)0L, (long)callList.size());
        callList = element.getCallListAtDepth(2, 1L, 20L, (long)resolution, MONITOR);
        Assert.assertEquals((long)3L, (long)callList.size());
    }

    @Test
    public void testCallStackNext() {
        CallStack element = this.getElementToTest();
        IHostModel model = ModelManager.getModelFor((String)"");
        ICalledFunction function = element.getNextFunction(1L, 2);
        Assert.assertNotNull((Object)function);
        Assert.assertEquals((Object)CalledFunctionFactory.create((long)2L, (long)6L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), (Object)function);
        function = element.getNextFunction(function.getEnd(), 2);
        Assert.assertNotNull((Object)function);
        Assert.assertEquals((Object)CalledFunctionFactory.create((long)9L, (long)13L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), (Object)function);
        function = element.getNextFunction(function.getEnd(), 2);
        Assert.assertNotNull((Object)function);
        Assert.assertEquals((Object)CalledFunctionFactory.create((long)15L, (long)19L, (String)"op2", (int)1, (int)6, null, (IHostModel)model), (Object)function);
        function = element.getNextFunction(function.getEnd(), 2);
        Assert.assertNull((Object)function);
    }
}

