/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventScopeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class StreamScopeParser
implements ICommonTreeParser {
    public static final StreamScopeParser INSTANCE = new StreamScopeParser();

    private StreamScopeParser() {
    }

    @Override
    public String parse(ICTFMetadataNode unused, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        List<@NonNull ICTFMetadataNode> lengthChildren = ((Param)param).fList;
        List<@NonNull ICTFMetadataNode> sublist = lengthChildren.subList(1, lengthChildren.size());
        ICTFMetadataNode nextElem = lengthChildren.get(1).getChild(0);
        String lengthName = null;
        if (TsdlUtils.isUnaryString(nextElem)) {
            lengthName = UnaryStringParser.INSTANCE.parse(nextElem, null);
        }
        String type = nextElem.getType();
        if (CTFParser.tokenNames[99].equals(lengthName)) {
            type = CTFParser.tokenNames[99];
        }
        if (CTFParser.tokenNames[38].equals(type)) {
            lengthName = TsdlUtils.concatenateUnaryStrings(sublist);
        } else if (CTFParser.tokenNames[99].equals(type)) {
            lengthName = EventScopeParser.INSTANCE.parse(null, new EventScopeParser.Param(sublist));
        } else if (lengthName == null) {
            throw new ParseException("Unsupported scope stream." + nextElem);
        }
        return "stream." + lengthName;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final List<ICTFMetadataNode> fList;

        public Param(List<ICTFMetadataNode> list) {
            this.fList = list;
        }
    }
}

