/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobDefinitionTest {
    private BlobDefinition fixture;
    private static final int LENGTH = 16;
    private static final @NonNull String MEDIA_TYPE = "\"application/octet-stream\"";
    private static final byte[] UUID_ARRAY = new byte[]{42, 100, 34, -48, 108, -18, 17, -32, -116, 8, -53, 7, -41, -77, -91, 100};

    @Before
    public void setUp() throws CTFException {
        String name = "testBlob";
        BlobDeclaration blobDec = new BlobDeclaration(16, MEDIA_TYPE);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        BitBuffer bb = new BitBuffer(byteBuffer);
        byteBuffer.mark();
        byteBuffer.put(UUID_ARRAY);
        byteBuffer.reset();
        this.fixture = blobDec.createDefinition(null, name, bb);
    }

    @Test
    public void testBlobDefinition() {
        BlobDeclaration declaration = new BlobDeclaration(16, MEDIA_TYPE);
        IDefinitionScope definitionScope = null;
        String fieldName = "";
        BlobDefinition result = new BlobDefinition((IDeclaration)declaration, definitionScope, fieldName, UUID_ARRAY, MEDIA_TYPE);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDeclaration() {
        BlobDeclaration result = this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetBytes() {
        byte[] result = this.fixture.getBytes();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStringValue() {
        String result = this.fixture.getStringValue();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertNotNull((Object)result);
    }
}

