/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.swslatency;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.swslatency.SWSLatencyAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.swslatency.SchedWS;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SWSLatencyTest {
    private static final String SWS_USAGE_FILE = "testfiles/sws_analysis.xml";
    private IKernelTrace fTrace;
    private SWSLatencyAnalysis fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        if (trace != null) {
            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
            File[] fileArray = suppDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(SWS_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        SWSLatencyTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fModule = (SWSLatencyAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, SWSLatencyAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.swslatency.sws");
        Assert.assertNotNull((Object)this.fModule);
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        this.fTrace = trace;
    }

    @After
    public void cleanup() {
        IKernelTrace testTrace = this.fTrace;
        if (testTrace != null) {
            testTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSmallTraceSequential() {
        SWSLatencyAnalysis swsModule = this.fModule;
        Assert.assertNotNull((Object)swsModule);
        @NonNull ISegmentStore segmentStore = swsModule.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((Object)false, (Object)segmentStore.isEmpty());
        Assert.assertEquals((long)5L, (long)segmentStore.size());
        ImmutableList info = ImmutableList.of((Object)new SchedWS.InitialInfo(0L, "proc1", 2), (Object)new SchedWS.InitialInfo(3L, "proc3", 3), (Object)new SchedWS.InitialInfo(6L, "proc4", 4), (Object)new SchedWS.InitialInfo(10L, "proc1", 1), (Object)new SchedWS.InitialInfo(3L, "proc2", 2));
        ImmutableList expected = ImmutableList.of((Object)new SchedWS((SchedWS.InitialInfo)info.get(0), 1L, 20), (Object)new SchedWS((SchedWS.InitialInfo)info.get(1), 5L, 0), (Object)new SchedWS((SchedWS.InitialInfo)info.get(2), 10L, 20), (Object)new SchedWS((SchedWS.InitialInfo)info.get(3), 15L, 20), (Object)new SchedWS((SchedWS.InitialInfo)info.get(4), 25L, 20));
        Iterator it = segmentStore.iterator();
        int i = 0;
        while (i < expected.size()) {
            if (it.hasNext()) {
                SchedWS segment = (SchedWS)it.next();
                long startTime = ((SchedWS)expected.get(i)).getStart();
                long endTime = ((SchedWS)expected.get(i)).getEnd();
                long duration = ((SchedWS)expected.get(i)).getLength();
                int threadID = ((SchedWS)expected.get(i)).getTid();
                int priority = ((SchedWS)expected.get(i)).getPriority();
                String name = ((SchedWS)expected.get(i)).getName();
                Assert.assertEquals((String)("Start time of the segment " + i), (long)startTime, (long)segment.getStart());
                Assert.assertEquals((String)("End time of the segment " + i), (long)endTime, (long)segment.getEnd());
                Assert.assertEquals((String)("Duration of the segment " + i), (long)duration, (long)segment.getLength());
                Assert.assertEquals((String)("TID in segment " + i), (long)threadID, (long)segment.getTid());
                Assert.assertEquals((String)("Priority of the process in segment " + i), (long)priority, (long)segment.getPriority());
                Assert.assertEquals((String)("Name of the process in segment " + i), (Object)name, (Object)segment.getName());
            }
            ++i;
        }
    }
}

