/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.indexer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.AbstractFileCheckpointCollection;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTreeCheckpointVisitor;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTreeNode;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTreeNodeCache;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.IBTreeVisitor;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.Messages;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;

public class BTree
extends AbstractFileCheckpointCollection {
    public static final String INDEX_FILE_NAME = "checkpoint_btree.idx";
    private static final int SUB_VERSION = 4;
    private static final boolean ALWAYS_CACHE_ROOT = true;
    private final int fMaxNumEntries;
    private final int fMaxNumChildren;
    private final int fMedianEntry;
    private BTreeHeader fBTreeHeader;
    private int nodeSize = -1;
    private final ByteBuffer fNodeByteBuffer;
    private final BTreeNodeCache fNodeCache;

    @Override
    protected AbstractFileCheckpointCollection.CheckpointCollectionFileHeader createHeader() {
        this.fBTreeHeader = new BTreeHeader(this.getVersion(), 4);
        return this.fBTreeHeader;
    }

    @Override
    protected AbstractFileCheckpointCollection.CheckpointCollectionFileHeader createHeader(RandomAccessFile randomAccessFile) throws IOException {
        this.fBTreeHeader = new BTreeHeader(randomAccessFile);
        return this.fBTreeHeader;
    }

    @Override
    protected int getSubVersion() {
        return 4;
    }

    public BTree(int degree, File file, ITmfPersistentlyIndexable trace) {
        super(file, trace);
        this.fMaxNumEntries = 2 * degree - 1;
        this.fMaxNumChildren = 2 * degree;
        this.fMedianEntry = degree - 1;
        this.fNodeByteBuffer = ByteBuffer.allocate(this.getNodeSize());
        this.fNodeByteBuffer.clear();
        this.fNodeCache = new BTreeNodeCache(this);
        BTreeNode rootNode = this.isCreatedFromScratch() ? this.allocateNode() : this.fNodeCache.getNode(this.fBTreeHeader.fRoot);
        this.setRootNode(rootNode);
    }

    @Override
    public void insert(ITmfCheckpoint checkpoint) {
        this.markDirty();
        this.insert(checkpoint, this.fBTreeHeader.fRoot, null, 0);
    }

    private void setRootNode(BTreeNode newRootNode) {
        this.fBTreeHeader.fRoot = newRootNode.getOffset();
        this.fNodeCache.setRootNode(newRootNode);
    }

    private void insert(ITmfCheckpoint checkpoint, long nodeOffset, BTreeNode pParent, int iParent) {
        BTreeNode parent = pParent;
        BTreeNode node = this.fNodeCache.getNode(nodeOffset);
        if (node.getEntry(this.fMaxNumEntries - 1) != null) {
            ITmfCheckpoint median = node.getEntry(this.fMedianEntry);
            if (median.compareTo(checkpoint) == 0) {
                return;
            }
            BTreeNode newnode = this.allocateNode();
            this.fNodeCache.addNode(newnode);
            long newNodeOffset = newnode.getOffset();
            int i = 0;
            while (i < this.fMedianEntry) {
                newnode.setEntry(i, node.getEntry(this.fMedianEntry + 1 + i));
                node.setEntry(this.fMedianEntry + 1 + i, null);
                newnode.setChild(i, node.getChild(this.fMedianEntry + 1 + i));
                node.setChild(this.fMedianEntry + 1 + i, -1L);
                ++i;
            }
            newnode.setChild(this.fMedianEntry, node.getChild(this.fMaxNumEntries));
            node.setChild(this.fMaxNumEntries, -1L);
            if (parent == null) {
                parent = this.allocateNode();
                this.setRootNode(parent);
                parent.setChild(0, nodeOffset);
            } else {
                i = this.fMaxNumEntries - 2;
                while (i >= iParent) {
                    ITmfCheckpoint r = parent.getEntry(i);
                    if (r != null) {
                        parent.setEntry(i + 1, r);
                        parent.setChild(i + 2, parent.getChild(i + 1));
                    }
                    --i;
                }
            }
            this.fNodeCache.getNode(parent.getOffset());
            parent.setEntry(iParent, median);
            parent.setChild(iParent + 1, newNodeOffset);
            node.setEntry(this.fMedianEntry, null);
            if (checkpoint.compareTo(median) > 0) {
                node = newnode;
            }
        }
        int lower = 0;
        int upper = this.fMaxNumEntries - 1;
        while (lower < upper && node.getEntry(upper - 1) == null) {
            --upper;
        }
        while (lower < upper) {
            int middle = (lower + upper) / 2;
            ITmfCheckpoint check = node.getEntry(middle);
            if (check == null) {
                upper = middle;
                continue;
            }
            int compare = check.compareTo(checkpoint);
            if (compare > 0) {
                upper = middle;
                continue;
            }
            if (compare < 0) {
                lower = middle + 1;
                continue;
            }
            return;
        }
        int i = lower;
        long child = node.getChild(i);
        if (child == -1L) {
            int j = this.fMaxNumEntries - 2;
            while (j >= i) {
                ITmfCheckpoint r = node.getEntry(j);
                if (r != null) {
                    node.setEntry(j + 1, r);
                }
                --j;
            }
            node.setEntry(i, checkpoint);
            AbstractFileCheckpointCollection.CheckpointCollectionFileHeader header = this.getHeader();
            ++header.fSize;
            return;
        }
        this.insert(checkpoint, child, node, i);
    }

    int getNodeSize() {
        if (this.nodeSize == -1) {
            this.nodeSize = 4;
            this.nodeSize += this.getTrace().getCheckpointSize() * this.fMaxNumEntries;
            this.nodeSize += 8 * this.fMaxNumChildren;
        }
        return this.nodeSize;
    }

    private BTreeNode allocateNode() {
        try {
            long offset = this.getRandomAccessFile().length();
            this.getRandomAccessFile().setLength(offset + (long)this.getNodeSize());
            BTreeNode node = new BTreeNode(this, offset);
            return node;
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.BTree_IOErrorAllocatingNode, this.getFile()), e);
            return null;
        }
    }

    @Override
    public long binarySearch(ITmfCheckpoint checkpoint) {
        BTreeCheckpointVisitor v = new BTreeCheckpointVisitor(checkpoint);
        this.accept(v);
        return v.getCheckpointRank();
    }

    public void accept(IBTreeVisitor treeVisitor) {
        this.accept(this.fBTreeHeader.fRoot, treeVisitor);
    }

    private void accept(long nodeOffset, IBTreeVisitor visitor) {
        int compare;
        if (nodeOffset == -1L || this.getRandomAccessFile() == null) {
            return;
        }
        BTreeNode node = this.fNodeCache.getNode(nodeOffset);
        int lower = 0;
        int upper = this.fMaxNumEntries - 1;
        while (lower < upper && node.getEntry(upper - 1) == null) {
            --upper;
        }
        while (lower < upper) {
            int middle = (lower + upper) / 2;
            ITmfCheckpoint middleCheckpoint = node.getEntry(middle);
            if (middleCheckpoint == null) {
                upper = middle;
                continue;
            }
            compare = visitor.compare(middleCheckpoint);
            if (compare == 0) {
                return;
            }
            if (compare > 0) {
                upper = middle;
                continue;
            }
            lower = middle + 1;
        }
        int i = lower;
        while (i < this.fMaxNumEntries) {
            ITmfCheckpoint record = node.getEntry(i);
            if (record == null) break;
            compare = visitor.compare(record);
            if (compare > 0) {
                this.accept(node.getChild(i), visitor);
                return;
            }
            if (compare == 0) {
                return;
            }
            ++i;
        }
        this.accept(node.getChild(i), visitor);
    }

    int getMaxNumEntries() {
        return this.fMaxNumEntries;
    }

    int getMaxNumChildren() {
        return this.fMaxNumChildren;
    }

    ByteBuffer getNodeByteBuffer() {
        return this.fNodeByteBuffer;
    }

    @Override
    public void dispose() {
        if (this.fNodeCache != null && this.getRandomAccessFile() != null) {
            this.fNodeCache.serialize();
        }
        super.dispose();
    }

    private class BTreeHeader
    extends AbstractFileCheckpointCollection.CheckpointCollectionFileHeader {
        private static final int SIZE = 12;
        private long fRoot;
        private final int fSubVersion;

        private BTreeHeader(int version, int subVersion) {
            super((AbstractFileCheckpointCollection)BTree.this, version);
            this.fSubVersion = subVersion;
        }

        private BTreeHeader(RandomAccessFile randomAccessFile) throws IOException {
            super((AbstractFileCheckpointCollection)BTree.this, randomAccessFile);
            this.fRoot = randomAccessFile.readLong();
            this.fSubVersion = randomAccessFile.readInt();
        }

        @Override
        public int getSubVersion() {
            return this.fSubVersion;
        }

        @Override
        public int getSize() {
            return 12 + super.getSize();
        }

        @Override
        public void serialize(RandomAccessFile randomAccessFile) throws IOException {
            super.serialize(randomAccessFile);
            randomAccessFile.writeLong(this.fRoot);
            randomAccessFile.writeInt(this.fSubVersion);
        }
    }
}

