/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateProviderCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtilsTest {
    private static final Path PATH_INVALID = new Path("test_xml_files/test_invalid");
    private static final Path PATH_VALID = new Path("test_xml_files/test_valid");

    @After
    public void emptyXmlFolder() {
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
    }

    @Test
    public void testXmlPath() {
        IPath xmlPath = XmlUtils.getXmlFilesPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath workspacePath = workspace.getRoot().getRawLocation();
        workspacePath = workspacePath.addTrailingSeparator().append(".metadata").addTrailingSeparator().append(".plugins").addTrailingSeparator().append("org.eclipse.tracecompass.tmf.analysis.xml.core").addTrailingSeparator().append("xml_files");
        Assert.assertEquals((Object)xmlPath, (Object)workspacePath);
    }

    @Test
    public void testXmlValidate() {
        IStatus status;
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (!(status = XmlUtils.xmlValidate((File)testXmlFile)).isOK()) {
            Assert.fail((String)status.getMessage());
        }
        if ((testXmlFile = TmfXmlTestFiles.INVALID_FILE.getFile()) == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        Assert.assertFalse((boolean)XmlUtils.xmlValidate((File)testXmlFile).isOK());
    }

    @Test
    public void testXmlValidateInvalid() {
        IPath path = Activator.getAbsolutePath(PATH_INVALID);
        File file = path.toFile();
        File[] invalidFiles = file.listFiles();
        Assert.assertTrue((invalidFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = invalidFiles;
        int n = invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertFalse((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlValidateValid() {
        IPath path = Activator.getAbsolutePath(PATH_VALID);
        File file = path.toFile();
        File[] validFiles = file.listFiles();
        Assert.assertTrue((validFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = validFiles;
        int n = validFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertTrue((String)("File " + f.getName()), (boolean)XmlUtils.xmlValidate((File)f).isOK());
            ++n2;
        }
    }

    @Test
    public void testXmlAddFile() {
        IPath xmlPath = XmlUtils.getXmlFilesPath().addTrailingSeparator().append("test_valid.xml");
        File destFile = xmlPath.toFile();
        Assert.assertFalse((boolean)destFile.exists());
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        Assert.assertTrue((boolean)destFile.exists());
    }

    @Test
    public void testXmlEnableDisableFile() {
        IPath xmlPath = XmlUtils.getXmlFilesPath().addTrailingSeparator().append("test_valid.xml");
        File destFile = xmlPath.toFile();
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        XmlUtils.addXmlFile((File)testXmlFile);
        Assert.assertTrue((boolean)destFile.exists());
        Assert.assertTrue((boolean)XmlUtils.isAnalysisEnabled((String)destFile.getName()));
        Assert.assertTrue((boolean)XmlUtils.getEnabledFiles().containsKey(destFile.getName()));
        XmlUtils.disableFiles((Iterable)ImmutableList.of((Object)destFile.getName()));
        Assert.assertFalse((boolean)XmlUtils.isAnalysisEnabled((String)destFile.getName()));
        Assert.assertFalse((boolean)XmlUtils.getEnabledFiles().containsKey(destFile.getName()));
    }

    @Test
    public void testGetChildElements() {
        String analysisId = "test.xml.conditions";
        File testXmlFile = TmfXmlTestFiles.CONDITION_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (testXmlFile == null) {
            return;
        }
        Element analysis = TmfXmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)analysisId);
        List childElements = XmlUtils.getChildElements((Node)analysis);
        Assert.assertEquals((long)5L, (long)childElements.size());
        for (Element element : childElements) {
            Assert.assertEquals((Object)"eventHandler", (Object)element.getNodeName());
            List children = XmlUtils.getChildElements((Node)element);
            Assert.assertEquals((long)1L, (long)children.size());
        }
    }

    public static @NonNull ITmfTrace initializeTrace(String traceFile) {
        TmfXmlTraceStubNs trace = TmfXmlTraceStubNs.setupTrace((IPath)Activator.getAbsolutePath(new Path(traceFile)));
        return trace;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull DataDrivenAnalysisModule initializeModule(TmfXmlTestFiles xmlAnalysisFile) {
        Document doc = xmlAnalysisFile.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        @NonNull List childElements = TmfXmlUtils.getChildElements((Element)doc.getDocumentElement(), (String)"stateProvider");
        Assert.assertFalse((boolean)childElements.isEmpty());
        Element element = (Element)childElements.get(0);
        String moduleId = element.getAttribute("id");
        TmfXmlStateProviderCu compile = TmfXmlStateProviderCu.compile((java.nio.file.Path)xmlAnalysisFile.getFile().toPath(), (String)moduleId);
        Assert.assertNotNull((Object)compile);
        DataDrivenAnalysisModule module = new DataDrivenAnalysisModule(moduleId, compile);
        return module;
    }

    public static @NonNull XmlPatternAnalysis initializePatternModule(TmfXmlTestFiles xmlAnalysisFile) {
        Document doc = xmlAnalysisFile.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList patternNodes = doc.getElementsByTagName("pattern");
        Assert.assertFalse((patternNodes.getLength() == 0 ? 1 : 0) != 0);
        Element node = (Element)patternNodes.item(0);
        String id = node.getAttribute("id");
        TmfXmlPatternCu patternCu = TmfXmlPatternCu.compile((Element)node);
        Assert.assertNotNull((Object)patternCu);
        XmlPatternAnalysis analysis = new XmlPatternAnalysis(id, patternCu);
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        analysis.setId(moduleId);
        return analysis;
    }

    public static void verifyStateIntervals(String testId, @NonNull ITmfStateSystem ss, Integer quark, int[] expectedStarts, ITmfStateValue[] expectedValues) throws AttributeNotFoundException, StateSystemDisposedException {
        int expectedCount = expectedStarts.length - 1;
        List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)expectedStarts[0], (long)expectedStarts[expectedCount]);
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)interval.getStateValue());
            ++i;
        }
    }

    public static void verifyStackStateIntervals(String testId, @NonNull ITmfStateSystem ss, Integer quark, int[] expectedStarts, ITmfStateValue[] expectedValues) throws AttributeNotFoundException, StateSystemDisposedException {
        int expectedCount = expectedStarts.length - 1;
        List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)expectedStarts[0], (long)expectedStarts[expectedCount]);
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            @Nullable ITmfStateInterval stackValueInterval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)interval.getStartTime(), (int)quark);
            Assert.assertNotNull((Object)stackValueInterval);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)stackValueInterval.getStateValue());
            ++i;
        }
    }

    public static void testPatternSegmentData(TmfXmlPatternSegment expected, TmfXmlPatternSegment actual) {
        Assert.assertEquals((String)"getStart", (long)expected.getStart(), (long)actual.getStart());
        Assert.assertEquals((String)"getEnd", (long)expected.getEnd(), (long)actual.getEnd());
        Assert.assertEquals((String)"getName", (Object)expected.getName(), (Object)actual.getName());
        Assert.assertNotNull((String)"getContent", (Object)actual.getContent());
        Assert.assertEquals((String)"content size", (long)expected.getContent().size(), (long)actual.getContent().size());
        Iterator<Map.Entry<K, @NonNull V>> it2 = expected.getContent().entrySet().iterator();
        int i = 0;
        while (i < expected.getContent().size()) {
            Map.Entry<K, @NonNull V> expectedContent = it2.next();
            Object actualValue = actual.getContent().get(expectedContent.getKey());
            Assert.assertNotNull((String)("Content " + (String)expectedContent.getKey() + " exists"), actualValue);
            Assert.assertEquals((String)("Content value comparison " + i), expectedContent.getValue(), actualValue);
            ++i;
        }
    }
}

