/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFoldExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFoldExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPackExpansion;

public class CPPASTFoldExpression
extends ASTNode
implements ICPPASTFoldExpression,
IASTAmbiguityParent {
    private final int fOperator;
    private final boolean fIsComma;
    private ICPPASTExpression fLhs;
    private ICPPASTExpression fRhs;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTFoldExpression(int operator, boolean isComma, IASTExpression lhs, IASTExpression rhs) {
        this.fOperator = operator;
        this.fIsComma = isComma;
        this.setOperand1(lhs);
        this.setOperand2(rhs);
    }

    private void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression != null) {
            if (!(expression instanceof ICPPASTExpression)) {
                throw new IllegalArgumentException(expression.getClass().getName());
            }
            expression.setParent(this);
        }
        this.fLhs = (ICPPASTExpression)expression;
    }

    public void setOperand2(IASTExpression operand) {
        this.assertNotFrozen();
        if (operand != null) {
            if (!(operand instanceof ICPPASTExpression)) {
                throw new IllegalArgumentException(operand.getClass().getName());
            }
            operand.setParent(this);
        }
        this.fRhs = (ICPPASTExpression)operand;
    }

    @Override
    public IASTExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public IASTExpression copy(IASTNode.CopyStyle style) {
        IASTExpression fLhsCopy = this.fLhs == null ? null : this.fLhs.copy(style);
        IASTExpression fRhsCopy = this.fRhs == null ? null : this.fRhs.copy(style);
        CPPASTFoldExpression copy = new CPPASTFoldExpression(this.fOperator, this.fIsComma, fLhsCopy, fRhsCopy);
        return this.copy(copy, style);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private int countUnexpandedParameterPacks(IASTExpression e) {
        if (e == null) {
            return 0;
        }
        UnexpandedParameterPackCounter counter = new UnexpandedParameterPackCounter();
        e.accept(counter);
        return counter.getCount();
    }

    private ICPPEvaluation computeEvaluation() {
        ICPPEvaluation packEval;
        ICPPEvaluation initEval;
        boolean isLeftFold;
        ICPPEvaluation evalR;
        int rhsParameterPackCount;
        int lhsParameterPackCount = this.countUnexpandedParameterPacks(this.fLhs);
        if (!(lhsParameterPackCount != 0 ^ (rhsParameterPackCount = this.countUnexpandedParameterPacks(this.fRhs)) != 0)) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation evalL = this.fLhs == null ? null : this.fLhs.getEvaluation();
        ICPPEvaluation iCPPEvaluation = evalR = this.fRhs == null ? null : this.fRhs.getEvaluation();
        if (lhsParameterPackCount == 0) {
            isLeftFold = true;
            initEval = evalL;
            packEval = evalR;
        } else {
            isLeftFold = false;
            initEval = evalR;
            packEval = evalL;
        }
        ICPPEvaluation[] foldPattern = new ICPPEvaluation[]{new EvalPackExpansion(packEval, this)};
        return new EvalFoldExpression(this.fOperator, this.fIsComma, isLeftFold, foldPattern, initEval, this);
    }

    @Override
    public IType getExpressionType() {
        return CPPEvaluation.getType(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return CPPEvaluation.getValueCategory(this);
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fLhs != null && !this.fLhs.accept(action)) {
            return false;
        }
        if (this.fRhs != null && !this.fRhs.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fLhs) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fLhs = (ICPPASTExpression)other;
        }
        if (child == this.fRhs) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fRhs = (ICPPASTExpression)other;
        }
    }

    private final class UnexpandedParameterPackCounter
    extends ASTVisitor {
        int count;

        public UnexpandedParameterPackCounter() {
            super(false);
            this.shouldVisitExpressions = true;
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int visit(IASTExpression expression) {
            if (expression instanceof ICPPASTPackExpansionExpression) {
                return 1;
            }
            IType type = expression.getExpressionType();
            if (type instanceof ICPPParameterPackType) {
                ++this.count;
            }
            return 3;
        }
    }
}

