/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTimeGraphCompositeDataProvider<M extends ITimeGraphEntryModel, P extends ITimeGraphDataProvider<M>>
extends TmfTreeCompositeDataProvider<M, P>
implements ITimeGraphDataProvider<M>,
IOutputStyleProvider {
    public TmfTimeGraphCompositeDataProvider(List<P> providers, String id) {
        super(providers, id);
    }

    public static @Nullable ITimeGraphDataProvider<ITimeGraphEntryModel> create(Collection<ITmfTrace> traces, String id) {
        return TmfTimeGraphCompositeDataProvider.create(traces, id, null);
    }

    public static @Nullable ITimeGraphDataProvider<ITimeGraphEntryModel> create(Collection<ITmfTrace> traces, String id, @Nullable String secondaryId) {
        String providerId = secondaryId == null ? id : String.valueOf(id) + ':' + secondaryId;
        ArrayList<@NonNull ITimeGraphDataProvider> providers = new ArrayList<ITimeGraphDataProvider>();
        for (ITmfTrace child : traces) {
            ITimeGraphDataProvider provider = DataProviderManager.getInstance().getDataProvider(child, providerId, ITimeGraphDataProvider.class);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITimeGraphDataProvider)providers.get(0);
        }
        return new TmfTimeGraphCompositeDataProvider(providers, providerId);
    }

    @Override
    public TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ImmutableList.Builder series = ImmutableList.builder();
        for (ITimeGraphDataProvider dataProvider : this.getProviders()) {
            TmfModelResponse<TimeGraphModel> response = dataProvider.fetchRowModel(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            TimeGraphModel model = response.getModel();
            if (model != null) {
                series.addAll(model.getRows());
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<TimeGraphModel>(new TimeGraphModel((List<ITimeGraphRowModel>)series.build()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<TimeGraphModel>(new TimeGraphModel((List<ITimeGraphRowModel>)series.build()), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ImmutableList.Builder series = ImmutableList.builder();
        for (ITimeGraphDataProvider dataProvider : this.getProviders()) {
            TmfModelResponse<List<ITimeGraphArrow>> response = dataProvider.fetchArrows(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            List<ITimeGraphArrow> model = response.getModel();
            if (model != null) {
                series.addAll(model);
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<ImmutableList>(series.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<ImmutableList>(series.build(), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
        for (ITimeGraphDataProvider dataProvider : this.getProviders()) {
            TmfModelResponse<Map<String, String>> response = dataProvider.fetchTooltip(fetchParameters, monitor);
            Map<String, String> tooltip = response.getModel();
            if (tooltip == null) continue;
            model.putAll(tooltip);
        }
        return new TmfModelResponse<Map<String, String>>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        HashMap<String, OutputElementStyle> styles = new HashMap<String, OutputElementStyle>();
        for (ITimeGraphDataProvider dataProvider : this.getProviders()) {
            TmfModelResponse<OutputStyleModel> response;
            OutputStyleModel model;
            if (!(dataProvider instanceof IOutputStyleProvider) || (model = (response = ((IOutputStyleProvider)((Object)dataProvider)).fetchStyle(fetchParameters, monitor)).getModel()) == null) continue;
            styles.putAll(model.getStyles());
        }
        if (styles.isEmpty()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<OutputStyleModel>(new OutputStyleModel(styles), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

