/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BufferedRandomAccessFileTest {
    private static final int FILESIZE = 256;
    private static final String LINE = "123456789abcdef\n";
    private static final int LENGTH = "123456789abcdef\n".length();
    private static File testFile;

    @BeforeClass
    public static void beforeClass() throws IOException {
        testFile = File.createTempFile("test", ".txt");
        FileWriter fw = new FileWriter(testFile);
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter bw = new BufferedWriter(fw);){
            int i = 0;
            while (i < 256 / LENGTH) {
                bw.write(LINE);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testRead() throws IOException {
        int pos;
        BufferedRandomAccessFile file;
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            file = new BufferedRandomAccessFile(testFile, "r", 16);
            try {
                Assert.assertEquals((long)256L, (long)file.length());
                pos = 0;
                while ((long)pos < file.length()) {
                    Assert.assertEquals((long)pos, (long)file.getFilePointer());
                    int c = file.read();
                    Assert.assertEquals((long)LINE.getBytes()[pos % 16], (long)c);
                    ++pos;
                }
                Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
                Assert.assertEquals((long)-1L, (long)file.read());
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            file = new BufferedRandomAccessFile(testFile, "r", 24);
            try {
                Assert.assertEquals((long)256L, (long)file.length());
                pos = 0;
                while ((long)pos < file.length()) {
                    byte[] b = new byte[LENGTH];
                    Assert.assertEquals((long)pos, (long)file.getFilePointer());
                    int num = file.read(b);
                    Assert.assertEquals((long)LENGTH, (long)num);
                    Assert.assertArrayEquals((byte[])LINE.getBytes(), (byte[])b);
                    pos += LENGTH;
                }
                Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
                Assert.assertEquals((long)-1L, (long)file.read(new byte[LENGTH]));
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            file = new BufferedRandomAccessFile(testFile, "r", 16);
            try {
                Assert.assertEquals((long)256L, (long)file.length());
                int off = LENGTH / 4;
                int len = LENGTH / 2;
                int pos2 = 0;
                while ((long)pos2 < file.length()) {
                    byte[] b = new byte[LENGTH];
                    Assert.assertEquals((long)pos2, (long)file.getFilePointer());
                    int num = file.read(b, off, len);
                    Assert.assertEquals((long)len, (long)num);
                    byte[] expected = new byte[LENGTH];
                    System.arraycopy(LINE.getBytes(), pos2 % 16, expected, off, len);
                    Assert.assertArrayEquals((byte[])expected, (byte[])b);
                    pos2 += len;
                }
                Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
                Assert.assertEquals((long)-1L, (long)file.read(new byte[LENGTH], off, len));
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testReadLine() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedRandomAccessFile file = new BufferedRandomAccessFile(testFile, "r", 8);){
            Assert.assertEquals((long)256L, (long)file.length());
            int pos = 0;
            while ((long)pos < file.length()) {
                Assert.assertEquals((long)pos, (long)file.getFilePointer());
                String line = file.readLine();
                Assert.assertEquals((Object)LINE.trim(), (Object)line);
                pos += LENGTH;
            }
            Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
            Assert.assertEquals(null, (Object)file.readLine());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSeekAndRead() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedRandomAccessFile file = new BufferedRandomAccessFile(testFile, "r", 8);){
            Assert.assertEquals((long)256L, (long)file.length());
            int i = 0;
            while ((long)i < file.length()) {
                int seek = i % 2 == 0 ? i / 2 : 255 - i / 2;
                file.seek((long)seek);
                int pos = seek;
                while ((long)pos < file.length()) {
                    Assert.assertEquals((long)pos, (long)file.getFilePointer());
                    int c = file.read();
                    Assert.assertEquals((long)LINE.getBytes()[pos % 16], (long)c);
                    ++pos;
                }
                ++i;
            }
            file.seek(file.length());
            Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
            Assert.assertEquals((long)-1L, (long)file.read());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSeekAndWrite() throws IOException {
        byte[] expected = new byte[257];
        expected[256] = -1;
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedRandomAccessFile file = new BufferedRandomAccessFile(File.createTempFile("test", ".txt"), "rw", 8);){
            Assert.assertEquals((long)0L, (long)file.length());
            int i = 0;
            while (i < 256) {
                int seek = i % 2 == 0 ? 255 - i / 2 : i / 2;
                file.seek((long)seek);
                byte b = LINE.getBytes()[seek % 16];
                file.write((int)b);
                expected[seek] = b;
                Assert.assertEquals((long)256L, (long)file.length());
                Assert.assertEquals((long)(seek + 1), (long)file.getFilePointer());
                int c = file.read();
                Assert.assertEquals((long)expected[seek + 1], (long)c);
                ++i;
            }
            file.seek(0L);
            int pos = 0;
            while ((long)pos < file.length()) {
                Assert.assertEquals((long)pos, (long)file.getFilePointer());
                int c = file.read();
                Assert.assertEquals((long)expected[pos], (long)c);
                ++pos;
            }
            Assert.assertEquals((long)file.length(), (long)file.getFilePointer());
            Assert.assertEquals((long)-1L, (long)file.read());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

