/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDAttributeDeclarationImpl;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDAttributeUseImpl
extends XSDComponentImpl
implements XSDAttributeUse {
    protected static final boolean REQUIRED_EDEFAULT = false;
    protected static final int REQUIRED_EFLAG = 256;
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;
    protected static final XSDConstraint CONSTRAINT_EDEFAULT = XSDConstraint.DEFAULT_LITERAL;
    protected static final int CONSTRAINT_EFLAG_OFFSET = 9;
    protected static final int CONSTRAINT_EFLAG_DEFAULT = CONSTRAINT_EDEFAULT.ordinal() << 9;
    private static final XSDConstraint[] CONSTRAINT_EFLAG_VALUES = XSDConstraint.values();
    protected static final int CONSTRAINT_EFLAG = 512;
    protected static final int CONSTRAINT_ESETFLAG = 1024;
    protected static final XSDAttributeUseCategory USE_EDEFAULT = XSDAttributeUseCategory.OPTIONAL_LITERAL;
    protected static final int USE_EFLAG_OFFSET = 11;
    protected static final int USE_EFLAG_DEFAULT = USE_EDEFAULT.ordinal() << 11;
    private static final XSDAttributeUseCategory[] USE_EFLAG_VALUES = XSDAttributeUseCategory.values();
    protected static final int USE_EFLAG = 6144;
    protected static final int USE_ESETFLAG = 8192;
    protected static final String LEXICAL_VALUE_EDEFAULT = null;
    protected String lexicalValue = LEXICAL_VALUE_EDEFAULT;
    protected XSDAttributeDeclaration attributeDeclaration;
    protected XSDAttributeDeclaration content;

    public static XSDAttributeUse createAttributeUse(Node node) {
        if (XSDConstants.nodeType(node) == 5) {
            XSDAttributeUse xsdAttributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            xsdAttributeUse.setElement((Element)node);
            XSDAttributeDeclaration xsdAttributeDeclaration = XSDAttributeDeclarationImpl.createAttributeDeclaration(node);
            xsdAttributeUse.setContent(xsdAttributeDeclaration);
            return xsdAttributeUse;
        }
        return null;
    }

    public static List<XSDAttributeUse> sortAttributeUses(Collection<XSDAttributeUse> xsdAttributeUses) {
        XSDAttributeUse[] objects = new XSDAttributeUse[xsdAttributeUses.size()];
        objects = xsdAttributeUses.toArray(objects);
        Arrays.sort(objects, new Comparator<XSDAttributeUse>(){
            Comparator<String> collator = XSDPlugin.INSTANCE.getComparator();

            @Override
            public boolean equals(Object that) {
                return this == that;
            }

            @Override
            public int compare(XSDAttributeUse o1, XSDAttributeUse o2) {
                String name1 = o1.getContent().getResolvedAttributeDeclaration().getName();
                String name2 = o2.getContent().getResolvedAttributeDeclaration().getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                if (name2 == null) {
                    return -1;
                }
                return this.collator.compare(name1, name2);
            }
        });
        return Arrays.asList(objects);
    }

    protected XSDAttributeUseImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ATTRIBUTE_USE;
    }

    @Override
    public boolean isRequired() {
        return (this.eFlags & 0x100) != 0;
    }

    @Override
    public void setRequired(boolean newRequired) {
        boolean oldRequired;
        boolean bl = oldRequired = (this.eFlags & 0x100) != 0;
        this.eFlags = newRequired ? (this.eFlags |= 0x100) : (this.eFlags &= 0xFFFFFEFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldRequired, newRequired));
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldValue, this.value));
        }
    }

    @Override
    public XSDConstraint getConstraint() {
        return CONSTRAINT_EFLAG_VALUES[(this.eFlags & 0x200) >>> 9];
    }

    @Override
    public void setConstraint(XSDConstraint newConstraint) {
        XSDConstraint oldConstraint = CONSTRAINT_EFLAG_VALUES[(this.eFlags & 0x200) >>> 9];
        if (newConstraint == null) {
            newConstraint = CONSTRAINT_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFDFF | newConstraint.ordinal() << 9;
        boolean oldConstraintESet = (this.eFlags & 0x400) != 0;
        this.eFlags |= 0x400;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldConstraint, (Object)newConstraint, !oldConstraintESet));
        }
    }

    @Override
    public void unsetConstraint() {
        XSDConstraint oldConstraint = CONSTRAINT_EFLAG_VALUES[(this.eFlags & 0x200) >>> 9];
        boolean oldConstraintESet = (this.eFlags & 0x400) != 0;
        this.eFlags = this.eFlags & 0xFFFFFDFF | CONSTRAINT_EFLAG_DEFAULT;
        this.eFlags &= 0xFFFFFBFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 7, (Object)oldConstraint, (Object)CONSTRAINT_EDEFAULT, oldConstraintESet));
        }
    }

    @Override
    public boolean isSetConstraint() {
        return (this.eFlags & 0x400) != 0;
    }

    @Override
    public XSDAttributeUseCategory getUse() {
        return USE_EFLAG_VALUES[(this.eFlags & 0x1800) >>> 11];
    }

    @Override
    public void setUse(XSDAttributeUseCategory newUse) {
        XSDAttributeUseCategory oldUse = USE_EFLAG_VALUES[(this.eFlags & 0x1800) >>> 11];
        if (newUse == null) {
            newUse = USE_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFE7FF | newUse.ordinal() << 11;
        boolean oldUseESet = (this.eFlags & 0x2000) != 0;
        this.eFlags |= 0x2000;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldUse, (Object)newUse, !oldUseESet));
        }
    }

    @Override
    public void unsetUse() {
        XSDAttributeUseCategory oldUse = USE_EFLAG_VALUES[(this.eFlags & 0x1800) >>> 11];
        boolean oldUseESet = (this.eFlags & 0x2000) != 0;
        this.eFlags = this.eFlags & 0xFFFFE7FF | USE_EFLAG_DEFAULT;
        this.eFlags &= 0xFFFFDFFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 8, (Object)oldUse, (Object)USE_EDEFAULT, oldUseESet));
        }
    }

    @Override
    public boolean isSetUse() {
        return (this.eFlags & 0x2000) != 0;
    }

    @Override
    public String getLexicalValue() {
        return this.lexicalValue;
    }

    @Override
    public void setLexicalValue(String newLexicalValue) {
        String oldLexicalValue = this.lexicalValue;
        this.lexicalValue = newLexicalValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLexicalValue, (Object)this.lexicalValue));
        }
    }

    @Override
    public XSDAttributeDeclaration getAttributeDeclaration() {
        return this.attributeDeclaration;
    }

    @Override
    public void setAttributeDeclaration(XSDAttributeDeclaration newAttributeDeclaration) {
        XSDAttributeDeclaration oldAttributeDeclaration = this.attributeDeclaration;
        this.attributeDeclaration = newAttributeDeclaration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldAttributeDeclaration, (Object)this.attributeDeclaration));
        }
    }

    @Override
    public XSDAttributeDeclaration getContent() {
        return this.content;
    }

    @Override
    public void setContent(XSDAttributeDeclaration newContent) {
        if (newContent != this.content) {
            NotificationChain msgs = null;
            if (this.content != null) {
                msgs = ((InternalEObject)this.content).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newContent != null) {
                msgs = ((InternalEObject)newContent).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetContent(newContent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newContent, (Object)newContent));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return this.basicSetContent(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain basicSetContent(XSDAttributeDeclaration newContent, NotificationChain msgs) {
        XSDAttributeDeclaration oldContent = this.content;
        this.content = newContent;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldContent, (Object)newContent);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.isRequired();
            }
            case 6: {
                return this.getValue();
            }
            case 7: {
                return this.getConstraint();
            }
            case 8: {
                return this.getUse();
            }
            case 9: {
                return this.getLexicalValue();
            }
            case 10: {
                return this.getAttributeDeclaration();
            }
            case 11: {
                return this.getContent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setRequired((Boolean)newValue);
                return;
            }
            case 6: {
                this.setValue(newValue);
                return;
            }
            case 7: {
                this.setConstraint((XSDConstraint)((Object)newValue));
                return;
            }
            case 8: {
                this.setUse((XSDAttributeUseCategory)((Object)newValue));
                return;
            }
            case 9: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 10: {
                this.setAttributeDeclaration((XSDAttributeDeclaration)newValue);
                return;
            }
            case 11: {
                this.setContent((XSDAttributeDeclaration)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setRequired(false);
                return;
            }
            case 6: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 7: {
                this.unsetConstraint();
                return;
            }
            case 8: {
                this.unsetUse();
                return;
            }
            case 9: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 10: {
                this.setAttributeDeclaration(null);
                return;
            }
            case 11: {
                this.setContent(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return (this.eFlags & 0x100) != 0;
            }
            case 6: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 7: {
                return this.isSetConstraint();
            }
            case 8: {
                return this.isSetUse();
            }
            case 9: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 10: {
                return this.attributeDeclaration != null;
            }
            case 11: {
                return this.content != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (required: ");
        result.append((this.eFlags & 0x100) != 0);
        result.append(", value: ");
        result.append(this.value);
        result.append(", constraint: ");
        if ((this.eFlags & 0x400) != 0) {
            result.append((Object)CONSTRAINT_EFLAG_VALUES[(this.eFlags & 0x200) >>> 9]);
        } else {
            result.append("<unset>");
        }
        result.append(", use: ");
        if ((this.eFlags & 0x2000) != 0) {
            result.append((Object)USE_EFLAG_VALUES[(this.eFlags & 0x1800) >>> 11]);
        } else {
            result.append("<unset>");
        }
        result.append(", lexicalValue: ");
        result.append(this.lexicalValue);
        result.append(')');
        return result.toString();
    }

    @Override
    public Element createElement() {
        Element newElement = null;
        XSDAttributeDeclaration theContent = this.getContent();
        if (theContent != null) {
            newElement = ((XSDConcreteComponentImpl)((Object)theContent)).createElement();
            this.setElement(newElement);
        }
        return newElement;
    }

    @Override
    protected void patch() {
        super.patch();
        this.patchHelper();
    }

    protected void patchHelper() {
        XSDAttributeDeclaration newAttributeDeclaration = this.getContent();
        if (newAttributeDeclaration != null) {
            newAttributeDeclaration = newAttributeDeclaration.getResolvedAttributeDeclaration();
        }
        if (newAttributeDeclaration != this.getAttributeDeclaration()) {
            this.setAttributeDeclaration(newAttributeDeclaration);
        }
    }

    @Override
    protected boolean analyze() {
        String theLexicalValue;
        super.analyze();
        Object newValue = null;
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getAttributeDeclaration().getTypeDefinition();
        if (xsdSimpleTypeDefinition != null && (theLexicalValue = this.getLexicalValue()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(this.getElement(), theLexicalValue);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (newValue == null ? this.getValue() != null : !newValue.equals(this.getValue())) {
            this.setValue(newValue);
        }
        return true;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getLexicalValue() != null) {
            XSDAttributeDeclaration theAttributeDeclaration = this.getAttributeDeclaration();
            XSDSimpleTypeDefinition theTypeDefinition = theAttributeDeclaration.getTypeDefinition();
            Element theElement = this.getElement();
            if (theTypeDefinition != null) {
                if (XSDConstants.isOrIsDerivedFromID(theTypeDefinition)) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attribute.3");
                } else {
                    this.checkSimpleTypeConstraint(theTypeDefinition, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", theElement, this.getConstraint() == XSDConstraint.FIXED_LITERAL ? "fixed" : "default", false);
                }
            }
            if (theAttributeDeclaration.getConstraint() == XSDConstraint.FIXED_LITERAL && theAttributeDeclaration.getLexicalValue() != null && (this.getConstraint() != XSDConstraint.FIXED_LITERAL || theTypeDefinition != null && !theTypeDefinition.equalLiterals(theAttributeDeclaration.getElement(), theAttributeDeclaration.getLexicalValue(), theElement, this.getLexicalValue()))) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attruse.2", this.getLexicalValue(), theAttributeDeclaration.getLexicalValue());
            }
            if (this.getConstraint() == XSDConstraint.DEFAULT_LITERAL && this.isSetUse() && this.getUse() != XSDAttributeUseCategory.OPTIONAL_LITERAL) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.2");
            }
        }
    }

    @Override
    protected Collection<Element> getContentNodes(Element changedElement) {
        return Collections.singleton(this.getElement());
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            XSDAttributeDeclaration theContent;
            XSDAttributeUseCategory newUse = null;
            if (this.getElement().hasAttributeNS(null, "use")) {
                newUse = XSDAttributeUseCategory.get(this.getElement().getAttributeNS(null, "use"));
            }
            boolean newRequired = false;
            XSDConstraint newConstraint = null;
            String newLexicalValue = null;
            if (newUse != XSDAttributeUseCategory.PROHIBITED_LITERAL) {
                boolean bl = newRequired = newUse == XSDAttributeUseCategory.REQUIRED_LITERAL;
                if (this.getElement().hasAttributeNS(null, "fixed")) {
                    newLexicalValue = this.getElement().getAttributeNS(null, "fixed");
                    if (newLexicalValue != null) {
                        newConstraint = XSDConstraint.FIXED_LITERAL;
                    }
                } else if (this.getElement().hasAttributeNS(null, "default") && (newLexicalValue = this.getElement().getAttributeNS(null, "default")) != null) {
                    newConstraint = XSDConstraint.DEFAULT_LITERAL;
                }
            }
            if (newUse == null) {
                if (this.isSetUse()) {
                    this.unsetUse();
                }
            } else if (!this.isSetUse() || newUse != this.getUse()) {
                this.setUse(newUse);
            }
            if (newRequired != this.isRequired()) {
                this.setRequired(newRequired);
            }
            if (newConstraint == null) {
                if (this.isSetConstraint()) {
                    this.unsetConstraint();
                }
            } else if (!this.isSetConstraint() || newConstraint != this.getConstraint()) {
                this.setConstraint(newConstraint);
            }
            if (newLexicalValue == null ? this.getLexicalValue() != null : !newLexicalValue.equals(this.getLexicalValue())) {
                this.setLexicalValue(newLexicalValue);
            }
            if ((theContent = this.getContent()) != null) {
                theContent.elementAttributesChanged(changedElement);
            }
        }
    }

    @Override
    protected void reconcileContents(Element changedElement) {
        XSDAttributeDeclaration theContent;
        super.reconcileContents(changedElement);
        if (changedElement == this.getElement() && (theContent = this.getContent()) != null) {
            theContent.elementContentsChanged(changedElement);
            XSDAttributeDeclaration newAttributeDeclaration = theContent.getResolvedAttributeDeclaration();
            if (newAttributeDeclaration != this.getAttributeDeclaration()) {
                this.setAttributeDeclaration(newAttributeDeclaration);
            }
        }
    }

    @Override
    protected void changeAttribute(EAttribute eAttribute) {
        block12: {
            Element theElement;
            block13: {
                if (this.isReconciling) {
                    return;
                }
                super.changeAttribute(eAttribute);
                theElement = this.getElement();
                if (theElement == null) break block12;
                if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_ATTRIBUTE_USE__USE) {
                    this.niceSetAttribute(theElement, "use", this.isSetUse() ? this.getUse().getName() : null);
                }
                if (eAttribute != null && eAttribute != XSDPackage.Literals.XSD_FEATURE__LEXICAL_VALUE && eAttribute != XSDPackage.Literals.XSD_ATTRIBUTE_USE__CONSTRAINT) break block12;
                if (this.getLexicalValue() == null) break block13;
                switch (this.getConstraint().getValue()) {
                    case 1: {
                        this.niceSetAttribute(theElement, "fixed", this.getLexicalValue());
                        if (theElement.hasAttributeNS(null, "default")) {
                            this.niceSetAttribute(theElement, "default", null);
                            break;
                        }
                        break block12;
                    }
                    case 0: {
                        this.niceSetAttribute(theElement, "default", this.getLexicalValue());
                        if (!theElement.hasAttributeNS(null, "fixed")) break block12;
                        this.niceSetAttribute(theElement, "fixed", null);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block12;
            }
            if (theElement.hasAttributeNS(null, "fixed")) {
                this.niceSetAttribute(theElement, "fixed", null);
            }
            if (theElement.hasAttributeNS(null, "default")) {
                this.niceSetAttribute(theElement, "default", null);
            }
        }
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_USE__CONTENT) {
            this.patchHelper();
            this.traverseToRootForPatching();
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_USE__CONTENT) {
            this.patchHelper();
            this.traverseToRootForPatching();
        }
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeUseImpl clonedAttributeUse = (XSDAttributeUseImpl)this.getXSDFactory().createXSDAttributeUse();
        clonedAttributeUse.isReconciling = true;
        if (this.isSetUse()) {
            clonedAttributeUse.setUse(this.getUse());
        }
        clonedAttributeUse.setRequired(this.isRequired());
        if (this.isSetConstraint()) {
            clonedAttributeUse.setConstraint(this.getConstraint());
        }
        if (this.getLexicalValue() != null) {
            clonedAttributeUse.setLexicalValue(this.getLexicalValue());
        }
        clonedAttributeUse.setContent((XSDAttributeDeclaration)this.getContent().cloneConcreteComponent(deep, shareDOM));
        if (shareDOM && this.getElement() != null) {
            clonedAttributeUse.setElement(this.getElement());
        }
        clonedAttributeUse.isReconciling = shareDOM;
        return clonedAttributeUse;
    }
}

