/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser;

import java.util.Objects;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.eclipse.jdt.annotation.Nullable;

public class CliOption {
    private static final String DEFAULT_ARG_NAME = "arg";
    private final String fShortOption;
    private final @Nullable String fLongOption;
    private final @Nullable String fDescription;
    private final int fMinArguments;
    private final int fMaxArguments;
    private final String fArgumentName;

    public static CliOption createSimpleOption(String optionShort, @Nullable String optionLong, @Nullable String optionDescription) {
        return new CliOption(optionShort, optionLong, optionDescription, 0, 0, DEFAULT_ARG_NAME);
    }

    public static CliOption createOptionWithArgs(String optionShort, @Nullable String optionLong, @Nullable String optionDescription, boolean mandatory, boolean multiple, String argName) {
        return new CliOption(optionShort, optionLong, optionDescription, mandatory ? 1 : 0, multiple ? Integer.MAX_VALUE : 1, argName);
    }

    private CliOption(String optionShort, @Nullable String optionLong, @Nullable String optionDescription, int min, int max, String argName) {
        this.fShortOption = optionShort;
        this.fLongOption = optionLong;
        this.fDescription = optionDescription;
        this.fMinArguments = Math.min(min, max);
        this.fMaxArguments = Math.max(min, max);
        this.fArgumentName = argName;
    }

    Option toCliOption() {
        OptionBuilder.withArgName((String)this.fArgumentName);
        if (this.fMaxArguments == 0) {
            OptionBuilder.hasArg((boolean)false);
        } else if (this.fMaxArguments == 1) {
            if (this.fMinArguments == 0) {
                OptionBuilder.hasOptionalArg();
            } else {
                OptionBuilder.hasArg();
            }
        } else if (this.fMaxArguments < Integer.MAX_VALUE) {
            if (this.fMinArguments == 0) {
                OptionBuilder.hasOptionalArgs((int)this.fMaxArguments);
            } else {
                OptionBuilder.hasArgs((int)this.fMaxArguments);
            }
        } else if (this.fMinArguments == 0) {
            OptionBuilder.hasOptionalArgs();
        } else {
            OptionBuilder.hasArgs();
        }
        if (this.fLongOption != null) {
            OptionBuilder.withLongOpt((String)this.fLongOption);
        }
        if (this.fDescription != null) {
            OptionBuilder.withDescription((String)this.fDescription);
        }
        return Objects.requireNonNull(OptionBuilder.create((String)this.fShortOption));
    }

    public String toString() {
        return String.valueOf('-') + this.fShortOption;
    }
}

