/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.ILttngRelaydConnector;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachSessionRequest;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.Command;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.CreateSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.GetMetadata;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.GetNextIndex;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.GetPacket;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IndexResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ListSessionsResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.MetadataPacketResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.NewStreamsResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.NextIndexReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.SeekCommand;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.SessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.StreamResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.TracePacketResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ViewerCommand;

public class LttngRelaydConnector_2_4
implements ILttngRelaydConnector {
    private final @NonNull DataInputStream fInNet;
    private final @NonNull DataOutputStream fOutNet;

    public LttngRelaydConnector_2_4(@NonNull DataInputStream inNet, @NonNull DataOutputStream outNet) {
        this.fInNet = inNet;
        this.fOutNet = outNet;
    }

    @Override
    public void close() throws IOException {
        this.fInNet.close();
        this.fOutNet.close();
    }

    @Override
    public List<SessionResponse> getSessions() throws IOException {
        ViewerCommand listSessionsCmd = new ViewerCommand(Command.VIEWER_LIST_SESSIONS, 0L, 0);
        this.fOutNet.write(listSessionsCmd.serialize());
        this.fOutNet.flush();
        return new ListSessionsResponse(this.fInNet).getSessionsList();
    }

    @Override
    public CreateSessionResponse createSession() throws IOException {
        ViewerCommand listSessionsCmd = new ViewerCommand(Command.VIEWER_CREATE_SESSION, 0L, 0);
        this.fOutNet.write(listSessionsCmd.serialize());
        this.fOutNet.flush();
        return new CreateSessionResponse(this.fInNet);
    }

    @Override
    public AttachSessionResponse attachToSession(SessionResponse lttngViewerSession) throws IOException {
        ViewerCommand listSessionsCmd = new ViewerCommand(Command.VIEWER_ATTACH_SESSION, 0L, 0);
        this.fOutNet.write(listSessionsCmd.serialize());
        AttachSessionRequest attachRequest = new AttachSessionRequest(lttngViewerSession.getId(), SeekCommand.VIEWER_SEEK_LAST);
        this.fOutNet.write(attachRequest.serialize());
        this.fOutNet.flush();
        return new AttachSessionResponse(this.fInNet);
    }

    @Override
    public String getMetadata(AttachSessionResponse attachedSession) throws IOException {
        for (StreamResponse stream : attachedSession.getStreamList()) {
            if (stream.getMetadataFlag() != 1) continue;
            this.issueCommand(Command.VIEWER_GET_METADATA);
            GetMetadata metadataRequest = new GetMetadata(stream.getId());
            this.fOutNet.write(metadataRequest.serialize());
            this.fOutNet.flush();
            MetadataPacketResponse metaDataPacket = new MetadataPacketResponse(this.fInNet);
            return new String(metaDataPacket.getData());
        }
        return null;
    }

    @Override
    public TracePacketResponse getPacketFromStream(IndexResponse index, long id) throws IOException {
        this.issueCommand(Command.VIEWER_GET_PACKET);
        GetPacket packetRequest = new GetPacket(id, index.getOffset(), (int)(index.getPacketSize() / 8L));
        this.fOutNet.write(packetRequest.serialize());
        this.fOutNet.flush();
        return new TracePacketResponse(this.fInNet);
    }

    @Override
    public TracePacketResponse getNextPacket(StreamResponse stream) throws IOException {
        IndexResponse indexReply = this.getNextIndex(stream);
        TracePacketResponse packet = null;
        if (indexReply.getStatus() == NextIndexReturnCode.VIEWER_INDEX_OK) {
            packet = this.getPacketFromStream(indexReply, stream.getId());
        }
        return packet;
    }

    @Override
    public IndexResponse getNextIndex(StreamResponse stream) throws IOException {
        this.issueCommand(Command.VIEWER_GET_NEXT_INDEX);
        GetNextIndex indexRequest = new GetNextIndex(stream.getId());
        this.fOutNet.write(indexRequest.serialize());
        this.fOutNet.flush();
        return new IndexResponse(this.fInNet);
    }

    public List<StreamResponse> getNewStreams() throws IOException {
        Command viewerGetNewStreams = Command.VIEWER_GET_NEW_STREAMS;
        this.issueCommand(viewerGetNewStreams);
        return new NewStreamsResponse(this.fInNet).getStreamList();
    }

    private void issueCommand(Command command) throws IOException {
        ViewerCommand connectCommand = new ViewerCommand(command, 20L, 0);
        this.fOutNet.write(connectCommand.serialize());
        this.fOutNet.flush();
    }
}

