/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IProjectActionFilter;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.OverlayIcon;
import org.eclipse.ui.internal.ide.model.WorkbenchResource;

public class WorkbenchProject
extends WorkbenchResource
implements IProjectActionFilter {
    HashMap<String, ImageDescriptor> imageCache = new HashMap(11);

    @Override
    protected ImageDescriptor getBaseImage(IResource resource) {
        String baseKey;
        IProject project = (IProject)resource;
        boolean isOpen = project.isOpen();
        String string = baseKey = isOpen ? "IMG_OBJ_PROJECT" : "IMG_OBJ_PROJECT_CLOSED";
        if (isOpen) {
            try {
                String[] stringArray = project.getDescription().getNatureIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String imageKey = stringArray[n2];
                    Object overlayImage = this.imageCache.get(imageKey);
                    if (overlayImage != null) {
                        return overlayImage;
                    }
                    ImageDescriptor natureImage = IDEWorkbenchPlugin.getDefault().getProjectImageRegistry().getNatureImage(imageKey);
                    if (natureImage != null) {
                        ImageDescriptor baseImage = IDEInternalWorkbenchImages.getImageDescriptor(baseKey);
                        overlayImage = new OverlayIcon(baseImage, new ImageDescriptor[][]{{natureImage}}, new Point(16, 16));
                        this.imageCache.put(imageKey, (ImageDescriptor)overlayImage);
                        return overlayImage;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        return IDEInternalWorkbenchImages.getImageDescriptor(baseKey);
    }

    public Object[] getChildren(Object o) {
        IProject project = (IProject)o;
        if (project.isOpen()) {
            try {
                return project.members();
            }
            catch (CoreException coreException) {}
        }
        return NO_CHILDREN;
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        if (!(target instanceof IProject)) {
            return false;
        }
        IProject proj = (IProject)target;
        if (name.equals("nature")) {
            try {
                return proj.isAccessible() && proj.hasNature(value);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (name.equals("open")) {
            value = value.toLowerCase();
            return proj.isOpen() == value.equals("true");
        }
        return super.testAttribute(target, name, value);
    }
}

