/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs;

import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphBuilder;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;

public class GraphFactory {
    public static final IGraphWorker Actor0 = new TestGraphWorker(0);
    public static final TestGraphWorker Actor1 = new TestGraphWorker(1);
    private static final String LINK_QUALIFIER = "testLinkQualifier";
    public static final GraphBuilder GRAPH_BASIC = new GraphBuilder("basic"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            return this.build();
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            return this.build();
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_SELF = new GraphBuilder("wakeup_self"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            TmfVertex vStart = new TmfVertex(1L);
            graph.append(Actor0, vStart, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            TmfVertex vEnd = new TmfVertex(3L);
            graph.append(Actor0, vEnd, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING);
            TmfEdge link = vStart.linkVertical(vEnd);
            link.setType(TmfEdge.EdgeType.TIMER);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.append(Actor0, new TmfVertex(3L), TmfEdge.EdgeType.TIMER);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(3L), TmfEdge.EdgeType.TIMER);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_MISSING = new GraphBuilder("wakeup_missing"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.BLOCKED, GraphFactory.LINK_QUALIFIER);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.BLOCKED, GraphFactory.LINK_QUALIFIER);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_UNKNOWN = new GraphBuilder("wakeup_unknown"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex vIn = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, vIn, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            TmfVertex vNet = new TmfVertex(3L);
            graph.add((IGraphWorker)Actor1, vNet);
            graph.link(vNet, vIn, TmfEdge.EdgeType.NETWORK);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            TmfVertex vStartBlock = new TmfVertex(2L);
            TmfVertex vEndBlock = new TmfVertex(4L);
            graph.append(Actor0, vStartBlock, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, vEndBlock);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            TmfVertex vStartOther = new TmfVertex(2L);
            TmfVertex vEndOther = new TmfVertex(3L);
            graph.add((IGraphWorker)Actor1, vStartOther);
            graph.append((IGraphWorker)Actor1, vEndOther, TmfEdge.EdgeType.UNKNOWN);
            graph.link(vStartBlock, vStartOther);
            graph.link(vEndOther, vEndBlock, TmfEdge.EdgeType.NETWORK);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            TmfVertex vStartBlock = new TmfVertex(3L);
            TmfVertex vEndBlock = new TmfVertex(4L);
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, vStartBlock, TmfEdge.EdgeType.UNKNOWN);
            graph.add(Actor0, vEndBlock);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            TmfEdge link = vStartBlock.linkVertical(vEndBlock);
            link.setType(TmfEdge.EdgeType.NETWORK);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_NEW = new GraphBuilder("wakeup_new"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex vSrcLink = new TmfVertex(2L);
            TmfVertex vBlockEnd = new TmfVertex(6L);
            TmfVertex vDstLink = new TmfVertex(3L);
            TmfVertex vWakeup = new TmfVertex(6L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, vSrcLink, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.append(Actor0, vBlockEnd, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(8L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.add((IGraphWorker)Actor1, vDstLink);
            graph.append((IGraphWorker)Actor1, vWakeup, TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.link(vSrcLink, vDstLink);
            graph.link(vWakeup, vBlockEnd);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex vBlockStart = new TmfVertex(4L);
            TmfVertex vBlockEnd = new TmfVertex(6L);
            TmfVertex vDstLink = new TmfVertex(4L);
            TmfVertex vWakeup = new TmfVertex(6L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, vBlockStart, TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.add(Actor0, vBlockEnd);
            graph.append(Actor0, new TmfVertex(8L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.add((IGraphWorker)Actor1, vDstLink);
            graph.append((IGraphWorker)Actor1, vWakeup, TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.link(vBlockStart, vDstLink);
            graph.link(vWakeup, vBlockEnd);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex vSrcLink = new TmfVertex(2L);
            TmfVertex vBlockEnd = new TmfVertex(6L);
            TmfVertex vDstLink = new TmfVertex(3L);
            TmfVertex vWakeup = new TmfVertex(6L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, vSrcLink, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, vBlockEnd);
            graph.append(Actor0, new TmfVertex(8L), TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.add((IGraphWorker)Actor1, vDstLink);
            graph.append((IGraphWorker)Actor1, vWakeup, TmfEdge.EdgeType.RUNNING, GraphFactory.LINK_QUALIFIER);
            graph.link(vSrcLink, vDstLink);
            graph.link(vWakeup, vBlockEnd);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_OPENED_DELAY = new GraphBuilder("opened"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(3L), TmfEdge.EdgeType.RUNNING);
            TmfVertex v1 = new TmfVertex(6L);
            graph.append(Actor0, v1, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(9L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, new TmfVertex(0L));
            TmfVertex v2 = new TmfVertex(2L);
            graph.append((IGraphWorker)Actor1, v2, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.link(v2, v1);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            TmfVertex v1 = new TmfVertex(3L);
            graph.append(Actor0, v1, TmfEdge.EdgeType.RUNNING);
            TmfVertex v2 = new TmfVertex(3L);
            TmfVertex v3 = new TmfVertex(6L);
            graph.add((IGraphWorker)Actor1, v2);
            graph.add(Actor0, v3);
            graph.link(v1, v2);
            graph.link(v2, v3);
            graph.append(Actor0, new TmfVertex(9L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_OPENED = new GraphBuilder("opened"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(3L), TmfEdge.EdgeType.RUNNING);
            TmfVertex v1 = new TmfVertex(6L);
            graph.append(Actor0, v1, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(9L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, new TmfVertex(0L));
            TmfVertex v2 = new TmfVertex(6L);
            graph.append((IGraphWorker)Actor1, v2, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, new TmfVertex(9L), TmfEdge.EdgeType.RUNNING);
            graph.link(v2, v1);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            graph.add(Actor0, new TmfVertex(0L));
            TmfVertex v1 = new TmfVertex(3L);
            graph.append(Actor0, v1, TmfEdge.EdgeType.RUNNING);
            TmfVertex v2 = new TmfVertex(3L);
            TmfVertex v3 = new TmfVertex(6L);
            graph.add((IGraphWorker)Actor1, v2);
            graph.append((IGraphWorker)Actor1, v3, TmfEdge.EdgeType.RUNNING);
            TmfVertex v4 = new TmfVertex(6L);
            graph.add(Actor0, v4);
            graph.link(v1, v2);
            graph.link(v3, v4);
            graph.append(Actor0, new TmfVertex(9L), TmfEdge.EdgeType.RUNNING);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_MUTUAL = new GraphBuilder("wakeup_mutual"){

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Wakeup = new TmfVertex(2L);
            TmfVertex v0Unblock = new TmfVertex(4L);
            TmfVertex v1Unblock = new TmfVertex(2L);
            TmfVertex v1Wakeup = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0Wakeup, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(3L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0Unblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, new TmfVertex(0L));
            graph.append((IGraphWorker)Actor1, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, v1Unblock, TmfEdge.EdgeType.BLOCKED);
            graph.append((IGraphWorker)Actor1, new TmfVertex(3L), TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, v1Wakeup, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.link(v0Wakeup, v1Unblock);
            graph.link(v1Wakeup, v0Unblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0StartBlock = new TmfVertex(3L);
            TmfVertex v0EndBlock = new TmfVertex(4L);
            TmfVertex v1StartBlock = new TmfVertex(3L);
            TmfVertex v1EndBlock = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0StartBlock, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0EndBlock);
            graph.append(Actor0, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1StartBlock);
            graph.append((IGraphWorker)Actor1, v1EndBlock, TmfEdge.EdgeType.RUNNING);
            graph.link(v0StartBlock, v1StartBlock);
            graph.link(v1EndBlock, v0EndBlock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Wakeup = new TmfVertex(2L);
            TmfVertex v0Unblock = new TmfVertex(4L);
            TmfVertex v1Unblock = new TmfVertex(2L);
            TmfVertex v1Wakeup = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0Wakeup, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0Unblock);
            graph.append(Actor0, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1Unblock);
            graph.append((IGraphWorker)Actor1, new TmfVertex(3L), TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, v1Wakeup, TmfEdge.EdgeType.RUNNING);
            graph.link(v0Wakeup, v1Unblock);
            graph.link(v1Wakeup, v0Unblock);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_EMBEDDED = new GraphBuilder("wakeup_embeded"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0FirstFork = new TmfVertex(2L);
            TmfVertex v0SecondFork = new TmfVertex(4L);
            TmfVertex v0FirstUnblock = new TmfVertex(8L);
            TmfVertex v0SecondUnblock = new TmfVertex(10L);
            TmfVertex v1In = new TmfVertex(4L);
            TmfVertex v1Out = new TmfVertex(8L);
            TmfVertex v2In = new TmfVertex(2L);
            TmfVertex v2Out = new TmfVertex(10L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, v0FirstFork, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0SecondFork, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0FirstUnblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, v0SecondUnblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Out, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Out, TmfEdge.EdgeType.RUNNING);
            graph.link(v0FirstFork, v2In);
            graph.link(v0SecondFork, v1In);
            graph.link(v1Out, v0FirstUnblock);
            graph.link(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0StartBlock = new TmfVertex(6L);
            TmfVertex v0FirstUnblock = new TmfVertex(8L);
            TmfVertex v0SecondUnblock = new TmfVertex(10L);
            TmfVertex v1In = new TmfVertex(6L);
            TmfVertex v1Out = new TmfVertex(8L);
            TmfVertex v2In = new TmfVertex(8L);
            TmfVertex v2Out = new TmfVertex(10L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0StartBlock, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0FirstUnblock);
            graph.add(Actor0, v0SecondUnblock);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Out, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Out, TmfEdge.EdgeType.RUNNING);
            graph.link(v0StartBlock, v1In);
            graph.link(v1Out, v0FirstUnblock);
            graph.link(v0FirstUnblock, v2In);
            graph.link(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_INTERLEAVE = new GraphBuilder("wakeup_interleave"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0FirstFork = new TmfVertex(2L);
            TmfVertex v0SecondFork = new TmfVertex(4L);
            TmfVertex v0FirstUnblock = new TmfVertex(8L);
            TmfVertex v0SecondUnblock = new TmfVertex(10L);
            TmfVertex v1In = new TmfVertex(2L);
            TmfVertex v1Out = new TmfVertex(8L);
            TmfVertex v2In = new TmfVertex(4L);
            TmfVertex v2Out = new TmfVertex(10L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, v0FirstFork, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0SecondFork, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(6L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0FirstUnblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, v0SecondUnblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Out, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Out, TmfEdge.EdgeType.RUNNING);
            graph.link(v0FirstFork, v1In);
            graph.link(v0SecondFork, v2In);
            graph.link(v1Out, v0FirstUnblock);
            graph.link(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0StartBlock = new TmfVertex(6L);
            TmfVertex v0FirstUnblock = new TmfVertex(8L);
            TmfVertex v0SecondUnblock = new TmfVertex(10L);
            TmfVertex v1In = new TmfVertex(6L);
            TmfVertex v1Out = new TmfVertex(8L);
            TmfVertex v2In = new TmfVertex(8L);
            TmfVertex v2Out = new TmfVertex(10L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(2L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, new TmfVertex(4L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0StartBlock, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0FirstUnblock);
            graph.add(Actor0, v0SecondUnblock);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Out, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Out, TmfEdge.EdgeType.RUNNING);
            graph.link(v0StartBlock, v1In);
            graph.link(v1Out, v0FirstUnblock);
            graph.link(v0FirstUnblock, v2In);
            graph.link(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_NESTED = new GraphBuilder("wakeup_nested"){
        private final TestGraphWorker fActor2 = new TestGraphWorker(2);
        private final TestGraphWorker fActor3 = new TestGraphWorker(3);

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Fork = new TmfVertex(1L);
            TmfVertex v0Return = new TmfVertex(6L);
            TmfVertex v1In = new TmfVertex(1L);
            TmfVertex v1Fork = new TmfVertex(2L);
            TmfVertex v1Return = new TmfVertex(5L);
            TmfVertex v1End = new TmfVertex(6L);
            TmfVertex v2In = new TmfVertex(2L);
            TmfVertex v2Fork = new TmfVertex(3L);
            TmfVertex v2Return = new TmfVertex(4L);
            TmfVertex v2End = new TmfVertex(5L);
            TmfVertex v3In = new TmfVertex(3L);
            TmfVertex v3End = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, v0Fork, TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0Return, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(7L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Fork, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, v1Return, TmfEdge.EdgeType.BLOCKED);
            graph.append((IGraphWorker)Actor1, v1End, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Fork, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)this.fActor2, v2Return, TmfEdge.EdgeType.BLOCKED);
            graph.append((IGraphWorker)this.fActor2, v2End, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor3, v3In);
            graph.append((IGraphWorker)this.fActor3, v3End, TmfEdge.EdgeType.RUNNING);
            graph.link(v0Fork, v1In);
            graph.link(v1Fork, v2In);
            graph.link(v2Fork, v3In);
            graph.link(v3End, v2Return);
            graph.link(v2End, v1Return);
            graph.link(v1End, v0Return);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Fork = new TmfVertex(1L);
            TmfVertex v0Return = new TmfVertex(6L);
            TmfVertex v1In = new TmfVertex(1L);
            TmfVertex v1Fork = new TmfVertex(2L);
            TmfVertex v1Return = new TmfVertex(5L);
            TmfVertex v1End = new TmfVertex(6L);
            TmfVertex v2In = new TmfVertex(2L);
            TmfVertex v2Fork = new TmfVertex(3L);
            TmfVertex v2Return = new TmfVertex(4L);
            TmfVertex v2End = new TmfVertex(5L);
            TmfVertex v3In = new TmfVertex(3L);
            TmfVertex v3End = new TmfVertex(4L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, v0Fork, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0Return);
            graph.append(Actor0, new TmfVertex(7L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1In);
            graph.append((IGraphWorker)Actor1, v1Fork, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1Return);
            graph.append((IGraphWorker)Actor1, v1End, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2In);
            graph.append((IGraphWorker)this.fActor2, v2Fork, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2Return);
            graph.append((IGraphWorker)this.fActor2, v2End, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor3, v3In);
            graph.append((IGraphWorker)this.fActor3, v3End, TmfEdge.EdgeType.RUNNING);
            graph.link(v0Fork, v1In);
            graph.link(v1Fork, v2In);
            graph.link(v2Fork, v3In);
            graph.link(v3End, v2Return);
            graph.link(v2End, v1Return);
            graph.link(v1End, v0Return);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            return this.criticalPathBounded();
        }
    };
    public static final GraphBuilder GRAPH_NET1 = new GraphBuilder("wakeup_net1"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);
        private TestGraphWorker fActor3 = new TestGraphWorker(3);

        @Override
        public TmfGraph build() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Unblock = new TmfVertex(11L);
            TmfVertex v1Send = new TmfVertex(4L);
            TmfVertex v2Rcv = new TmfVertex(7L);
            TmfVertex v2Send = new TmfVertex(8L);
            TmfVertex v3Rcv = new TmfVertex(10L);
            TmfVertex v3End = new TmfVertex(11L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, new TmfVertex(1L), TmfEdge.EdgeType.RUNNING);
            graph.append(Actor0, v0Unblock, TmfEdge.EdgeType.BLOCKED);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, new TmfVertex(3L));
            graph.append((IGraphWorker)Actor1, v1Send, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)Actor1, new TmfVertex(5L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, new TmfVertex(6L));
            graph.append((IGraphWorker)this.fActor2, v2Rcv, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)this.fActor2, v2Send, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor3, new TmfVertex(9L));
            graph.append((IGraphWorker)this.fActor3, v3Rcv, TmfEdge.EdgeType.RUNNING);
            graph.append((IGraphWorker)this.fActor3, v3End, TmfEdge.EdgeType.RUNNING);
            graph.link(v1Send, v2Rcv, TmfEdge.EdgeType.NETWORK);
            graph.link(v2Send, v3Rcv, TmfEdge.EdgeType.NETWORK);
            graph.link(v3End, v0Unblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathBounded() {
            TmfGraph graph = new TmfGraph();
            TmfVertex v0Fork = new TmfVertex(1L);
            TmfVertex v0Unblock = new TmfVertex(11L);
            TmfVertex v1Start = new TmfVertex(1L);
            TmfVertex v1Send = new TmfVertex(4L);
            TmfVertex v2Rcv = new TmfVertex(7L);
            TmfVertex v2Send = new TmfVertex(8L);
            TmfVertex v3Rcv = new TmfVertex(10L);
            TmfVertex v3End = new TmfVertex(11L);
            graph.add(Actor0, new TmfVertex(0L));
            graph.append(Actor0, v0Fork, TmfEdge.EdgeType.RUNNING);
            graph.add(Actor0, v0Unblock);
            graph.append(Actor0, new TmfVertex(12L), TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)Actor1, v1Start);
            graph.append((IGraphWorker)Actor1, new TmfVertex(3L), TmfEdge.EdgeType.UNKNOWN);
            graph.append((IGraphWorker)Actor1, v1Send, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor2, v2Rcv);
            graph.append((IGraphWorker)this.fActor2, v2Send, TmfEdge.EdgeType.RUNNING);
            graph.add((IGraphWorker)this.fActor3, v3Rcv);
            graph.append((IGraphWorker)this.fActor3, v3End, TmfEdge.EdgeType.RUNNING);
            graph.link(v0Fork, v1Start);
            graph.link(v1Send, v2Rcv, TmfEdge.EdgeType.NETWORK);
            graph.link(v2Send, v3Rcv, TmfEdge.EdgeType.NETWORK);
            graph.link(v3End, v0Unblock);
            return graph;
        }

        @Override
        public TmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
}

