/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.table;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;

public class TmfVirtualTableModel<L extends VirtualTableLine>
implements ITmfVirtualTableModel<L> {
    private final List<Long> fColumnIds;
    private final List<L> fLines;
    private final long fLowIndex;
    private final long fSize;

    public TmfVirtualTableModel(List<Long> columnIds, List<L> data, long index, long nbTotalEvents) {
        this.fLowIndex = index;
        this.fColumnIds = ImmutableList.copyOf(columnIds);
        this.fLines = ImmutableList.copyOf(data);
        this.fSize = nbTotalEvents;
    }

    @Override
    public List<Long> getColumnIds() {
        return this.fColumnIds;
    }

    @Override
    public List<L> getLines() {
        return this.fLines;
    }

    @Override
    public long getIndex() {
        return this.fLowIndex;
    }

    @Override
    public long getSize() {
        return this.fSize;
    }

    public int hashCode() {
        return Objects.hash(this.fLowIndex, this.fSize, this.fColumnIds, this.fLines);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfVirtualTableModel other = (TmfVirtualTableModel)obj;
        return this.fLowIndex == other.getIndex() && this.fSize == other.getSize() && this.fColumnIds.equals(other.fColumnIds) && this.fLines.equals(other.fLines);
    }

    public String toString() {
        return "Column Ids: " + this.fColumnIds + ", Data: " + this.fLines + ", Index: " + this.fLowIndex + ", Total nb of events: " + this.fSize;
    }
}

