/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.text.Format;
import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

@Deprecated
public class TmfCommonXLineChartTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    private XYToolTipHandler fToolTipHandler = new XYToolTipHandler();

    public TmfCommonXLineChartTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.fToolTipHandler.activateHoverHelp((Control)this.getChart().getPlotArea());
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.fToolTipHandler.deactivateHoverHelp((Control)this.getChart().getPlotArea());
        }
    }

    @Override
    public void refresh() {
    }

    @Deprecated
    public void mouseEnter(MouseEvent e) {
    }

    @Deprecated
    public void mouseExit(MouseEvent e) {
    }

    @Deprecated
    public void mouseHover(MouseEvent e) {
    }

    private final class XYToolTipHandler
    extends TmfAbstractToolTipHandler {
        private static final String HTML_COLOR_TOOLTIP = "<span style=\"color:%s;\">%s</span>";

        private XYToolTipHandler() {
        }

        private boolean isValid(int index, ISeries serie) {
            double[] ySeries = serie.getYSeries();
            return serie.isVisible() && ySeries != null && ySeries.length > index;
        }

        @Override
        public void fill(Control control, MouseEvent event, Point pt) {
            if (TmfCommonXLineChartTooltipProvider.this.getChartViewer().getWindowDuration() != 0L) {
                Chart chart = TmfCommonXLineChartTooltipProvider.this.getChart();
                IAxisSet axisSet = chart.getAxisSet();
                IAxis xAxis = axisSet.getXAxis(0);
                double xCoordinate = xAxis.getDataCoordinate(pt.x);
                ISeries[] series = TmfCommonXLineChartTooltipProvider.this.getChart().getSeriesSet().getSeries();
                if (xCoordinate < 0.0 || series.length == 0) {
                    return;
                }
                double[] xS = series[0].getXSeries();
                if (xS == null) {
                    return;
                }
                int index = Arrays.binarySearch(xS, xCoordinate);
                index = index >= 0 ? index : -index - 1;
                int maxLen = 0;
                ISeries[] iSeriesArray = series;
                int n = series.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries serie = iSeriesArray[n2];
                    if (this.isValid(index, serie)) {
                        maxLen = Math.max(maxLen, serie.getId().length());
                    }
                    ++n2;
                }
                TmfCommonXAxisChartViewer viewer = null;
                Format format = null;
                ITmfChartTimeProvider timeProvider = TmfCommonXLineChartTooltipProvider.this.getChartViewer();
                if (timeProvider instanceof TmfCommonXAxisChartViewer) {
                    viewer = (TmfCommonXAxisChartViewer)timeProvider;
                    format = viewer.getSwtChart().getAxisSet().getYAxes()[0].getTick().getFormat();
                }
                ITmfTimestamp time = TmfTimestamp.fromNanos((long)((long)xCoordinate + TmfCommonXLineChartTooltipProvider.this.getChartViewer().getTimeOffset()));
                this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfCommonXLineChartTooltipProvider_time), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(time.toString(), time.toNanos()));
                ISeries[] iSeriesArray2 = series;
                int n3 = series.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISeries serie = iSeriesArray2[n4];
                    double[] yS = serie.getYSeries();
                    if (this.isValid(index, serie)) {
                        String key = serie.getId();
                        Color color = this.getSeriesColor(serie);
                        if (key != null && color != null) {
                            RGBA rgba = color.getRGBA();
                            RGBAColor rgbaColor = new RGBAColor(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
                            key = String.format(HTML_COLOR_TOOLTIP, rgbaColor, key);
                        }
                        if (key == null) {
                            key = "";
                        }
                        double yValue = yS[index];
                        if (format == null) {
                            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml(key), TmfAbstractToolTipHandler.ToolTipString.fromDecimal(yValue));
                        } else {
                            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml(key), TmfAbstractToolTipHandler.ToolTipString.fromString(format.format(yValue)));
                        }
                    }
                    ++n4;
                }
            }
        }

        private @Nullable Color getSeriesColor(ISeries series) {
            if (series instanceof IBarSeries) {
                return ((IBarSeries)series).getBarColor();
            }
            if (series instanceof ILineSeries) {
                return ((ILineSeries)series).getLineColor();
            }
            return null;
        }
    }
}

