/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterWithNot;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;

public abstract class TmfFilterAspectNode
extends TmfFilterTreeNode
implements ITmfFilterWithNot {
    public static final String EVENT_ASPECT_ATTR = "eventaspect";
    public static final String TRACE_TYPE_ID_ATTR = "tracetypeid";
    public static final String FIELD_ATTR = "field";
    public static final String BASE_ASPECT_ID = "BASE.ASPECT.ID";
    protected ITmfEventAspect<?> fEventAspect;
    private String fTraceTypeId;
    private boolean fNot;

    public TmfFilterAspectNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public ITmfEventAspect<?> getEventAspect() {
        return this.fEventAspect;
    }

    public void setEventAspect(ITmfEventAspect<?> aspect) {
        this.fEventAspect = aspect;
    }

    public String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    public void setTraceTypeId(String traceTypeId) {
        this.fTraceTypeId = traceTypeId;
    }

    public String getAspectLabel(boolean explicit) {
        String field;
        if (this.fEventAspect == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.fEventAspect.getName());
        if (explicit) {
            sb.append('[');
            sb.append(this.fTraceTypeId);
            sb.append(']');
        }
        if (this.fEventAspect instanceof TmfEventFieldAspect && (field = ((TmfEventFieldAspect)this.fEventAspect).getFieldPath()) != null && !field.isEmpty()) {
            if (field.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(field);
        }
        return sb.toString();
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterAspectNode clone = (TmfFilterAspectNode)super.clone();
        clone.setEventAspect(this.fEventAspect);
        clone.setTraceTypeId(this.fTraceTypeId);
        return clone;
    }

    @Override
    public boolean isNot() {
        return this.fNot;
    }

    @Override
    public void setNot(boolean not) {
        this.fNot = not;
    }
}

