/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class DataProviderDescriptorTest {
    private static final String DESCRIPTION = "Description";
    private static final String ID = "my.data.provider.id";
    private static final String NAME = "Data Provider Name";
    private static final IDataProviderDescriptor.ProviderType TYPE = IDataProviderDescriptor.ProviderType.TIME_GRAPH;

    @Test
    public void testEquality() {
        DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
        builder.setDescription(DESCRIPTION).setId(ID).setName(NAME).setProviderType(TYPE);
        IDataProviderDescriptor baseDescriptor = builder.build();
        Assert.assertTrue((boolean)baseDescriptor.equals(builder.build()));
        String sameId = ID;
        builder.setDescription(DESCRIPTION).setId(sameId).setName(NAME).setProviderType(TYPE);
        Assert.assertTrue((boolean)baseDescriptor.equals(builder.build()));
        builder.setDescription("Other description").setId(ID).setName(NAME).setProviderType(TYPE);
        Assert.assertFalse((boolean)baseDescriptor.equals(builder.build()));
        builder.setDescription(DESCRIPTION).setId("other id").setName(NAME).setProviderType(TYPE);
        Assert.assertFalse((boolean)baseDescriptor.equals(builder.build()));
        builder.setDescription(DESCRIPTION).setId(ID).setName("other name").setProviderType(TYPE);
        Assert.assertFalse((boolean)baseDescriptor.equals(builder.build()));
        builder.setDescription(DESCRIPTION).setId(ID).setName(NAME).setProviderType(IDataProviderDescriptor.ProviderType.TABLE);
        Assert.assertFalse((boolean)baseDescriptor.equals(builder.build()));
    }
}

