/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.contextswitch;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.contextswitch.KernelContextSwitchAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContextSwitchProviderTest {
    private static final String CPU_USAGE_FILE = "testfiles/cpu_analysis.xml";
    private ITmfTrace fTrace;
    private KernelContextSwitchAnalysis fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(CPU_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        ContextSwitchProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fModule = (KernelContextSwitchAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelContextSwitchAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.contextswitch");
        Assert.assertNotNull((Object)this.fModule);
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        ContextSwitchProviderTest.deleteSuppFiles(this.fTrace);
        this.fTrace.dispose();
    }

    @Test
    public void testAnalysisExecution() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fModule));
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testReturnedStateSystem() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((long)1L, (long)ss.getStartTime());
        Assert.assertEquals((long)25L, (long)ss.getCurrentEndTime());
        try {
            int cpusQuark = ss.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ss.getSubAttributes(cpusQuark, false);
            Assert.assertEquals((long)2L, (long)cpuQuarks.size());
            int proc2Quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0"});
            ITmfStateInterval interval = ss.querySingleState(2L, proc2Quark);
            Assert.assertEquals((long)1L, (long)interval.getStartTime());
            Assert.assertEquals((long)19L, (long)interval.getEndTime());
            List state = ss.queryFullState(25L);
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0"});
            Assert.assertEquals((long)3L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "1"});
            Assert.assertEquals((long)5L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            state = ss.queryFullState(19L);
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0"});
            Assert.assertEquals((long)1L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "1"});
            Assert.assertEquals((long)4L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUsageInRange() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        HashMap<Integer, Long> expected = new HashMap<Integer, Long>();
        expected.put(0, 2L);
        expected.put(1, 6L);
        expected.put(-1, 8L);
        Map resultMap = this.fModule.getContextSwitchesRange(0L, 30L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put(0, 1L);
        expected.put(1, 0L);
        expected.put(-1, 1L);
        resultMap = this.fModule.getContextSwitchesRange(22L, 25L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put(0, 0L);
        expected.put(1, 2L);
        expected.put(-1, 2L);
        resultMap = this.fModule.getContextSwitchesRange(1L, 4L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put(0, 0L);
        expected.put(1, 2L);
        expected.put(-1, 2L);
        resultMap = this.fModule.getContextSwitchesRange(4L, 13L);
        Assert.assertEquals(expected, (Object)resultMap);
    }

    @Test
    public void testInvalid() {
        Map resultMap = this.fModule.getContextSwitchesRange(0L, 30L);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)resultMap);
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        resultMap = this.fModule.getContextSwitchesRange(30L, 0L);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)resultMap);
        resultMap = this.fModule.getContextSwitchesRange(0L, 0L);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)resultMap);
        resultMap = this.fModule.getContextSwitchesRange(-30L, 0L);
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)resultMap);
    }
}

